#ifndef __LIGHT_H__
#define __LIGHT_H__

////////////////////////////////////////////////////////////////////////////////
//  Abstract light source                                                     //  
//  LAST EDIT: Fri Aug  5 08:55:19 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "vector.h"
#include "camera.h"
#include "surface.h"
#include "color.h"
#include "rlist.h"
#include "object.h"
#include "predattr.h"
#include "ident.h"

#ifdef RTD_RSY
#include "rsy/rsyscene.h"
#endif

extern RT_IdentGenerator rt_LightIdents;

extern const char *RTN_LIGHT;

class RT_Light:public RT_Object {
    int xon;
    RT_Vector xorigin;
    static RT_ParseEntry table[];
    //#### the statics for parameter parsing:
    static int orgF, orgG, onF, offF, onG, colrF, colrG;
    static RT_Vector orgV;
    static RT_Color colrV;
    RT_Color xcolor; 
    // the private color attr
  public:
    //#### Tcl/C++ methods:
    RT_Light(char *_name):RT_Object( _name) { 
	xcolor = RT_Color( 1,1,1);
	xon = 1;
    }
    virtual ~RT_Light() { rt_Objects->specialRemove( RTN_SCENE, this ); }

    int isA(const char *c) const { return RTM_isA( c, RTN_LIGHT ) || RT_Object::isA( c );}

    void print(FILE *) const; 

    void on() { xon = 1; }
    void off() { xon = 0; }
    int get_on() const { return xon; }

    void origin(const RT_Vector &o) { xorigin = o; }
    const RT_Vector &get_origin() const { return xorigin; }

    void color(const RT_Color &s) { xcolor = s; }
    const RT_Color &get_color() const { return xcolor; }

    //#### shader interface:
    virtual void render() = 0;

    //#### raytracer interface:
    virtual RT_Color shade( const RT_Vector &P, const RT_Vector &N, const RT_Vector &R, 
			   const RT_Surface &SURFACE, const RT_Camera *CAMERA ) = 0;
    // P - surface point
    // N - normal vector
    // R - reflexion vector
    // V - view vector

#ifdef RTD_RSY
    //#### radiosity interface:
    virtual void toRSY(RT_RSYScene*) = 0;
#endif

    //#### the Tcl commands:
    int objectCMD( char *[]);
};

#endif
