#ifndef __LOWLEVEL_H__
#define __LOWLEVEL_H__

////////////////////////////////////////////////////////////////////////////////
//  Headers of often used low level graphics functions, especially virtual    //
//  display list management.                                                  //
//  LAST EDIT: Fri Aug  5 08:55:19 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "matrix.h" 

void RT_dlOpen(long);
// open a display list

void RT_dlClose(long);
// close display list

void RT_dlDelete(long);
// delete display list

void RT_dlMatrix(const RT_Matrix&);
// set global matrix

void RT_dlUnMatrix();
// remove the global matrix from stack
// some graphics libs need that

void RT_dlSurface(const RT_Surface &);
// set global surface props

void RT_dlCall(long);
// call the display list

#endif
