#ifndef __MACROS_H__
#define __MACROS_H__

////////////////////////////////////////////////////////////////////////////////
// Macro-definitions                                                          //  
// LAST EDIT: Fri Aug  5 08:55:18 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

//
// World <--> Modelling conversions:
//

// World Coordinates Ray -> Modeling Coordinates Ray:
#define RTM_wcRay2mcRay( wcr, mcr ) mcr.pt = wc2mc( wcr.pt );\
mcr.dir = (wc2mc( wcr.pt + wcr.dir) - mcr.pt).UNITIZE()

// MC Displacement -> MC Displacement:
#define RTM_mcT2wcT( wcr, mcr, wct, mct ) \
{ RT_Vector wcend = mc2wc( mcr.pt + mcr.dir * mct ); wct = (wcend - wcr.pt ).ABS();\
      RT_Vector xx = wcr.pt + wcr.dir * wct; if (xx == wcend) ; else wct *= -1; }

// MC normal -> WC normal
#define RTM_mcN2wcN(wcp, mcn, wcr) wcr = (mc2wc(wc2mc(wcp)+mcn)-wcp).UNITIZE()

//
// Object stuff:
//

#define RTM_isA(c1, c2) (c1 == c2 || !strcmp( c1, c2 ))

// return macro for class cmd's:
#define RTM_classReturn Tcl_SetResult( ip, argv[1], 0 ); return TCL_OK

//
// Tcl command stuff:
// 

#define RTM_command(a,b) Tcl_CreateCommand (rt_Ip, (char*)a, b, 0, 0 )
#define RTM_primCommand(a,b) Tcl_CreateCommand (rt_Ip, (char*)a, b, 0, 0 ); rt_PrimitiveClassList += a; rt_PrimitiveClassList += ' '
// "RTM_primCommand" can only be used in global.C

#endif
