#include "matrix.h"
#include "math.h"
////////////////////////////////////////////////////////////////////////////////
//  Matrix functions implementations.                                         //  
//  LAST EDIT: Fri Aug  5 08:55:12 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

const RT_Modelling rt_Modelling; 

// this function build the invers matrix:
RT_Matrix RT_Matrix::INVERS() const {
    RT_Matrix im;
    double a0 = val[0][0];
    double a1 = val[0][1];
    double a2 = val[0][2];
    double a3 = val[0][3];
    double a4 = val[1][0];
    double a5 = val[1][1];
    double a6 = val[1][2];
    double a7 = val[1][3];
    double a8 = val[2][0];
    double a9 = val[2][1];
    double a10 = val[2][2];
    double a11 = val[2][3];
    double a12 = val[3][0];
    double a13 = val[3][1];
    double a14 = val[3][2];
    double a15 = val[3][3];
    double a1a11a14a4 = a1*a11*a14*a4;
    double a1a10a15a4 = a1*a10*a15*a4;
    double a11a13a2a4 = a11*a13*a2*a4;
    double a10a13a3a4 = a10*a13*a3*a4;
    double a0a11a14a5 = a0*a11*a14*a5;
    double a0a10a15a5 = a0*a10*a15*a5;
    double a11a12a2a5 = a11*a12*a2*a5;
    double a10a12a3a5 = a10*a12*a3*a5;
    double a1a11a12a6 = a1*a11*a12*a6;
    double a0a11a13a6 = a0*a11*a13*a6;
    double a1a10a12a7 = a1*a10*a12*a7;
    double a0a10a13a7 = a0*a10*a13*a7;
    double a15a2a5a8 = a15*a2*a5*a8;
    double a14a3a5a8 = a14*a3*a5*a8;
    double a1a15a6a8 = a1*a15*a6*a8;
    double a13a3a6a8 = a13*a3*a6*a8;
    double a1a14a7a8 = a1*a14*a7*a8;
    double a13a2a7a8 = a13*a2*a7*a8;
    double a15a2a4a9 = a15*a2*a4*a9;
    double a14a3a4a9 = a14*a3*a4*a9;
    double a0a15a6a9 = a0*a15*a6*a9;
    double a12a3a6a9 = a12*a3*a6*a9;
    double a0a14a7a9 = a0*a14*a7*a9;
    double a12a2a7a9 = a12*a2*a7*a9;
    double a11a14a5 = a11*a14*a5;
    double a10a15a5 = a10*a15*a5;
    double  a11a13a6 = a11*a13*a6;
    double a10a13a7 = a10*a13*a7;
    double a15a6a9 = a15*a6*a9;
    double a14a7a9 = a14*a7*a9;
    double a1a11a14 = a1*a11*a14;
    double a1a10a15 = a1*a10*a15;
    double a11a13a2 = a11*a13*a2;
    double a10a13a3 = a10*a13*a3;
    double a15a2a9 = a15*a2*a9;
    double a14a3a9 = a14*a3*a9;
    double a15a2a5 = a15*a2*a5;
    double a14a3a5 = a14*a3*a5;
    double a1a15a6 = a1*a15*a6;
    double a13a3a6 = a13*a3*a6;
    double a1a14a7 = a1*a14*a7;
    double a13a2a7 = a13*a2*a7;
    double a11a2a5 = a11*a2*a5;
    double a10a3a5 = a10*a3*a5;
    double a1a11a6 = a1*a11*a6;
    double a1a10a7 = a1*a10*a7;
    double a3a6a9 = a3*a6*a9;
    double a2a7a9 = a2*a7*a9;
    double a11a14a4 = a11*a14*a4;
    double a10a15a4 = a10*a15*a4;
    double a11a12a6 = a11*a12*a6;
    double a10a12a7 = a10*a12*a7;
    double a15a6a8 = a15*a6*a8;
    double a14a7a8 = a14*a7*a8;
    double a0a11a14 = a0*a11*a14;
    double a0a10a15 = a0*a10*a15;
    double a11a12a2 = a11*a12*a2;
    double a10a12a3 = a10*a12*a3;
    double a15a2a8 = a15*a2*a8;
    double a14a3a8 = a14*a3*a8;
    double a15a2a4 = a15*a2*a4;
    double a14a3a4 = a14*a3*a4;
    double a0a15a6 = a0*a15*a6;
    double a12a3a6 = a12*a3*a6;
    double a0a14a7 = a0*a14*a7;
    double a12a2a7 = a12*a2*a7;
    double a11a2a4 = a11*a2*a4;
    double a10a3a4 = a10*a3*a4;
    double a0a11a6 = a0*a11*a6;
    double a0a10a7 = a0*a10*a7;
    double a3a6a8 = a3*a6*a8;
    double a2a7a8 = a2*a7*a8;
    double a11a13a4 = a11*a13*a4;
    double a11a12a5 = a11*a12*a5;
    double a15a5a8 = a15*a5*a8;
    double a13a7a8 = a13*a7*a8;
    double a15a4a9 = a15*a4*a9;
    double a12a7a9 = a12*a7*a9;
    double a1a11a12 = a1*a11*a12;
    double a0a11a13 = a0*a11*a13;
    double a1a15a8 = a1*a15*a8;
    double a13a3a8 = a13*a3*a8;
    double a0a15a9 = a0*a15*a9;
    double a12a3a9 = a12*a3*a9;
    double a1a15a4 = a1*a15*a4;
    double a13a3a4 = a13*a3*a4;
    double a0a15a5 = a0*a15*a5;
    double a12a3a5 = a12*a3*a5;
    double a1a12a7 = a1*a12*a7;
    double a0a13a7 = a0*a13*a7;
    double a1a11a4 = a1*a11*a4;
    double a0a11a5 = a0*a11*a5;
    double a3a5a8 = a3*a5*a8;
    double a1a7a8 = a1*a7*a8;
    double a3a4a9 = a3*a4*a9;
    double a0a7a9 = a0*a7*a9;
    double a10a13a4 = a10*a13*a4;
    double a10a12a5 = a10*a12*a5;
    double a14a5a8 = a14*a5*a8;
    double a13a6a8 = a13*a6*a8;
    double a14a4a9 = a14*a4*a9;
    double a12a6a9 = a12*a6*a9;
    double a1a10a12 = a1*a10*a12;
    double a0a10a13 = a0*a10*a13;
    double a1a14a8 = a1*a14*a8;
    double a13a2a8 = a13*a2*a8;
    double a0a14a9 = a0*a14*a9;
    double a12a2a9 = a12*a2*a9;
    double a1a14a4 = a1*a14*a4;
    double a13a2a4 = a13*a2*a4;
    double a0a14a5 = a0*a14*a5;
    double a12a2a5 = a12*a2*a5;
    double a1a12a6 = a1*a12*a6;
    double a0a13a6 = a0*a13*a6;
    double a1a10a4 = a1*a10*a4;
    double a0a10a5 = a0*a10*a5;
    double a2a5a8 = a2*a5*a8;
    double a1a6a8 = a1*a6*a8;
    double a2a4a9 = a2*a4*a9;
    double a0a6a9 = a0*a6*a9;

    double det =a1a11a14a4 -a1a10a15a4 -a11a13a2a4 +a10a13a3a4 - 
	       a0a11a14a5 +a0a10a15a5 +a11a12a2a5 -a10a12a3a5 - 
	       a1a11a12a6 +a0a11a13a6 +a1a10a12a7 -a0a10a13a7 - 
	       a15a2a5a8 +a14a3a5a8 +a1a15a6a8 -a13a3a6a8 - 
	       a1a14a7a8 +a13a2a7a8 +a15a2a4a9 -a14a3a4a9 - 
	       a0a15a6a9 +a12a3a6a9 +a0a14a7a9 -a12a2a7a9;

    im.val[0][0] = ( -a11a14a5 +a10a15a5 +a11a13a6 
		-a10a13a7 -a15a6a9 +a14a7a9)/det;
    im.val[0][1] = ( a1a11a14 -a1a10a15 -a11a13a2 
		+a10a13a3 + a15a2a9 -a14a3a9)/det;
    im.val[0][2] = ( -a15a2a5 +a14a3a5 +a1a15a6 
		- a13a3a6 -a1a14a7 +a13a2a7)/det;
    im.val[0][3] = ( a11a2a5 -a10a3a5 -a1a11a6 
		+a1a10a7 +a3a6a9 -a2a7a9)/det; 
    im.val[1][0] = ( a11a14a4 -a10a15a4 -a11a12a6 
		+a10a12a7 +a15a6a8 - a14a7a8)/det;
    im.val[1][1] = ( -a0a11a14 +a0a10a15 +a11a12a2 
		-a10a12a3 - a15a2a8 +a14a3a8)/det;
    im.val[1][2] = ( a15a2a4 -a14a3a4 -a0a15a6 
		+a12a3a6 + a0a14a7 -a12a2a7)/det;
    im.val[1][3] = ( -a11a2a4 +a10a3a4 +a0a11a6 
		-a0a10a7 -a3a6a8 +a2a7a8)/det; 
    im.val[2][0] = ( -a11a13a4 +a11a12a5 -a15a5a8 +a13a7a8 +a15a4a9 - a12a7a9)/det;
    im.val[2][1] = ( -a1a11a12 +a0a11a13 +a1a15a8 
		-a13a3a8 - a0a15a9 +a12a3a9)/det;
    im.val[2][2] = ( -a1a15a4 +a13a3a4 +a0a15a5 
		-a12a3a5 +a1a12a7 -a0a13a7)/det;
    im.val[2][3] = ( a1a11a4 -a0a11a5 +a3a5a8 
		-a1a7a8 -a3a4a9 +a0a7a9)/det;
    im.val[3][0] = ( a10a13a4 -a10a12a5 +a14a5a8 
		-a13a6a8 -a14a4a9 + a12a6a9)/det;
    im.val[3][1] = ( a1a10a12 -a0a10a13 -a1a14a8 
		+a13a2a8 + a0a14a9 -a12a2a9)/det;
    im.val[3][2] = ( a1a14a4 -a13a2a4 -a0a14a5 
		+a12a2a5 - a1a12a6 +a0a13a6)/det;
    im.val[3][3]= ( -a1a10a4 +a0a10a5 -a2a5a8 
	       +a1a6a8 +a2a4a9 -a0a6a9)/det;

    im.changed = 1;
    return im;
}

// build the transposed matrix of the current matrix: 
RT_Matrix RT_Matrix::TRANSPOSE() const {
    RT_Matrix tm;
    for (int i = 0; i<4 ; i++) 
	for (int j = 0; j<4 ; j++)
	    tm.val[i][j] = val[j][i];
    tm.changed = 1;
    return tm;
}

RT_Matrix RT_Matrix::operator+ (const RT_Matrix &b) const {
    RT_Matrix m;
    for (int i = 0; i<4 ; i++) 
	for (int j = 0; j<4 ; j++)
	    m.val[i][j] = val[i][j]+b.val[i][j];
    m.changed = 1;
    return m;
}

RT_Matrix RT_Matrix::operator - (const RT_Matrix &b) const {
    RT_Matrix m;
    for (int i = 0; i<4 ; i++) 
	for (int j = 0; j<4 ; j++)
	    m.val[i][j] = val[i][j]-b.val[i][j];
    m.changed = 1;
    return m;
}

RT_Matrix RT_Matrix::operator * (const RT_Matrix &b) const {
    RT_Matrix m;
    for (int i = 0; i<4 ; i++) 
	for (int j = 0; j<4 ; j++) 
	    {
		m.val[i][j] = 0.0;
		for (int k = 0; k<4 ; k++)
		    m.val[i][j] += val[i][k]*b.val[k][j];
	    }
    m.changed = 1;
    return m;
}

RT_Vector RT_Matrix::operator * ( const RT_Vector &v) const {
    RT_Vector r;
    r.x = v.x * val[0][0] + v.y * val[0][1] + v.z * val[0][2] + val[0][3];
    r.y = v.x * val[1][0] + v.y * val[1][1] + v.z * val[1][2] + val[1][3];
    r.z = v.x * val[2][0] + v.y * val[2][1] + v.z * val[2][2] + val[2][3];

    double   w = v.x * val[3][0]
	+ v.y * val[3][1]
	    + v.z * val[3][2]
		+ val[3][3];

    r.x /=w; r.y /=w; r.z /=w;

    return r;
}

RT_Matrix RT_Matrix::TRANSLATION (const RT_Vector  &v) const {
    RT_Matrix tmp,m;
    tmp.val[0][3] = v.x; 
    tmp.val[1][3] = v.y;
    tmp.val[2][3] = v.z;
    m= *this * tmp;
    m.changed = 1;
    return m;
}

RT_Matrix RT_Matrix::INV_TRANSLATION (const RT_Vector  &v) const {
    RT_Matrix tmp,m;
    tmp.val[0][3] = - v.x;
    tmp.val[1][3] = - v.y;
    tmp.val[2][3] = - v.z;
    m=tmp * (*this);
    m.changed = 1;
    return m;
}

RT_Matrix RT_Matrix::ROTATION_X (const double  angle) const {
    RT_Matrix tmp,m;
    double cos_val = cos(angle);
    double sin_val = sin(-angle);
    tmp.val[1][1] = cos_val; 
    tmp.val[2][2] = cos_val;
    tmp.val[1][2] = sin_val;
    tmp.val[2][1] = -sin_val;
 
    m= *this * tmp;
    m.changed = 1;
    return m;
}

RT_Matrix RT_Matrix::INV_ROTATION_X (const double  angle) const {
    RT_Matrix tmp,m;
    double cos_val = cos(angle);
    double sin_val = sin(angle);
    tmp.val[1][1] = cos_val; 
    tmp.val[2][2] = cos_val;
    tmp.val[1][2] = sin_val;
    tmp.val[2][1] = -sin_val;
 
    m= tmp * *this;
    m.changed = 1;
    return m;
}

RT_Matrix RT_Matrix::ROTATION_Y (const double  angle) const {
    RT_Matrix tmp,m;
    double cos_val = cos(angle);
    double sin_val = sin(-angle);
    tmp.val[0][0] = cos_val; 
    tmp.val[2][2] = cos_val;
    tmp.val[0][2] = -sin_val;
    tmp.val[2][0] = sin_val;
 
    m= *this * tmp;
    m.changed = 1;
    return m;
}

RT_Matrix RT_Matrix::INV_ROTATION_Y (const double  angle) const {
    RT_Matrix tmp,m;
    double cos_val = cos(angle);
    double sin_val = sin(angle);
    tmp.val[0][0] = cos_val; 
    tmp.val[2][2] = cos_val;
    tmp.val[0][2] = -sin_val;
    tmp.val[2][0] = sin_val;
 
    m= tmp * *this;
    m.changed = 1;
    return m;
}

RT_Matrix RT_Matrix::ROTATION_Z (const double  angle) const {
    RT_Matrix tmp,m;
    double cos_val = cos(angle);
    double sin_val = sin(-angle);
    tmp.val[0][0] = cos_val; 
    tmp.val[1][1] = cos_val;
    tmp.val[0][1] = sin_val;
    tmp.val[1][0] = -sin_val;
 
    m= *this * tmp;
    m.changed = 1;
    return m;
}

RT_Matrix RT_Matrix::INV_ROTATION_Z (const double  angle) const {
    RT_Matrix tmp,m;
    double cos_val = cos(angle);
    double sin_val = sin(angle);
    tmp.val[0][0] = cos_val; 
    tmp.val[1][1] = cos_val;
    tmp.val[0][1] = sin_val;
    tmp.val[1][0] = -sin_val;
 
    m= tmp * *this;
    m.changed = 1;
    return m;
}

RT_Matrix RT_Matrix::operator * (const double &d) const {
    RT_Matrix m;
    for (int i = 0 ; i < 4 ; i++)
	for (int j = 0 ; j < 4 ; j++)
	    m.val[i][j]= val[i][j]*d; 
    m.changed = 1;
    return m;
}

