#ifndef __PIXMAP_H__
#define __PIXMAP_H__

////////////////////////////////////////////////////////////////////////////////
// Declaration of class Pixmap - the essential base class for graphical output//
// objects. Class PixmapDisplay is used for immediate display of images.      //  
//  LAST EDIT: Fri Sep 23 16:37:23 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "color.h"
#include "object.h"
#include "input/input.h"

class RT_Camera;
// a forward to avoid cycles of class definitions

extern const char *RTN_PIXMAP;

class RT_Pixmap:public RT_Object  {
    static RT_ParseEntry table[];
    //#### the statics for parameter parsing:
    static int camG;
  protected:
    int checkIndices(int, int);
    // returns 1 if indices are o.k. else 0
    RT_Camera *xcamera;
    // the related camera;
    int w, h;  
    int objectCMD(char *[]);
    char *saveArray;
    // an array that can be used for buffering of the pixel values
  public:

    void setCamera(RT_Camera *c) { xcamera = c; }
    // set a pointer to the related camera
    // this procedure will be called from a camera
    // thus dont send any signal to the former camera!

    int getW() const { return w; }
    int getH() const { return h; }

    virtual void event() = 0;
    // check for events but do not block

    virtual void putPixel(int, int, const RT_Color&) = 0;
    // (0,0) is the lower left corner
    virtual RT_Color getPixel(int, int) = 0;
    virtual void clear(const RT_Color &) = 0;

    virtual void activate() = 0;

    void objectKilled(RT_Object *);

    //#### Tcl/C++ methods:
    RT_Pixmap(char *_name, int _w, int _h):RT_Object(_name) {
	rt_InputServer->addObject( this );
	w = _w; h = _h; 
	xcamera = 0;
	saveArray = 0;
    }
    virtual ~RT_Pixmap() {
	if (saveArray) delete saveArray;
	rt_InputServer->removeObject( this ); 
    }
    int isA(const char *_c) const { return RT_Object::isA( _c ) || RTM_isA(_c, RTN_PIXMAP ); }

    RT_Camera *get_camera() const { return xcamera; }

    void printCon( FILE *f) const {
	RT_Object::printCon( f);
	fprintf( f, "%i %i ", w, h);
    }
};

extern const char *RTN_PIXMAP_DISPLAY;
extern const char *RTSN_PD;

class RT_PixmapDisplayData;

class RT_PixmapDisplay: public RT_Pixmap  {
friend class RT_PixmapDisplayData;
    static RT_ParseEntry table[];
    //#### the statics for parameter parsing:
    static int sglF, dblF;
  protected:
    int objectCMD(char *[]);
  public:
    RT_PixmapDisplayData *data;
    int sglBuf; // singlebuffer flag 

    void putPixel(int, int, const RT_Color&);
    virtual RT_Color getPixel(int, int);
    void clear(const RT_Color &);

    void event();
    void activate();

    //#### Tcl/C++ methods:
    RT_PixmapDisplay(char *_name, int , int);
    ~RT_PixmapDisplay();

    const char *get_class() const { return RTN_PIXMAP_DISPLAY; }
    int isA(const char *_c) const { return RT_Pixmap::isA( _c ) || RTM_isA(_c, RTN_PIXMAP_DISPLAY ); }
    const char *get_description() const { return "A pixmap for immediate display." ; }

    void singlebuffer();
    void doublebuffer();

    void print(FILE *f) const {
	printCon(f);
	fprintf( f, "\n%s %s\n", get_name(), sglBuf ? "-singlebuffer" : "-doublebuffer" );
    }

    //#### the Tcl methods:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]);
};

#endif
