#ifndef __RS_SCENE_H__
#define __RS_SCENE_H__

////////////////////////////////////////////////////////////////////////////////
//                    The intern radiosity scene class.                       //
//  LAST EDIT: Fri Aug  5 08:55:08 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //
//              yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include "rs_io.h"

//some forwards to avoid cycles:
class RT_RS_Areas;
class RT_RS_Points;
class RT_RS_DiffRGB;
class RT_RS_brdfRGB;
class RT_RS_BRDFs;

class RT_RS_Scene : public RT_RS_IO
{
  char* name;
protected:
  void alloch(RT_RS_Points* aPoints = NULL, RT_RS_Areas* aAreas = NULL,
              RT_RS_BRDFs* aBRDFs = NULL); //allocate heap memory
  void freeh(); //free heap
public:
  //the containers:
  RT_RS_Points *Points; // contains the vertices
  RT_RS_Areas  *Areas;  // contains the patches
  RT_RS_BRDFs  *BRDFs;  // contains the reflectivity functions

  char *get_class() { return "RS_Scene"; }
  char *get_name() { return name ? name : NONAME; }

  //constructors
  RT_RS_Scene(char *filename, FILE *fp = NULL);
  RT_RS_Scene() : name(NULL) { alloch(); }
  RT_RS_Scene(char *aname, RT_RS_Points* aPoints,
              RT_RS_Areas* aAreas, RT_RS_BRDFs* aBRDFs) :
    name(aname) { alloch(aPoints, aAreas, aBRDFs); }
  //destructor
  virtual ~RT_RS_Scene() { freeh(); }

  void clear();  //clear the containers

  //in/out functions
  boolean read(char *filename, FILE *fp = NULL); // Read from ASCII file.
  boolean write(char *filename, FILE *fp = NULL); // Write to ASCII file.
  void print(FILE *f, char *n = NULL, int width = 8, int decimalPlaces = 2);
};

#endif  

