#ifndef __RS_SPHR_H__
#define __RS_SPHR_H__

////////////////////////////////////////////////////////////////////////////////
//                       Spherical harmonics computation.                     //   
//  LAST EDIT: Fri Aug  5 08:55:07 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //
//              yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include <math.h>
#include "rs_vec.h"
#include "rs_matrx.h"
#include "rs_lmmat.h"

//contains the normalizing constants
class RT_RS_NormConstants : public RT_RS_lmMatrix
{
protected:
  // compute the normalizing constants Nlm
  // MAXL > l >= m >= -l
  float comp_NormConst(int l, int m, boolean Init);
public:
  RT_RS_NormConstants(int n) : RT_RS_lmMatrix(n, 0., 'n')
    { comp_NormConst(0, 0, TRUE); }

};

//computes spherical harmonics
class RT_RS_spherical_harmonics
{
private:
  static RT_RS_NormConstants N;
  static RT_RS_lmMatrix P;
  static RT_RS_lmMatrix X;

  // get the computed normalizing constant Nlm
  // MAXL > l >= m >= -l
  float get_NormConst(int l, int m) { return N(l, m < 0 ? -m : m); }

  // compute the Legendre functions Plm(x)
  // MAXL > l >= m >= -l
  // -1 >= x <= 1
  float comp_LegendreFunc(int l, int m, float x);

public:
  virtual char* get_class() = 0;

  // compute the integral of y from a to b using Simpson's rule
  // nelm odd!
  float comp_Integr(int nelm, RT_RS_Vector& y, float a, float b);
  // compute the normalized spherical harmonics Ylm(theta,phi)
  // MAXL > l >= m >= 0
  // 0 <= theta <= Pi
  // 0 <= phi <= 2*Pi
  float comp_SpherHarms(int l, int m, float theta, float phi);

  // compute the coefficients Clm
  // MAXL > l >= m >= 0
  float comp_Coeff(int l, int m, RT_RS_Matrix& f);
};

#endif 
