////////////////////////////////////////////////////////////////////////////////
//  Implementation of a scene class.                                          //  
//  LAST EDIT: Tue Mar  7 15:18:44 1995 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "scene.h"
#include "camera.h"
#include "light.h"
#include "primitiv.h"

const char *RTN_SCENE = "Scene";

int RT_Scene::remF; int RT_Scene::objG;
char *RT_Scene::remV; int RT_Scene::updF;
RT_Color RT_Scene::colrV; int RT_Scene::colrF, RT_Scene::colrG; 

RT_ParseEntry RT_Scene::table[] = {
    { "-insert", RTP_SPECIAL, 0, 0, "Insert {ARG 1 Objects} into the scene.", "Object_List" },
    { "-remove", RTP_STRING, (char*)&remV, &remF, "Remove {ARG 1 Object} from scene.", "Object" },
    { "-get_objects", RTP_NONE, 0, &objG, "Get the objects placed inside the scene.", RTPS_NONE },
    { "-update", RTP_NONE, 0, &updF, "Update all primitives inside the scene.", RTPS_NONE },
    { "-background", RTP_COLOR, (char*)&colrV, &colrF, "Set the global {ARG 1 Background} color for the scene.", RTPS_COLOR},
    { "-get_background", RTP_NONE, 0, &colrG, "Get background color of the scene.", RTPS_NONE },
    { 0, RTP_END, 0, 0, 0, 0 }
};

int RT_Scene::classCMD(ClientData cd, Tcl_Interp *ip, int argc, char *argv[]) { 
    int res;
    res = _classCMD(cd, ip, argc, argv);
    if (res == TCL_HELP) {
	Tcl_AppendResult( ip, "{", argv[0], " {String} {Creates a new scene called {ARG 1 Name}.}}", 0 );
	return TCL_OK;
    }
    if ( res  == TCL_OK ) {  
	new RT_Scene( argv[1] ); 
	RTM_classReturn;
    }
    return res; 
}

int RT_Scene::objectCMD(char *argv[]) { 
    RT_parseTable( argv, table );
    int ret = colrF;
    if (colrF) background( colrV );
    if (colrG) {
	static char tmp[60];
	RT_color2string( get_background(), tmp );
	RT_Object::result( tmp ); ret++;
    }
    if (remF) {
	RT_Object *obj = RT_Object::getObject( remV );
	if (obj) { remove( obj ); ret++; }
    }
    if (updF) { ret++; update(); }
    int start, diff = 0, xdiff; 
    char *pr;
    if ((start = RT_findString( argv, "-insert")) >= 0) 
	while ( RT_getString( &argv[ start + diff + 1 ], pr, xdiff) ) {
	    diff += xdiff;
	    RT_Object *obj = RT_Object::getObject( pr );
	    if (obj ) {
		if ( obj->isA( RTN_PRIMITIVE) || obj->isA( RTN_LIGHT )) {
		    insert( obj );
		    ret++;
		}
		else rt_Output->errorVar( get_name(),
					 ": Object ", pr, " cannot be inserted into a scene!", 0);
	    }
	    else rt_Output->errorVar( get_name(), ": No such object ", pr, "!", 0);
	}
    RT_clearArgv( argv, start, diff );
    if (objG) {
	RT_String tmp( 100 );
	RT_PrintObjectNameFunc func( &tmp );
	tmp += '{';
	doWithElements( &func );
	tmp += '}';
	RT_Object::result( (char*)tmp );
	ret++;
    }
    return ret;
}

void RT_Scene::print(FILE *f) const {
    printCon( f );
    fprintf( f, "\n%s -background ", get_name() );
    get_background().print( f );
    if (getNumber()) fprintf(f, " -insert ", get_name() );
    RT_GeneralListElem *tmp = root;
    if (tmp) 
	do {
	    RT_Object *o = (RT_Object*)tmp->elem;
	    fprintf( f, "%s ", o->get_name() );
	}
    while(tmp = tmp->next);
    fprintf( f, "\n" );
}

void RT_Scene::insert(RT_Object *a, RT_Object *b ...) { 
    insert( a );
    va_list l;
    va_start( l, b );
    if ( b ) {
	insert( b );
	while ( b = va_arg( l, RT_Object* )) insert( b );
    }
    va_end( l );
}

void RT_Scene::update() {
    RT_GeneralListElem *tmp = root;
    if (tmp) do {
	// there are only RT_Objects in the scene!
	RT_Object *o = (RT_Object*)tmp->elem;
	if (o->isA( RTN_PRIMITIVE)) ((RT_Primitive*)o)->referencing();
    }
    while(tmp = tmp->next);
    tmp = root;
    if (tmp) do {
	RT_Object *o = (RT_Object*)tmp->elem;
	if (o->isA( RTN_PRIMITIVE)) ((RT_Primitive *)o)->update();
    } 
    while(tmp = tmp->next);
}

void RT_Scene::insert(RT_Object *o) {
    if (o->isA( RTN_LIGHT) || o->isA( RTN_PRIMITIVE )) append( o );
    else rt_Output->errorVar( "Cannot insert object ", o->get_name(),
			     " into a scene.", 0 );
}
