////////////////////////////////////////////////////////////////////////////////
//  Implementation of Surface methods.                                        //  
//  LAST EDIT: Fri Aug  5 08:55:11 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "global.h"
#include "surface.h"
#include "utils.h"

int RT_Surface::set(const char *xval) {
    int argc; char **argv;
    if (Tcl_SplitList( rt_Ip, (char*)xval, &argc, &argv) == TCL_OK) {
	int ok = 0;
	if (argc > 6 && argc < 9) {
	    RT_Color _ambi, _diff, _spec, _emmi;
	    double _tran, _refr, _shin;
	    if (_ambi.set( argv[0] ) &&
		_diff.set( argv[1] ) &&
		_spec.set( argv[2] ) &&
		_emmi.set( argv[3] ) &&
		RT_string2double( argv[4], _tran) &&
		RT_string2double( argv[5], _refr) &&
		RT_string2double( argv[6], _shin)) {
		ambi = _ambi; diff = _diff;
		spec = _spec; emmi = _emmi; 
		tran = _tran; refr = _refr;
		shin = _shin; if( argc == 8) specfunc = argv[7];
		ok = 1;
	    }
	}
	free((char*)argv);
	return ok;
    }
    return 0;
}

int RT_Surface::operator==(const RT_Surface &s) const {
    if (!(ambi == s.ambi)) return 0;
    if (!(diff == s.diff)) return 0;
    if (!(spec == s.spec)) return 0;
    if (!(emmi == s.emmi)) return 0;
    if (tran != s.tran) return 0;
    if (refr != s.refr) return 0;
    if (shin != s.shin) return 0;
    return specfunc == s.specfunc;
}

