////////////////////////////////////////////////////////////////////////////////
// This file contains all functions that must be implemented in dependency    // 
// of the graphics system.                                                    // 
//  LAST EDIT: Fri Aug  5 09:04:53 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "../quadmesh.h"
#include "../high/usefligh.h"
#include "../high/lookat.h"
#include "../pixmap.h"
#include "../poly.h"
#include "../polyhdrn.h"

class RT_PixmapDisplayData {};
// the class can be used for pixmap-local data

// the following functions encapsulate display list calls
// that are provided by different graphics subsystems
// like SGI GL, PHIGS PLUS, OpenGL
// BUT it isn't necessery to use 'em.
// look into the x11.C file - the isn't any usage of the 
// display list functions, because you have full access
// to all interesting data also in the primitive routines (render)

// Display list functions: 

void RT_dlOpen(long) {}
// open a display list
// parameter is a 32 bit identifier

void RT_dlClose(long) {}
// close the display list

void RT_dlDelete(long) {}
// delete the display list

void RT_dlMatrix(const RT_Matrix&) {}
// write a matrix display list element
// some Display lists using a matrix context
// thus we need the following operation:

void RT_dlUnMatrix() {}

void RT_dlSurface(const RT_Surface &) {}
// write a surface element into the display list
// this is often unused

void RT_dlCall(long ) {}
// execute a display list

// the class PixmapDisplay:

RT_PixmapDisplay::RT_PixmapDisplay(char *_name, int _w, int _h): RT_Pixmap(_name, _w, _h) {}
// pixmap display constructor

RT_PixmapDisplay::~RT_PixmapDisplay() {}  
// pixmap display destructor

void RT_PixmapDisplay::activate() {}
// activate the pixmap, called before rendering
// SGI GL drawing commands are related to the
// topical window
// thus set the topical window usin' this method

void RT_PixmapDisplay::singlebuffer() { }
// switch pixmap to single buffer display
// not all subsystems can support this

void RT_PixmapDisplay::doublebuffer() {}
// switch pixmap to double buffer display
// not all subsystems can support this

void RT_PixmapDisplay::event() {}
// evaulation of events (if there are any)

RT_Color RT_PixmapDisplay::getPixel(int, int) {return RT_Color( 0,0,0);}
// request a pixel value

void RT_PixmapDisplay::putPixel(int x, int y, const RT_Color &colr) {}
// set a pixel value

void RT_PixmapDisplay::clear(const RT_Color &colr) {}
// clear the complete pixmap with the specified color

// rendering of the low level primitives:

void RT_Polymarker::render() {}

void RT_Polyline::render() {}

void RT_Polygon::render() {}

void RT_Quadmesh::render() {}

void RT_Polyhedron::render() {}

// rendering of the light sources
// the systems provides for the correct sequence
// meaning that lights will be rendered before
// primitives will be rendered

void RT_AmbientLight::render() {}

void RT_PointLight::render() {}
 
// shading method for the lookat camera:

void RT_LookatCamera::shading() {}

#ifdef RTD_RSY
void RT_LookatCamera::RSYshading() {}
#endif

