////////////////////////////////////////////////////////////////////////////////
//  YART interface to PHIGS PLUS ISO-C binding. Very alpha!                   //  
//  LAST EDIT: Fri Aug  5 09:08:12 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "../quadmesh.h"
#include "../high/usefligh.h"
#include "../high/lookat.h"
#include "../pixmap.h"
#include "../ident.h"
#include "../polyhdrn.h"

#include "gralphgs.h"

// some gralphigs specific defines:

#define RTD_GRALPHIGS_WS_TYPE 7177 
//#define RTD_GRALPHIGS_WS_TYPE 8887
#define RTD_GRALPHIGS_MAX_LIGHTS 8
#define RTD_GRALPHIGS_VARIABLE 33
#define RTD_GRALPHIGS_END 34

// some globals:
int rt_GralphigsLightId;
int rt_GralphigsWsId; 
// the id of the currently open workstation
int rt_GralphigsSid; 
// the id of a temporary closed structure
int rt_GralphigsElem;
// the elem pointer of a temporary closed structure
RT_IdentGenerator rt_GralphigsWsIds( 32 ); 
// generator for workstation IDs
int rt_GralphigsPixmapSid; 
// the pixmap sid

class RT_PixmapDisplayData {
  public:
    int wsId;
    int resol;
    Pint_size TDim;
    Pvertex **trace;
    int tracing;  
};

// low level functions: 

void RT_dlOpen(long id) {
    int errInd;
    // is already a structure open?:
    Popen_struct_status oStatus;
    pinq_open_struct( &errInd, &oStatus, &rt_GralphigsSid);
    if (oStatus == PSTRUCT_OPEN) {
	pinq_elem_ptr( &errInd, &rt_GralphigsElem );
	pclose_struct();
    }
    else rt_GralphigsSid = 0;
    Pstruct_status status;
    pinq_struct_status((int)id, &errInd, &status);
    if ( status != PSTRUCT_STATUS_NONE_EXISTENT) pdel_struct((int) id);
    popen_struct((int)id);
    pset_edit_mode( PEDIT_INSERT );
}

void RT_dlClose(long ) {
    pclose_struct();
    if (rt_GralphigsSid) {
	popen_struct(rt_GralphigsSid);
	pset_elem_ptr( rt_GralphigsElem );
    }
}

void RT_dlDelete(long id) {
    int err_ind;
    Pstruct_status status;
    pinq_struct_status((int) id, &err_ind, &status);
    if ( status != PSTRUCT_STATUS_NONE_EXISTENT) pdel_struct((int) id );
}

void RT_dlMatrix(const RT_Matrix &mat ) {
    float m[4][4];
    mat.get( m );
    pset_local_tran3( (Pmatrix3)m,  PTYPE_REPLACE );
}

void RT_dlUnMatrix() {}

void RT_dlSurface(const RT_Surface &) {}

void RT_dlCall(long id ) {  pexec_struct( (int)id ); }

// the class PixmapDisplay:

RT_PixmapDisplay::~RT_PixmapDisplay() { 
    rt_GralphigsWsIds.freeId( data->wsId );
    peclph(); 
    RT_dlDelete( (long)this );
}  

RT_Color RT_PixmapDisplay::getPixel(int, int) {return RT_Color( 0,0,0);}

void RT_PixmapDisplay::activate() {
    rt_GralphigsLightId = 1;
    rt_GralphigsWsId = data->wsId;
    rt_GralphigsPixmapSid = (int)this;
    rt_GralphigsSid = 0;
    popen_struct( (int)this );
    pset_elem_ptr( 1 );
}

void RT_PixmapDisplay::singlebuffer() { }

void RT_PixmapDisplay::doublebuffer() { }

RT_PixmapDisplay::RT_PixmapDisplay(char *_name, int _w, int _h): RT_Pixmap(_name, _w, _h) {
    data = new RT_PixmapDisplayData;
    // initialize window:
    static int init = 0;
    if (!init) rt_GralphigsWsIds.getId();
    // skip over the zero Id, because it isnt allowed
    // as workstation id
    data->wsId = rt_GralphigsWsIds.getId();
    RT_gralphigsInit( get_name(), getW(), getH(), data->wsId );
    if (!init) {
	popen_phigs( "/dev/tty", (unsigned)-1);
	init = 1;
    }
    popen_ws( data->wsId, "/dev/null", RTD_GRALPHIGS_WS_TYPE );
    // inquire max available color entries:
    Pcolr_facs cf;
    int err;
    pinq_colr_facs(RTD_GRALPHIGS_WS_TYPE, &err, &cf);
    data->resol = cf.num_colrs;

    // initialize ray tracing
    data->TDim.size_x = _w;
    data->TDim.size_y = _h;
    data->tracing = 0;

    // open the pixmap display list:
    popen_struct( (int) this);
    pset_int_shad_method( PINT_SHAD_METHOD_COLR );
    pset_rend_colr_model( PMODEL_RGB );
    pset_refl_model( PREFL_MODEL_AMB_DIFF_SPEC_REFL );
    plabel( RTD_GRALPHIGS_VARIABLE );
    plabel( RTD_GRALPHIGS_END );
    pclose_struct(); 
    pset_hlhsr_mode( data->wsId, PHLHSR_ID_ZB_ON );
    ppost_struct( data->wsId, (int)this, 1.0);
    // initalize input devices
    pset_loc_mode( data->wsId, 1, POP_EVENT, PSWITCH_NO_ECHO );
}

void RT_PixmapDisplay::event() {
    Pin_class evclass;
    Pint ws, devnum, view;
    Ppoint pos;
    RT_Event *event = NULL;
    pawait_event( 0.0, &ws, &evclass, &devnum );
    if (evclass != PIN_NONE) switch (evclass) {
	case PIN_EXPOSE : case PIN_RESIZE: {
		RT_MotionEvent *motion = new RT_MotionEvent;
		predraw_all_structs(ws, PFLAG_ALWAYS);
		int err;
		Pdisp_space_size size;
		pinq_disp_space_size( RTD_GRALPHIGS_WS_TYPE, &err, &size);
		motion->w = (size.size_raster.size_x > size.size_raster.size_y) ? size.size_raster.size_x : size.size_raster.size_y;
		motion->h = motion->w;
		h = motion->h;
		w = motion->w;
		event = (RT_Event*)motion;
		break;
	}
	case PIN_LOC : {
		RT_ButtonEvent *button = new RT_ButtonEvent;
		pget_loc(&view, &pos);
		button->left = 1;
		button->x = (int)(pos.x * getW());
		button->y = (int)(pos.y * getH());
		button->w = getW();
		button->h = getH();
		event = (RT_Event*)button;
		break;
	}
    }
    if (event) {
	camera->event( *event );
	delete event;
    }
}

void RT_PixmapDisplay::putPixel(int x, int y, const RT_Color &colr) {
    int i, j;
    if (!data->tracing) {
    	data->trace = new Pvertex*[ data->TDim.size_x ];
    	for ( j = 0; j < data->TDim.size_x; j++ ) data->trace[ j ] = new Pvertex[ data->TDim.size_y ];
    	for ( j = 0; j < data->TDim.size_x; j++ )
	    for ( i =0; i < data->TDim.size_y; i++) {
		data->trace[i][j].colr.point.x = (float) j/w;
		data->trace[i][j].colr.point.y = (float) i/h;
		data->trace[i][j].colr.point.z = 0.0;
	    }
	data->tracing = 1;
    }
    data->trace[y][x].colr.colr.colr_rep.rgb.red =   (float)colr.r;
    data->trace[y][x].colr.colr.colr_rep.rgb.green = (float)colr.g;
    data->trace[y][x].colr.colr.colr_rep.rgb.blue =  (float)colr.b;
    
    if ( (x == data->TDim.size_x - 1) && (y == 0)) {
        int errInd, dum;
        // is the structure already opened?:
        Popen_struct_status status;
        pinq_open_struct( &errInd, &status, &dum);
        if (status == PSTRUCT_NONE ) popen_struct( (int)this);
        // clear the old elements:
        pset_elem_ptr( 1 );
        pdel_elems_labels( RTD_GRALPHIGS_VARIABLE, RTD_GRALPHIGS_END );

        pset_view_ind( 0 );
        pset_int_shad_method( PINT_SHAD_METHOD_COLR );
        pset_rend_colr_model( PMODEL_RGB );
    	pquad_mesh3_data( PFACET_NONE, PEDGE_NONE, PVERTEX_COLR, PCOLR_RGB, &data->TDim, NULL, NULL, data->trace );
        pclose_struct();
	
        predraw_all_structs(rt_GralphigsWsId, PFLAG_ALWAYS);

	if (data->trace) {
    	    for (int j = 0; j < data->TDim.size_x; j++ ) delete data->trace[ j ];
    	    delete data->trace;
	}
	data->tracing = 0;
    }
}

void RT_PixmapDisplay::clear(const RT_Color &) {
    int errInd, dum;
    // is the structure already opened?:
    Popen_struct_status status;
    pinq_open_struct( &errInd, &status, &dum);
    assert( dum == (int)this );
    if (status == PSTRUCT_NONE ) popen_struct( (int)this);
    // clear the old elements:
    pset_elem_ptr( 1 );
    pdel_elems_labels( RTD_GRALPHIGS_VARIABLE, RTD_GRALPHIGS_END );
    if (status == PSTRUCT_NONE ) pclose_struct();
    // unpost pixmap + redraw + background color!!!!
}

void RT_Polymarker::render() {
    RT_Vertex *v;
    float f[4];
    int nr = 0;
    int np = get_number();
    Ppoint_list3 list;
    list.num_points = get_number();
    list.points = new Ppoint3[ list.num_points ];
    for (int i=0; i<list.num_points; i++) {
	v = get( i );
	v->getPoint().get( f );
	list.points[i].x = f[0];
	list.points[i].z = f[1];
	list.points[i].y = f[2];
    }
    ppolymarker3( &list );   
    delete list.points;
}

void RT_Polyline::render() {
    RT_Vertex *v;
    RT_Surface *sf;
    float f[4];
    Pgcolr spec_color;
    int nr = 0;
    int np = get_number();
    Pvertex_list *list = new Pvertex_list[1];
    list[0].num_vertices = np;
    list[0].data.colr = new Pvertex_colr[ np ];
    for (int j=0; j < np; j++) {
	v = get( j );
	v->getPoint().get( f );
	sf = v->getSurface();
	if (!sf) sf = &get_surface();
	list[0].data.colr[j].point.x = f[0];
	list[0].data.colr[j].point.y = f[1];
	list[0].data.colr[j].point.z = f[2];
	list[0].data.colr[j].colr.colr_rep.rgb.red =   sf->diff.r;
	list[0].data.colr[j].colr.colr_rep.rgb.green = sf->diff.g;
	list[0].data.colr[j].colr.colr_rep.rgb.blue =  sf->diff.b;
    }
    spec_color.colr_type = PMODEL_RGB;
    spec_color.colr_value.colr_rep.rgb.red =   1.0;
    spec_color.colr_value.colr_rep.rgb.green = 1.0;
    spec_color.colr_value.colr_rep.rgb.blue =  1.0;
    pset_refl_props(1.0, 1.0, 1.0, &spec_color, 400.0);
    ppolyline_set3_data( PVERTEX_COLR, PCOLR_RGB, 1, list ); 
    delete list[0].data.colr;
    delete list;
}

void RT_Polygon::render() {
    RT_Vertex *v;
    RT_Surface *sf;
    RT_Vector *nv;
    float f[4], norm[4];
    Pgcolr spec_color;
    int nr = 0;
    int np = get_number();
    Pvertex_list *list = new Pvertex_list[1];
    list[0].num_vertices = np;
    list[0].data.colr_norm = new Pvertex_colr_norm[ np ];
    for (int j=0; j < np; j++) {
	v = get( j );
	v->getPoint().get( f );
	sf = v->getSurface();
	if (!sf) sf = &get_surface();
	nv = v->getNormal();
	if ( nv ) nv->get( norm );
	else get_gnormal().get( norm );
	list[0].data.colr_norm[j].point.x = f[0];
	list[0].data.colr_norm[j].point.y = f[1];
	list[0].data.colr_norm[j].point.z = f[2];
	list[0].data.colr_norm[j].colr.colr_rep.rgb.red =   sf->diff.r;
	list[0].data.colr_norm[j].colr.colr_rep.rgb.green = sf->diff.g;
	list[0].data.colr_norm[j].colr.colr_rep.rgb.blue =  sf->diff.b;
	list[0].data.colr_norm[j].norm.delta_x = norm[0];
	list[0].data.colr_norm[j].norm.delta_y = norm[1];
	list[0].data.colr_norm[j].norm.delta_z = norm[2];
    }
    spec_color.colr_type = PMODEL_RGB;
    spec_color.colr_value.colr_rep.rgb.red = 1.0; 
    spec_color.colr_value.colr_rep.rgb.green = 1.0; 
    spec_color.colr_value.colr_rep.rgb.blue = 1.0;
    pset_refl_props(1.0, 1.0, 1.0, &spec_color, 400.0);
    if ( get_fillstyle() ) pset_int_style( PSTYLE_SOLID );
    else pset_int_style( PSTYLE_HOLLOW );
    pfill_area_set3_data( PFACET_NONE, PEDGE_NONE, PVERTEX_COLR_NORM,
			 PCOLR_RGB, 0, 0, 0, 1, list); 
    delete list[0].data.colr_norm;
    delete list;
}

void RT_Polyhedron::render() {
    RT_Vertex *v;
    RT_Surface *sf;
    RT_Vector *nv;
    RT_Facet fac;
    float f[4], norm[4];
    Pgcolr spec_color;
    int nr = 0;
    int nf = get_nfacets();
    Pvertex_list *list = new Pvertex_list[ nf ];
    for (int i=0; i<nf; i++) {
	fac = facets[i];
	int np = fac.get_number();
    	list[i].num_vertices = np;
    	list[i].data.colr_norm = new Pvertex_colr_norm[ np ];
	for (int j=0; j<np; j++) {
	   v = get( i, j );
	   v->getPoint().get( f );
	   sf = v->getSurface();
	   if (!sf) sf = &get_surface();
	   nv = v->getNormal();
	   if ( nv ) nv->get( norm );
	   else get_gnormal().get( norm );
	   list[i].data.colr_norm[j].point.x = f[0];
	   list[i].data.colr_norm[j].point.y = f[1];
	   list[i].data.colr_norm[j].point.z = f[2];
	   list[i].data.colr_norm[j].colr.colr_rep.rgb.red =   sf->diff.r;
	   list[i].data.colr_norm[j].colr.colr_rep.rgb.green = sf->diff.g;
	   list[i].data.colr_norm[j].colr.colr_rep.rgb.blue =  sf->diff.b;
	   list[i].data.colr_norm[j].norm.delta_x = norm[0];
	   list[i].data.colr_norm[j].norm.delta_y = norm[1];
	   list[i].data.colr_norm[j].norm.delta_z = norm[2];
	}
    }
    spec_color.colr_type = PMODEL_RGB;
    spec_color.colr_value.colr_rep.rgb.red = 1.0; 
    spec_color.colr_value.colr_rep.rgb.green = 1.0; 
    spec_color.colr_value.colr_rep.rgb.blue = 1.0;
    pset_refl_props(1.0, 1.0, 1.0, &spec_color, 400.0);
    if ( get_fillstyle() ) pset_int_style( PSTYLE_SOLID );
    else pset_int_style( PSTYLE_HOLLOW );
    pfill_area_set3_data( PFACET_NONE, PEDGE_NONE, PVERTEX_COLR_NORM,
			 PCOLR_RGB, 0, 0, 0, nf, list); 
    for (i=0; i<nf; i++) delete list[i].data.colr_norm;
    delete list;
}
	
void RT_Quadmesh::render() {
    RT_Vertex *v;
    RT_Surface *sf;
    RT_Vector *nv;
    float f[4], norm[4];
    Pgcolr spec_color;
    if (get_fillstyle()) {
      Pint_size QDim;
      QDim.size_x = get_x();
      QDim.size_y = get_y();
      int np = QDim.size_x * QDim.size_y;
      Pvertex **mesh = new Pvertex*[ QDim.size_x ];
      for ( int j = 0; j < QDim.size_x; j++ ) mesh[ j ] = new Pvertex[ QDim.size_y ];
      for ( j = 0; j < QDim.size_x; j++ )
	for ( int i =0; i < QDim.size_y; i++) {
	    v = get(j,i);
	    v->getPoint().get( f );
	    sf = v->getSurface();
	    if (!sf) sf = &get_surface();
	    nv = v->getNormal();
	    if ( nv ) nv->get( norm );
	    else get_gnormal().get( norm );
	    mesh[i][j].colr_norm.point.x = f[0];
	    mesh[i][j].colr_norm.point.y = f[1];
	    mesh[i][j].colr_norm.point.z = f[2];
	    mesh[i][j].colr_norm.colr.colr_rep.rgb.red =   sf->diff.r;
	    mesh[i][j].colr_norm.colr.colr_rep.rgb.green = sf->diff.g;
	    mesh[i][j].colr_norm.colr.colr_rep.rgb.blue =  sf->diff.b;
	    mesh[i][j].colr_norm.norm.delta_x = norm[0];
	    mesh[i][j].colr_norm.norm.delta_y = norm[1];
	    mesh[i][j].colr_norm.norm.delta_z = norm[2];
      }
      spec_color.colr_type = PMODEL_RGB;
      spec_color.colr_value.colr_rep.rgb.red = 1.0; 
      spec_color.colr_value.colr_rep.rgb.green = 1.0; 
      spec_color.colr_value.colr_rep.rgb.blue = 1.0; 
      pset_refl_props(1.0, 1.0, 1.0, &spec_color, 400.0);
      pquad_mesh3_data( PFACET_NONE, PEDGE_NONE, PVERTEX_COLR_NORM, PCOLR_RGB, &QDim, NULL, NULL, mesh );
      for ( j = 0; j < QDim.size_x; j++ ) delete mesh[ j ];
      delete mesh;
    } else {
      int nx = get_x();
      int ny = get_y();
      Pvertex_list *list = new Pvertex_list[nx + ny];   
      int k = 0; 
      for ( int j=0; j<nx; j++) {	  
      	list[k].num_vertices = ny;
    	list[k].data.colr = new Pvertex_colr[ ny ];
    	for (int i=0; i < ny; i++) {
	   v = get( j,i );
	   v->getPoint().get( f );
	   sf = v->getSurface();
	   if (!sf) sf = &get_surface();
	   list[k].data.colr[i].point.x = f[0];
	   list[k].data.colr[i].point.y = f[1];
	   list[k].data.colr[i].point.z = f[2];
	   list[k].data.colr[i].colr.colr_rep.rgb.red =   sf->diff.r;
	   list[k].data.colr[i].colr.colr_rep.rgb.green = sf->diff.g;
	   list[k].data.colr[i].colr.colr_rep.rgb.blue =  sf->diff.b;
	}
	k++;
      }
      for ( j=0; j<ny; j++) {	  
      	list[k].num_vertices = nx;
    	list[k].data.colr = new Pvertex_colr[ nx ];
    	for (int i=0; i < ny; i++) {
	   v = get( i,j );
	   v->getPoint().get( f );
	   sf = v->getSurface();
	   if (!sf) sf = &get_surface();
	   list[k].data.colr[i].point.x = f[0];
	   list[k].data.colr[i].point.y = f[1];
	   list[k].data.colr[i].point.z = f[2];
	   list[k].data.colr[i].colr.colr_rep.rgb.red =   sf->diff.r;
	   list[k].data.colr[i].colr.colr_rep.rgb.green = sf->diff.g;
	   list[k].data.colr[i].colr.colr_rep.rgb.blue =  sf->diff.b;
	}
	k++;
      }
      spec_color.colr_type = PMODEL_RGB;
      spec_color.colr_value.colr_rep.rgb.red =   1.0;
      spec_color.colr_value.colr_rep.rgb.green = 1.0;
      spec_color.colr_value.colr_rep.rgb.blue =  1.0;
      pset_refl_props(1.0, 1.0, 1.0, &spec_color, 400.0);
      ppolyline_set3_data( PVERTEX_COLR, PCOLR_RGB, nx+ny, list ); 
      for (k=0; k<nx+ny; k++) delete list[k].data.colr;
      delete list;
    }
}

void RT_AmbientLight::render() {
    if (get_on()) {
	if ( rt_GralphigsLightId <= RTD_GRALPHIGS_MAX_LIGHTS ) {
	    RT_Color color = get_color();
	    Plight_source_rep lightRep;
	    lightRep.type = PLIGHT_SOURCE_AMB;
	    lightRep.data.ambient.colr.colr_type = PMODEL_RGB;
	    lightRep.data.ambient.colr.colr_value.colr_rep.rgb.red = color.r;
	    lightRep.data.ambient.colr.colr_value.colr_rep.rgb.green = color.g;
	    lightRep.data.ambient.colr.colr_value.colr_rep.rgb.blue = color.b;
	    pset_light_source_rep(  rt_GralphigsWsId, rt_GralphigsLightId, &lightRep);
	    rt_GralphigsLightId++;
	}    
	else rt_Output->warning(" Maximum number of lights reached. ");
    }
}

void RT_PointLight::render() {   
    if (get_on()) {
	if ( rt_GralphigsLightId <= RTD_GRALPHIGS_MAX_LIGHTS ) {
	    RT_Color color = get_color();
	    RT_Vector vector = get_origin();
	    Plight_source_rep lightRep;
	    lightRep.type = PLIGHT_SOURCE_POS;
	    lightRep.data.positional.atten_coeff[0] = 1.0;
	    lightRep.data.positional.atten_coeff[1] = 0.0;
	    lightRep.data.positional.pos.x = vector.x;
	    lightRep.data.positional.pos.y = vector.y;
	    lightRep.data.positional.pos.z = vector.z;
	    lightRep.data.positional.colr.colr_type = PMODEL_RGB;
	    lightRep.data.positional.colr.colr_value.colr_rep.rgb.red = color.r;
	    lightRep.data.positional.colr.colr_value.colr_rep.rgb.green = color.g;
	    lightRep.data.positional.colr.colr_value.colr_rep.rgb.blue = color.b;
	    pset_light_source_rep( rt_GralphigsWsId, rt_GralphigsLightId, &lightRep);
	    rt_GralphigsLightId++;
	}
	else rt_Output->warning(" Maximum number of lights reached. ");
    }  
}

void RT_LookatCamera::shading() {
    // clear the old elements:
    pset_elem_ptr( 1 );
    pdel_elems_labels( RTD_GRALPHIGS_VARIABLE, RTD_GRALPHIGS_END );

    Ppoint3 vrp; 
    vrp.x = vp.x; vrp.y = vp.y; vrp.z = vp.z;
    float zn =- xnear; float zfar = -xfar;

    Pvec3 vnorm;
    vnorm.delta_x = vp.x-rp.x; 
    vnorm.delta_y = vp.y-rp.y;
    vnorm.delta_z = vp.z-rp.z;

    float dx = vp.x-rp.x;
    float dy = vp.y-rp.y;
    float dz = vp.z-rp.z;

    vnorm.delta_x = dx; vnorm.delta_y = dy; vnorm.delta_z = dz;

    double twist = xtwist / 2.0 * M_PI / 180.0;

    Pvec3 vup;
    vup.delta_x = sin(twist);
    vup.delta_y = cos(twist);
    vup.delta_z = 0.0;

    Pview_rep3 vrep; Pint error;

    peval_view_ori_matrix3( &vrp, &vnorm, &vup, &error, vrep.ori_matrix );
    if (error) rt_Output->warning("Sorry, PHIGS cannot compute the view orientation transformation. ");
    
    float distance = xfar-zn;
    float angle = xangle /2.0 * M_PI / 180.0;
    float radius = tan( angle ) * distance;

    Pview_map3 vmap;
    vmap.win.x_min = -radius; vmap.win.x_max = +radius;
    vmap.win.y_min = -radius; vmap.win.y_max = radius;

    vmap.proj_vp.x_min = 0; vmap.proj_vp.x_max = 1;
    vmap.proj_vp.y_min = 0; vmap.proj_vp.y_max = 1;
    vmap.proj_vp.z_min = 0; vmap.proj_vp.z_max = 1;
    
    vmap.proj_type =  PTYPE_PERSPECT;
    vmap.proj_ref_point.x = 0.0;   
    vmap.proj_ref_point.y = 0.0;  
    vmap.proj_ref_point.z = 0.0; //vp.z;

    vmap.view_plane = zfar; //0.0;
    vmap.back_plane = zfar;
    vmap.front_plane = zn ; 
    
    peval_view_map_matrix3(&vmap, &error, vrep.map_matrix );
    if (error) rt_Output->warning("Sorry, PHIGS cannot compute the view mapping transformation. ");
    
    vrep.xy_clip = PIND_NO_CLIP;
    vrep.back_clip = PIND_NO_CLIP;
    vrep.front_clip = PIND_NO_CLIP;
    
    pset_view_rep3( rt_GralphigsWsId, 1, &vrep );
    
    pset_view_ind( rt_GralphigsWsId );
    RT_RenderLightFunc lfunc;
    RT_RenderPrimitiveFunc pfunc;
    get_scene()->doWithElements( &lfunc );

    // set light source states:
    Pint lightsOn[RTD_GRALPHIGS_MAX_LIGHTS];
    Pint lightsOff[RTD_GRALPHIGS_MAX_LIGHTS];
    for (int i = 1; i < rt_GralphigsLightId; i++) lightsOn[i-1] = i;
    pset_light_source_st( rt_GralphigsLightId -1, lightsOn, 0, lightsOff );

    get_scene()->doWithElements( &pfunc );
    pclose_struct();
    predraw_all_structs(rt_GralphigsWsId, PFLAG_ALWAYS);
}

#ifdef RTD_RSY
void RT_LookatCamera::RSYshading() {}
// sorry PHIGS guys, radiosity not implemented for PHIGS 'til now
#endif

