////////////////////////////////////////////////////////////////////////////////
//  YART interface to X11. Supports Gouraud shading even in wireframe mode.   //
//  But it is very slow, too.                                                 //  
//  LAST EDIT: Tue Aug 16 15:24:28 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "../high/usefligh.h"
#include "../high/lookat.h"
#include "../poly.h"
#include "../polyhdrn.h"
#include "../quadmesh.h"
#include "../pixmap.h"

#ifdef RTD_RSY
#include "../rsy/rsyscene.h"
#endif

#include "fisher.h"
#include "fdither.h"

#ifndef RTD_CPP_INCLUDES
extern "C" {
#endif
    
#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
    
#ifndef RTD_CPP_INCLUDES
}
#endif

#ifdef RTD_RSY

void RT_LookatCamera::RSYshading() {
    GraphInit(xpixmap);
    
    //shader parameters:
    vertex sO[8]; SHD_VTX sS[8];
    vct3 sVRP, sNRP, sVUP;
    sVRP.x= rp.x;  sVRP.y= rp.y;  sVRP.z= rp.z;            //view reference point
    sNRP.x= vp.x;  sNRP.y= vp.y;  sNRP.z= vp.z;            //normal reference point
    double twist = xtwist * M_PI / 180.0;   		         
    sVUP.x = -sin(twist); sVUP.y = cos(twist); sVUP.z = 0.0;//view up vector
    RT_Vector vv(rp - vp);                                 //view vector
    float vpd = vv.ABS();                                  //view plane distance
    vv = vv.UNITIZE();                                     //norm. view vector 
    float ysizediv2 = tan(xangle /2.0 * M_PI / 180.0) * vpd; //view window y-size / 2
    float xsizediv2 = ysizediv2 * rt_XMaxGlobal / (rt_YMaxGlobal * rt_Aspect); //view window x-size / 2
    
    float max_rend = -MAXFLOAT;
    
    RT_Scene *sc = get_scene();
    if (! sc->isA( RTN_RSY_SCENE ) ) {
	rt_Output->errorVar( sc->get_name(), " isn't a radiosity scene!", 0 );
	return;
    }
    RT_RS_Scene* rscene = ((RT_RSYScene*)sc)->get_rscene(); //the radiosity scene to render
    long i, cnt, x[8], y[8],
    a_dcnt = rscene->Areas->get_diffcnt(),     //number of diffuse patches
    a_icnt = rscene->Areas->get_inscnt(),      //number of non-diffuse patches
    p_dcnt = rscene->Points->get_diffcnt(),     //number of diffuse patches
    p_icnt = rscene->Points->get_inscnt();      //number of non-diffuse patches
    int j, k, m, corners;
    int render_nondiff = xmode == RTE_LC_RADIOSITY; //render non-diffuse components ? (if any)
    int wireframe = xmode == RTE_LC_WIREFRAME_RADIOSITY;
    int auto_view_scale = rscene->Points->view_scale < epsilon && !wireframe;
    int max_colr = ColRange - 1;
    float max_scale = rscene->Points->max_scale;
    RT_RS_Area* ar;                            //the current patch
    RT_RS_3DVector prp(vp.x, vp.y, vp.z);      //projection reference point
    RT_RS_Vtx *vtx[4],                         //the vertices of the current patch
    view_dir(prp, RT_RS_3DVector(vv.x, vv.y, vv.z)); //view direction
    
    
    //setup shader:
    SetViewing(sVRP, sNRP, sVUP, -xsizediv2, -ysizediv2, xsizediv2, ysizediv2,
	       vpd, vpd - xnear, vpd - xfar); 
    SetScreen(0.0, rt_YMaxGlobal, rt_XMaxGlobal, 0.0, FALSE);
    updateMats();             //update shader transformation matrices
    
    RT_RS_DiffRGB xcolr[4]; //the colors of the vertices
    
    rscene->Points->reset_vis();
    for(m = 0; m < 2; m++) {  //for all (diffuse + non-diffuse patches)
	cnt = m ? p_icnt : p_dcnt;
	for(i = 0; i < cnt; i++) {
	    if(m) *vtx = rscene->Points->get_ins(i);
	    else *vtx = rscene->Points->get_diff(i); //get the patch
	    if((*vtx)->get_view_val(*xcolr, view_dir, render_nondiff))
		if(auto_view_scale) {
		    sO->crd.x = (*vtx)->pnt.x; sO->crd.y = (*vtx)->pnt.y; sO->crd.z = (*vtx)->pnt.z;
		    corners = 1;
		    PolyClip(&corners, sO);            //clipping
		    if(corners) {
			if(xcolr->r > max_rend && xcolr->r < max_scale) max_rend = xcolr->r;
			if(xcolr->g > max_rend && xcolr->g < max_scale) max_rend = xcolr->g;
			if(xcolr->b > max_rend && xcolr->b < max_scale) max_rend = xcolr->b;
		    }
		}
	}
    }
    
    
    if(auto_view_scale) rscene->Points->view_scale = (float)max_colr / max_rend;
    rscene->Points->scale_view_vals();
    
    SetViewGlobal(sVRP, sNRP, sVUP, -xsizediv2, -ysizediv2, 2 * xsizediv2,
		  vpd, vpd - xnear, vpd - xfar);
    SetScreenGlobal(0.0, rt_YMaxGlobal, rt_XMaxGlobal, 0.0);
    
    
    //render:
    while (DoLocalInit()) {
	updateMats();             //update shader transformation matrices
	for(k = wireframe ? 0 : 1; k < 2; k++) {
	    for(m = 0; m < 2; m++) {  //for all (diffuse + non-diffuse patches)
		cnt = m ? a_icnt : a_dcnt;
		for(i = 0; i < cnt; i++) {
		    if(m) ar = rscene->Areas->get_ins(i); else ar = rscene->Areas->get_diff(i); //get the patch
		    corners = ar->vidx[2] == ar->vidx[3] ? 3 : 4;
		    int backface = 0;
		    for(j = 0; j < corners; j++) {
			vtx[j] = ar->get_vtx(ar->vidx[j]);   //get the vertices
			//get the vertex intensity in direction to point of view
			if(!vtx[j]->get_view_val(xcolr[j], view_dir, render_nondiff))
			    backface++;  //this vertex is back-facing 
		    }
		    backface = backface == corners;
		    if(wireframe && (backface && !k || !backface && k) || !wireframe && !backface) {        //render this patch
			for(j = 0; j < corners; j++) {
			    sO[j].crd.x = vtx[j]->pnt.x; sO[j].crd.y = vtx[j]->pnt.y; sO[j].crd.z = vtx[j]->pnt.z;
			    sO[j].nrm.x = vtx[j]->nrm.x; sO[j].nrm.y = vtx[j]->nrm.y; sO[j].nrm.z = vtx[j]->nrm.z;
			    sO[j].c.r = xcolr[j].r; sO[j].c.g = xcolr[j].g; sO[j].c.b = xcolr[j].b;
			}
			PolyClip(&corners, sO);            //clipping
			if(wireframe) {    //draw as a wireframe
			    for (j = 0; j < corners; j++) 
				MCtoDCi(sO[j].crd, &x[j], &y[j]);  //model -> device coordinates (integer) (x, y)
			    int lcolr = backface ? max_colr / 2 : max_colr; //draw backfacing patches grey
			    for (j = 0; j < corners; j++) {
				unsigned cy_idx1 = (j + 1) % corners;
				RGB_Line((int)x[j], (int)y[j], (int)x[cy_idx1], (int)y[cy_idx1],
					 lcolr, lcolr, lcolr); //draw the line on screen
			    }
			} else {
			    for (j = 0; j < corners; j++) {
				MCtoDC3(sO[j].crd, &sS[j]);       //model -> device coordinates (x, y, z)
				sS[j].c.r = (int)floor(sO[j].c.r); 
				sS[j].c.g = (int)floor(sO[j].c.g); 
				sS[j].c.b = (int)floor(sO[j].c.b);
			    }
			    for (j = 2; j < corners; j++)
				FillTria(sS[0], sS[j - 1], sS[j]);  //fill triangle (flat or Gouraud)
			}
		    }
		}
	    }
	}
    }
    if(auto_view_scale) rscene->Points->view_scale = 0.;
}

#endif

#if !defined(RTD_TK)

class RT_PixmapDisplayData {
  public:
    Window window;
    Display *display;
    GC gc;
    int screen;
    int resol;
    // resolution of colortable
    Pixmap pixmap;
    int depth;
    int mapped;
    RT_PixmapDisplayData() { mapped = 1; }
#if defined(RTD_STORE_EXACT_COLORS)
    RT_Color **colors;
    int cxlen, cylen;
#endif
};

// the class PixmapDisplay:

RT_PixmapDisplay::~RT_PixmapDisplay()
{
    if (data->display != NULL) {
	if (data->pixmap != None)
	    XFreePixmap( data->display, data->pixmap );
	if (data->gc != None)
	    XFreeGC(data->display, data->gc);
#if defined(RTD_STORE_EXACT_COLORS)
	if (data->colors != NULL) {
	    for (int i = 0; i < data->cylen; i++)
		free(data->colors[i]);
	    free(data->colors);
	}
#endif
	XCloseDisplay( data->display);
    }
    delete data;
}  

void RT_PixmapDisplay::activate() {}

void RT_PixmapDisplay::singlebuffer() { sglBuf = 1; }

void RT_PixmapDisplay::doublebuffer() { sglBuf = 0; }

RT_PixmapDisplay::RT_PixmapDisplay(char *_name, int _w, int _h)
: RT_Pixmap(_name, _w, _h)
{
    data = new RT_PixmapDisplayData;
    
    static Display *display = 0;

    if (!display && !(display = XOpenDisplay(0))) 
	rt_Output->fatal( "Cannot open display for X Pixmap.");

    data->display = display;
    data->screen = DefaultScreen(data->display) ;
    data->depth = DisplayPlanes(data->display, data->screen);
    data->resol = 1 << data->depth;

    data->window = XCreateSimpleWindow(data->display,
				       RootWindow(data->display, data->screen),
				       0, 0, w, h, 1, 0, 0 );

    data->pixmap = XCreatePixmap(data->display, data->window, w, h,
				 data->depth);

    XSelectInput(data->display, data->window,
		 StructureNotifyMask | ButtonPressMask |
		 ButtonReleaseMask | PointerMotionMask | ExposureMask );

    data->gc = XCreateGC( data->display, data->window, 0, NULL);

    XSizeHints sHints;
    sHints.flags = PSize| PMinSize | PMaxSize;
    sHints.min_width = sHints.max_width = w;
    sHints.min_height = sHints.max_height = h;

    XTextProperty wName;
    if (!XStringListToTextProperty( &_name, 1, &wName)) 
	rt_Output->fatal( "Structure allocation for Window Name of X11 Pixmap failed." );
    XSetWMProperties( data->display, data->window, &wName, &wName, 0, 0,
		     &sHints, 0, 0);
    XFree( (char*)wName.value );
    XMapWindow( data->display, data->window );

    // support for common colormap - Don Libes, NIST
    if (!rt_Cmap) {
	int rIncr = 65536/rt_rMax;
	int gIncr = 65536/rt_gMax;
	int bIncr = 65536/rt_bMax;
	
	XColor color;
	int r, g, b;

	rt_Cmap = new int[ (rt_rMax+1) * (rt_gMax+1) * (rt_bMax+1)];

	for (r = 0, color.red = 0; r <= rt_rMax; r++, color.red += rIncr) {
	    // on last iteration, max it
	    if (r == rt_bMax) color.red = 65535;
	    for (g = 0, color.green = 0; g <= rt_gMax; g++, color.green += gIncr) {
		if (g == rt_gMax) color.green = 65535;
		for (b = 0, color.blue  = 0; b <= rt_bMax; b++, color.blue += bIncr) {
		    if (b == rt_bMax) color.blue = 65535;

		    XAllocColor(data->display,DefaultColormap(data->display,DefaultScreen(data->display)),&color);
		    rt_Cmap[r * rt_rMult + g * rt_gMult + b * rt_bMult] = (int)color.pixel;
		}
	    }
	}

	// for efficient, precompute dither multiplier.
	// 64 is just the size of the dither table.
	rt_rDitherMultiplier = rt_rMax * 64;
	rt_gDitherMultiplier = rt_gMax * 64;
	rt_bDitherMultiplier = rt_bMax * 64;
    }

#if defined(RTD_STORE_EXACT_COLORS)
    data->cxlen = w;
    data->cylen = h;
    data->colors = (RT_Color **)malloc(data->cylen * sizeof (RT_Color *));
    if (!data->colors) rt_Output->fatal("Virtual memory exhausted.");
    for (i = 0; i < data->cylen; i++) {
      data->colors[i] = (RT_Color *)calloc(data->cxlen, sizeof (RT_Color));
      if (!data->colors[i]) rt_Output->fatal("Virtual memory exhausted.");
    }
#endif
}

void RT_PixmapDisplay::event() {
    XEvent ev;
    while ( XPending ( data->display )) {
	XNextEvent( data->display, &ev );
	if( ev.xany.window != data->window) {
	    XPutBackEvent( data->display, &ev);
	    return;
	}

	RT_Event *event = 0;
	switch (ev.type) {
	    
        // the point events
        case ButtonPress: { 
            XButtonEvent *evb = (XButtonEvent *) &ev;
            RT_ButtonEvent *pev = new RT_ButtonEvent;
            if (evb->button == Button1) {pev->left = 1;}
            if (evb->button == Button2) {pev->middle = 1;}
            if (evb->button == Button3) {pev->right = 1;}
            pev->w = w;
            pev->h = h;
            pev->x = evb->x;  
            pev->y = h-evb->y;
            event = (RT_Event*) pev; 
          }
          break;
        case MotionNotify: {
	    XPointerMovedEvent *evm = (XPointerMovedEvent *) &ev;
	    RT_MotionEvent *pev = new RT_MotionEvent;
	    if (evm->state & Button1Mask) {pev->left = 1;}
	    if (evm->state & Button2Mask) {pev->middle = 1;}
	    if (evm->state & Button3Mask) {pev->right = 1;}
	    pev->w = w;
	    pev->h = h;
	    pev->x = evm->x;  
	    pev->y = h-evm->y;
	    event = (RT_Event*) pev;
	}
        break; 
	case Expose: {
            if ( ((XExposeEvent *) &ev)->count ) break;
            XCopyArea( data->display, data->pixmap, data->window,
		data->gc, ((XExposeEvent *) &ev)->x,
		((XExposeEvent *) &ev)->y,
		((XExposeEvent *) &ev)->width,
		((XExposeEvent *) &ev)->height,
		((XExposeEvent *) &ev)->x,
		((XExposeEvent *) &ev)->y  );
    }	    
      
    case MapNotify:
      data->mapped = 1;
      break;
    case UnmapNotify:
      data->mapped = 0;
      break;
    }
    if (event && xcamera) {
      xcamera->event( *event );
      delete event;
    }

  }
}

RT_Color RT_PixmapDisplay::getPixel(int x, int y) {
#if defined(RTD_STORE_EXACT_COLORS)
    if (x >= 0 && x < data->cxlen && y >= 0 && y < data->cylen) {
	return (data->colors[y][x]);
    } else {
	return (RT_Color(0, 0, 0));
    }
#else
    XColor col;
    XImage *img;
    
    img = XGetImage(data->display, data->window, x, (h - 1) - y,
		    1, 1, AllPlanes, XYPixmap);
    col.pixel = XGetPixel(img, 0, 0);
    XDestroyImage(img);
    XQueryColor(data->display, DefaultColormap(data->display,DefaultScreen(data->display)), &col);
    return (RT_Color(col.red/65535.0, col.green/65535.0, col.blue/65535.0));
#endif
}

void RT_PixmapDisplay::putPixel(int x, int y, const RT_Color &colr) {
#if defined(RTD_STORE_EXACT_COLORS)
    if (x >= 0 && x < data->cxlen && y >= 0 && y < data->cylen)
	data->colors[y][x] = colr;
#endif
    XSetForeground( data->display, data->gc, RT_ditherRGB(x, y, colr) );
    if (data->mapped)
	XDrawPoint( data->display, data->window, data->gc, x, (h - 1) - y);
    XDrawPoint( data->display, data->pixmap, data->gc, x, (h - 1) - y);
    XFlush(data->display);
}

#endif 

void RT_PixmapDisplay::clear(const RT_Color &colr) {
#if defined(RTD_STORE_EXACT_COLORS)
    int x, y;
    RT_Color *crow;
    if (data->colors != NULL) {
	for (y = 0; y < data->cylen; y++) {
	    crow = data->colors[y];
	    for (x = 0; x < data->cxlen; x++)
		crow[x] = colr;
	}
    }
#endif

#ifdef RTD_DITHERED_CLEAR
    struct PList {
	unsigned long color;
	int npoints;
	XPoint *points;
	PList *next;
    };
    PList *plist, *last, *cur;
    const int array_length = w;
    unsigned long col;
    
    last = plist = (PList *)calloc(1, sizeof (PList));
    if (last == NULL)
	rt_Output->fatal("virtual memory exhausted (3)");
    plist->points = (XPoint *)malloc(array_length * sizeof (XPoint));
    if (plist->points == NULL)
	rt_Output->fatal("virtual memory exhausted (4)");
    plist->color = RT_ditherRGB(0, 0, colr);
    
    for (y = 0; y < h; y++) {
	for (x = 0; x < w; x++) {
	    col = RT_ditherRGB(x, y, colr);
	    cur = last;
	    do {
		if (cur->color == col)
		    break;
		if ((cur = cur->next) == NULL)
		    cur = plist;
	    } while (cur != last);
	    if (cur->color != col) {
		cur = (PList *)malloc(sizeof (PList));
		cur->next = plist;
		cur->points = (XPoint *)malloc(array_length * sizeof (XPoint));
		if (cur->points == NULL)
		    rt_Output->fatal("virtual memory exhausted (5)");
		cur->color = col;
		cur->npoints = 0;
		plist = cur;
	    }
	    if (cur->npoints == array_length) {
		XSetForeground(data->display, data->gc, cur->color);
		if (data->mapped) {
		    XDrawPoints(data->display, data->window, data->gc,
				cur->points, cur->npoints, CoordModeOrigin);
		}
		XDrawPoints(data->display, data->pixmap, data->gc,
			    cur->points, cur->npoints, CoordModeOrigin);
		cur->npoints = 0;
	    }
	    cur->points[cur->npoints].x = x;
	    cur->points[cur->npoints].y = y;
	    cur->npoints++;
	    last = cur;
	}
    }
    
    for (cur = plist; cur != NULL; cur = cur->next) {
	if (cur->npoints != 0) {
	    XSetForeground(data->display, data->gc, cur->color);
	    if (data->mapped) {
		XDrawPoints(data->display, data->window, data->gc,
			    cur->points, cur->npoints, CoordModeOrigin);
	    }
	    XDrawPoints(data->display, data->pixmap, data->gc,
			cur->points, cur->npoints, CoordModeOrigin);
	}
    }
    
    while ((last = plist) != NULL) {
	plist = last->next;
	free(last->points);
	free(last);
    }
  int x, y;
#else
    XSetForeground(data->display, data->gc, RT_ditherRGB(0, 0, colr));
    XFillRectangle(data->display, data->window, data->gc, 0, 0, w, h);
    XFillRectangle(data->display, data->pixmap, data->gc, 0, 0, w, h);
#endif
}

// low level functions: 

void RT_dlOpen(long ) {}

void RT_dlClose(long) {}

void RT_dlDelete(long) {}

void RT_dlMatrix(const RT_Matrix&) {}

void RT_dlUnMatrix() {}

void RT_dlSurface(const RT_Surface &) {}

void RT_dlCall(long ) {}

// copy YART matrix to shader matrix 

void copy_matrix(const RT_Matrix &tmat, double (*mat)[4])
{
    memcpy(mat, E, sizeof(mat4));
  
    mat[1][1] = tmat.get(0,0);    mat[2][1] = tmat.get(0,1);
    mat[3][1] = tmat.get(0,2);    mat[0][1] = tmat.get(0,3);
    
    mat[1][2] = tmat.get(1,0);    mat[2][2] = tmat.get(1,1);
    mat[3][2] = tmat.get(1,2);    mat[0][2] = tmat.get(1,3);

    mat[1][3] = tmat.get(2,0);    mat[2][3] = tmat.get(2,1);
    mat[3][3] = tmat.get(2,2);    mat[0][3] = tmat.get(2,3);
}    

void RT_Polyhedron::render() {
    RT_Vertex *v;
    const RT_Surface *sf;
    const RT_Vector *nv;
    RT_Vector ve;

    vertex *pol;

    TriFillEnable = get_fillstyle(); 
    int MaxPnts = get_npoints();
    int fnr = get_nfacets();

    vertex *O = new vertex[MaxPnts + fnr * 2];
    SHD_VTX *S = new SHD_VTX[MaxPnts + fnr * 2];
    rgbI *col;
    int FORLIM,j;
    float norm[4];
    rgbB colB;
    int nr = 0;

    copy_matrix(getModel()->get_concatMatrix(),MC_WC);
    MatsChanged = true;
    updateMats();

    for (nr = 0; nr < MaxPnts; nr++) {
	v = get( nr);
        pol = &O[nr];

	// if a vertex surface defined 
        sf = v->getSurface();
        if (!sf) sf = &get_surface();
        nv = v->getNormal();
        if ( nv ) nv->get( norm );
        else (RT_Vector( 0,0,1 )).get( norm );

        pol->c.r = sf->diff.r;
        pol->c.g = sf->diff.g;
        pol->c.b = sf->diff.b;
	
        pol->nrm.x = norm[0];
        pol->nrm.y = norm[1];
        pol->nrm.z = norm[2];

	// set the vertex point
        ve = v->getPoint();
	pol->crd.x = ve.x;
	pol->crd.y = ve.y;
	pol->crd.z = ve.z;
    }

// Not clipped yet !!!
// If a point is outside the view volume, a core dump will be generated (or Windows will die)
//  PolyClip(&nr, O);  // nr will be changed by PolyClip
    FORLIM = nr;
    for (j = 0; j < FORLIM; j++) {
      col = &S[j].c;
      pol = &O[j];
      
      MCtoWC_vertex(O[j],&O[j]);  

      DoLight(O[j],&colB);
      
      WCtoDC(pol->crd, &S[j].x,&S[j].y,&S[j].z);
      
      col->r = colB.r;
      col->g = colB.g;
      col->b = colB.b;
    }
    for ( int i=0; i<fnr; i++) {
	int pnr = facets[i].get_number();
	    if (TriFillEnable)
    		for (int k = 2; k < pnr; k++) 
			FillTria(S[facets[i].get_pointer_to_vertex(0)], 
		   		 S[facets[i].get_pointer_to_vertex(k-1)], 
				 S[facets[i].get_pointer_to_vertex(k)]);
    	else {
                for (int k = 0; k < pnr-1; k++) 
				FillTria(S[facets[i].get_pointer_to_vertex(k)], 
					 S[facets[i].get_pointer_to_vertex(k+1)], 
					 S[facets[i].get_pointer_to_vertex(k+1)]);
           	FillTria(S[facets[i].get_pointer_to_vertex(0)], S[facets[i].get_pointer_to_vertex(k)], S[facets[i].get_pointer_to_vertex(k)]);           
    	}
    }
    if (O) delete [] O;
    if (S) delete [] S;
}

void RT_Polymarker::render() {}

void RT_Polyline::render() {
    RT_Vertex *v;
    const RT_Surface *sf;
    const RT_Vector *nv;
    RT_Vector ve;

    vertex *pol;

    polyOBJtyp O;
    polySCRtyp S;
    rgbI *col;
    int FORLIM,j;
    float norm[4];
    int nr = 0;

    copy_matrix(getModel()->get_concatMatrix(),MC_WC);
    MatsChanged = true;
    updateMats();

// Today the polyline is limited to maxPnts.
// If you need more than 50, have a look at RT_Polyhedron::render() or change maxPnts in fconst.h
// This will be changed in later versions.

    while ((v = get( nr++ )) && ( nr <= maxPnts ) ) {
        pol = &O[nr-1];

	// if a vertex surface defined 
        sf = v->getSurface();
        if (!sf) sf = &get_surface();
        pol->c.r = sf->diff.r;
        pol->c.g = sf->diff.g;
        pol->c.b = sf->diff.b;

        nv = v->getNormal();
        if ( nv ) nv->get( norm );
        else get_gnormal().get( norm );

        if (RT_Vector(norm[0],norm[1],norm[2]) == RT_NULL_NORMAL) {
         pol->nrm.x = 1;
         pol->nrm.y = 1;
         pol->nrm.z = 1;
        } else {
         pol->nrm.x = norm[0];
         pol->nrm.y = norm[1];
         pol->nrm.z = norm[2];
        }
        
	// set the vertex point
        ve = v->getPoint();
	pol->crd.x = ve.x;
	pol->crd.y = ve.y;
	pol->crd.z = ve.z;
    }

    nr--;

    PolyClip(&nr, O);  // nr will be changed by PolyClip
    FORLIM = nr;
    for (j = 0; j < FORLIM; j++) {
      col = &S[j].c;
      pol = &O[j];
      
      MCtoWC_vertex(O[j],&O[j]);  

      // Polylines are not affected by lights   
      
      WCtoDC(pol->crd, &S[j].x,&S[j].y,&S[j].z);
      
      col->r = (int)floor(pol->c.r*(ColRange - 1)+ 0.5);
      col->g = (int)floor(pol->c.g*(ColRange - 1)+ 0.5);
      col->b = (int)floor(pol->c.b*(ColRange - 1)+ 0.5);
    }
    FORLIM = nr;
    for (j = 1; j < FORLIM; j++) FillTria(S[j-1], S[j], S[j]); // it's a line
}

void RT_Polygon::render() {
    RT_Vertex *v;
    const RT_Surface *sf;
    const RT_Vector *nv;
    RT_Vector ve;

    vertex *pol;

    TriFillEnable = get_fillstyle(); 
     
    polyOBJtyp O;
    polySCRtyp S;
    rgbI *col;
    int FORLIM,j;
    float norm[4];
    rgbB colB;
    int nr = 0;

    copy_matrix(getModel()->get_concatMatrix(),MC_WC);
    MatsChanged = true;
    updateMats();

// Today the polygon is limited to maxPnts.
    // If you need more than 50, have a look at RT_Polyhedron::render() or change maxPnts in fconst.h
// This will be changed in later versions.

    while ((v = get( nr++ )) && ( nr <= maxPnts ) ) {
        pol = &O[nr-1];

	// if a vertex surface defined 
        sf = v->getSurface();
        if (!sf) sf = &get_surface();
        nv = v->getNormal();
        if ( nv ) nv->get( norm );
        else get_gnormal().get( norm );

        pol->c.r = sf->diff.r;
        pol->c.g = sf->diff.g;
        pol->c.b = sf->diff.b;
	
        pol->nrm.x = norm[0];
        pol->nrm.y = norm[1];
        pol->nrm.z = norm[2];

	// set the vertex point
        ve = v->getPoint();
	pol->crd.x = ve.x;
	pol->crd.y = ve.y;
	pol->crd.z = ve.z;
    }
    nr--;

    PolyClip(&nr, O);  // nr will be changed by PolyClip
    FORLIM = nr;
    for (j = 0; j < FORLIM; j++) {
      col = &S[j].c;
      pol = &O[j];
      
      MCtoWC_vertex(O[j],&O[j]);  

      DoLight(O[j],&colB);
      
      WCtoDC(pol->crd, &S[j].x,&S[j].y,&S[j].z);
      
      col->r = colB.r;
      col->g = colB.g;
      col->b = colB.b;
    }
    FORLIM = nr;
    if(FORLIM < 1) return;

    if (TriFillEnable)
    	for (j = 2; j < FORLIM; j++) FillTria(S[0], S[j - 1], S[j]);
    else {
           for (j = 0; j < FORLIM-1; j++) FillTria(S[j], S[j+1], S[j+1]);
           FillTria(S[0], S[j], S[j]);           
    }
}

void RT_Quadmesh::render() {
    RT_Vertex *v;
    const RT_Surface *sf;
    const RT_Vector *nv;
    RT_Vector ve;

    vertex pol;

    int xs,ys,x,y;
    float norm[4];

    TriFillEnable = get_fillstyle(); 
    
    xs = get_x(); 
    ys = get_y();
 
    InitXYMesh(xs, ys);  // allocate memory for mesh 
    
    copy_matrix(getModel()->get_concatMatrix(),MC_WC);
    MatsChanged = true;

    updateMats();
    
    for (x = 0; x < xs; x++) 
      for (y = 0; y < ys; y++) {
        v = get(x,y);

        sf = v->getSurface();
        if (!sf) sf = &get_surface();
        nv = v->getNormal();
        if ( nv ) nv->get( norm );
        else get_gnormal().get( norm );

        pol.c.r = sf->diff.r;
        pol.c.g = sf->diff.g;
        pol.c.b = sf->diff.b;
	
        pol.nrm.x = norm[0];
        pol.nrm.y = norm[1];
        pol.nrm.z = norm[2];
        
	// set the vertex point
        ve = v->getPoint();
	pol.crd.x = ve.x;
	pol.crd.y = ve.y;
	pol.crd.z = ve.z;

	PutInMesh(x, y, &pol);
    }
    Mesh(xs, ys);             // Draw mesh in z buffer
    DeleteXYMesh(xs, ys);
}

int lights_number;

void RT_AmbientLight::render() {

  RT_Color r_col;
  rgb g_col;
  
  r_col = get_color();

  g_col.r = r_col.r;
  g_col.g = r_col.g;
  g_col.b = r_col.b;

  addAmbLs(lights_number++,get_on(),g_col); 
}

void RT_PointLight::render() {
  RT_Color r_col;
  rgb g_col;
  RT_Vector pos;
  
  r_col = get_color();

  g_col.r = r_col.r;
  g_col.g = r_col.g;
  g_col.b = r_col.b;

  pos =  get_origin();

  addPosLs(lights_number++,get_on(),g_col,pos.x,pos.y,pos.z,1.0,0.0); 
  // C1 = 1 , C2 = 0 means light is independent from distance  

}

class RT_ChangePrimitiveFunc: public RT_GeneralListFunctoid {
  public:
    void exec(RT_GeneralListEntry *e, void * = 0);
};

void RT_ChangePrimitiveFunc::exec(RT_GeneralListEntry *e, void * ) {
    if ( e->isA( RTN_PRIMITIVE )) {
        RT_Primitive *p = ((RT_Primitive*)e);
	// change childs first:
	RT_ChangePrimitiveFunc func1;
        p->get_children().doWithElements( &func1 );

	// then the objects itself:
	if (p->get_visible())
	  ((RT_Primitive *)e)->primChanged();
    }
};

void RT_LookatCamera::shading() {
    vct3 VRP, NRP, VUP;
  
    lights_number = 0; // number of lights in system
    
    GraphInit(xpixmap);         
    
    VRP.x= rp.x;  VRP.y= rp.y;  VRP.z= rp.z;
    NRP.x= vp.x;  NRP.y= vp.y;  NRP.z= vp.z;
    float zn =- xnear; float zfar = -xfar;
    
    float vpd; // view plane distance
    
    vpd = (vp - rp).ABS();

  double twist = xtwist / 2.0 * M_PI / 180.0;

  VUP.x = sin(twist);
  VUP.y = cos(twist);
  VUP.z = 0.0;

  float angle = xangle /2.0 * M_PI / 180.0;
  float radius = tan( angle ) * vpd;

  float aspect = ((double)get_pixmap()->getW())/((double)get_pixmap()->getH());
  
  SetViewGlobal(VRP,NRP,VUP, -radius * aspect, -radius, 2*radius*aspect, vpd, vpd-xnear, -xfar+vpd);

  SetScreenGlobal(0.0, (double)rt_YMaxGlobal, (double)rt_XMaxGlobal, 0.0);

  RT_RenderLightFunc lfunc;
  RT_RenderPrimitiveFunc pfunc;
  RT_ChangePrimitiveFunc ufunc;
  get_scene()->doWithElements( &lfunc );

  while (DoLocalInit()) {
    updateMats();
    get_scene()->doWithElements( &ufunc ); 
    get_scene()->doWithElements( &pfunc );
    feedback->doWithElements( &ufunc ); 
    feedback->doWithElements( &pfunc );
  }

  // clear lights 
  while (lights_number) ClearLs(--lights_number);

}

