#ifndef __TCL_CLASS_H__
#define __TCL_CLASS_H__

////////////////////////////////////////////////////////////////////////////////
// Definition of an interpretative class system usable for high level primiti-//
// ves, accessible in Tcl and implemented in Tcl and C++.                     //  
// LAST EDIT: Wed Oct  5 13:03:18 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "rlist.h"
#include "object.h"
#include "primitiv.h"
#include "input/device.h"

void rt_initTclClassCommands(Tcl_Interp*);
// append the TclClass commmands on the interpreter

#define RTN_TCL_CLASS_METHOD_DESCRIPTION "TCMD"

class RT_TclClassMethodDescription: public RT_GeneralListEntry  {
  public:
    int mth;
    // if mth == 1 it is a method (default)
    // else it it a constructor
    char *method;
    char *parameters;
    char *ptypes;
    char *desc;
    char *body;
    char *cls;
    RT_TclClassMethodDescription() {
	method = 0; parameters = 0; mth = 1;
	desc = 0; ptypes = 0; body = 0;
    }
    ~RT_TclClassMethodDescription() {
 	if (method) delete method;
	clear();
    }
    void print(FILE *f) const {
	if (mth) fprintf( f, "Tcl_Method %s %s ", cls, method );
	fprintf( f, "{%s} {%s} {%s} {%s}\n", parameters, ptypes, desc, body );
    }
    void clear() {
	if (parameters) delete parameters;
	if (ptypes) delete ptypes;
	if (desc) delete desc;
	if (body) delete body;
    };
    void help();
    // get help information
    
    int isA(const char *_c) const { return RTM_isA( RTN_TCL_CLASS_METHOD_DESCRIPTION, _c ); }
};

#define RTN_TCL_CLASS_MEMBER "TCM"

class RT_TclClassMember: public RT_GeneralListEntry {
    RT_String member, value;
    void print(FILE *f) const {
	fprintf( f, "{ %s {%s}} ", (char*)member, (char*)value );
    }
  public:
    RT_TclClassMember(char *mb, char *va):member(mb), value(va) {}
    void setValue(char *va) { value = va; }
    char *getValue() { return (char*)value; }
    char *getMember() { return (char*)member; }
    int isA(const char *_c) const { return RTM_isA( RTN_TCL_CLASS_MEMBER, _c ); }
};

class RT_TclClassMemberList:public RT_GeneralList {
  public:
    RT_TclClassMemberList() {}
    ~RT_TclClassMemberList();
    void set(char *MEMBER, char *VALUE);
    // set a new VALUE for the specified MEMBER
    void add(char *MEMBER );
    // add a new member to the list and
    // initialize it with: {}
    // if it alreay exist - do nothing!
    void globalize(char *, RT_String& );
    // declare it as globals in a local
    // procedure context
    void setMembers(const char*);
    // write members into the global interpreter context
    void getMembers(const char*) const;
    // get members from the global interpreter context
};

#define RTN_TCL_CLASS_CLASS_DESCRIPTION "TCCD"

class RT_TclClassClassDescription: public RT_GeneralListEntry {
  public:
    RT_String constrCmd;
    char *keywords; 
    char *desc; 
    char *father;
    // the father TclClassClass (optional)
    char *members;
    // list of members
    char *cls;
    // a pointer to the classname
    RT_TclClassMethodDescription constr;
    // contains the constructor description of the class
    // the classname is equal to the constructor name 
    RT_GeneralList methods;
    // a list containing the method descriptions
    void set_keywords(char *_s) {
	delete keywords;
	keywords = new char[strlen (_s) + 1 ];
	strcpy( keywords, _s );
    }
    const char *get_keywords() const { return keywords; }
    void set_desc(char *_s) {
	delete desc;
	desc = new char[strlen (_s) + 1 ];
	strcpy( desc, _s );
    }
    char *get_desc() const { return desc; }
    char *get_father() const { return father; }
    void print(FILE *f) const {
	fprintf( f, "##### Class %s #####\n%s %s %s {%s} ", cls, (char*)constrCmd, cls, strcmp( father, "") ? father : "{}", members );
	constr.print( f );
	methods.print( f );
	fprintf( f, "%s -keywords {%s}\n", cls, get_keywords() );
	fprintf( f, "%s -description {%s}\n", cls, get_desc() );
    }
    RT_TclClassClassDescription(char *_fa, char *_mb): constrCmd( "<?>") {
	constr.mth = 0;
	keywords = new char[2];
	*keywords = 0;
	desc = new char[2];
	*desc = 0;
	father = new char[ strlen( _fa) + 1 ];
	strcpy( father, _fa );
	members = new char[ strlen( _mb) + 1 ];
	strcpy( members, _mb );
    }
    ~RT_TclClassClassDescription() {
	delete father;
	delete keywords;
	delete desc;
    }
    void help();
    // get help informations
    int isA(const  char *_c) const { return RTM_isA( RTN_TCL_CLASS_CLASS_DESCRIPTION, _c ); }
};

class RT_TclClassList {
  protected:  
    RT_String cName;

    RT_TclClassClassDescription *desc;
    // a link to the related TclClassClassDescription
    RT_TclClassMemberList members;
    char *getName() { return (char*)cName; }

    void addMembers( char *);
    // add entries for members in the members list
    // the string should contain null, one or more names
    // of members separated by spaces

    int callMethod( RT_TclClassClassDescription*, char **, int = 0 );
    // call a Tcl method by evaluating the args
    // if the int is = 0 (default) - it's a standard method
    // else it is the constructor
    // returns the number of successful method calls

    static RT_TclClassMethodDescription *find(Tcl_Interp*, int, char *[]);
    // find a method description of class argv[1] and method argv[2]
    // returns 0 if not nothing found
  public:
    static RT_GeneralList classes;
    // a list containing all class descriptions

    static void clearClasses();
    // remove all class descriptions

    // ##### the Tcl/C++ methods:
    RT_TclClassList(char*,RT_TclClassClassDescription *);
    virtual ~RT_TclClassList();
    virtual int isA(const char*) const;
    virtual const char *get_keywords() const { return desc->keywords; }
    virtual const char *get_class() const { return desc->cls; }
    virtual const char *get_description() const { return desc->desc;} 
    
    // ##### the Tcl commands:
    virtual int objectCMD(char *argv[]);

    // interface for coupling a class browser:
    static int addClassCMD(ClientData, Tcl_Interp*, int, char*[]);
    static int addMethodCMD(ClientData, Tcl_Interp*, int, char*[]);
    static int getClassesCMD(ClientData, Tcl_Interp*, int, char*[]);
    static int getMethodsCMD(ClientData, Tcl_Interp*, int, char*[]);
    static int getParameterCMD(ClientData, Tcl_Interp*, int, char*[]);
    static int getDescriptionCMD(ClientData, Tcl_Interp*, int, char*[]);
    static int getBodyCMD(ClientData, Tcl_Interp*, int, char*[]);
    static int getFatherCMD(ClientData, Tcl_Interp*, int, char*[]);
    static int deleteClassCMD(ClientData, Tcl_Interp*, int, char*[]);
    static int deleteMethodCMD(ClientData, Tcl_Interp*, int, char*[]);
    static int printClassesCMD(ClientData, Tcl_Interp*, int, char*[]);
    static int includeClassCMD(ClientData, Tcl_Interp*, int, char*[]);
};

extern const char *RTD_TCL_OBJECT; 

class RT_TclObject: public RT_Object, public RT_TclClassList {
  public:
    // ##### the Tcl/C++ methods:
    RT_TclObject(char *, RT_TclClassClassDescription *, char **);
    virtual ~RT_TclObject() {}
    void printCon(FILE *f) const { fprintf( f, "%s %s -ignore", desc->cls, get_name()); }
    void print(FILE *f) const {
	printCon( f );
	fprintf( f, "\n%s -members ", get_name() );
	members.getMembers( get_name() );
	members.print( f );
	fprintf( f, "\n" );
    }
    int isA(const char *cl) const { return RT_Object::isA( cl ) || RT_TclClassList::isA( cl ); }  
    const char *get_keywords() const { return RT_TclClassList::get_keywords(); }
    const char *get_class() const { return RT_TclClassList::get_class(); }
    const char *get_description() const { return RT_TclClassList::get_description();} 

    // ##### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp*, int, char*[]);
    static int addClassCMD(ClientData, Tcl_Interp*, int, char*[]);
    int objectCMD(char *args[]) { return RT_TclClassList::objectCMD( args ); }
};

extern const char *RTD_TCL_PRIMITIVE;

class RT_TclPrimitive: public RT_Primitive, public RT_TclClassList {
  public:
    // ##### the Tcl/C++ methods:
    RT_TclPrimitive(char *, RT_TclClassClassDescription *, char **);
    virtual ~RT_TclPrimitive() {}
    void printCon(FILE *f) const { fprintf( f, "%s %s -ignore", desc->cls, get_name()); }
    void print(FILE *f) const {
	RT_Primitive::print( f );
	fprintf( f, "\n%s -members ", get_name() );
	members.getMembers( get_name() );
	members.print( f );
	fprintf( f, "\n" );
    }
    int isA(const char *cl) const { return RT_Primitive::isA( cl ) || RT_TclClassList::isA( cl ); }  
    const char *get_keywords() const { return RT_TclClassList::get_keywords(); }
    const char *get_class() const { return RT_TclClassList::get_class(); }
    const char *get_description() const { return RT_TclClassList::get_description();} 

    // ##### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp*, int, char*[]);
    static int addClassCMD(ClientData, Tcl_Interp*, int, char*[]);
    int objectCMD(char *args[]) {
	return RT_Primitive::objectCMD( args) + RT_TclClassList::objectCMD( args);
    }
};

extern const char *RTD_TCL_INPUT_DEVICE;

class RT_TclInputDevice: public RT_InputDevice, public RT_TclClassList {
    static RT_ParseEntry table[];
    //#### the statics for parameter parsing:
    static int callCBF, callCLDF;
    RT_Event *xevent;
  public:
    void event(RT_Event *);

    // ##### the Tcl/C++ methods:
    RT_TclInputDevice(char *, RT_TclClassClassDescription *, char **);
    virtual ~RT_TclInputDevice() {}
    void printCon(FILE *f) const { fprintf( f, "%s %s -ignore", desc->cls, get_name()); }
    void print(FILE *f) const {
	RT_InputDevice::print( f );
	fprintf( f, "\n%s -members ", get_name() );
	members.getMembers( get_name() );
	members.print( f );
	fprintf( f, "\n" );
    }
    int isA(const char *cl) const { return RT_InputDevice::isA( cl ) || RT_TclClassList::isA( cl ); }  
    const char *get_keywords() const { return RT_TclClassList::get_keywords(); }
    const char *get_class() const { return RT_TclClassList::get_class(); }
    const char *get_description() const { return RT_TclClassList::get_description();} 

    // ##### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp*, int, char*[]);
    static int addClassCMD(ClientData, Tcl_Interp*, int, char*[]);
    int objectCMD(char *args[]);
};

#endif

