////////////////////////////////////////////////////////////////////////////////
//  A simple animation of primitives.                                         //  
//  LAST EDIT: Fri Aug  5 09:09:31 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include <yart.h>

RT_Quader *quad;
RT_Polygon *po;
RT_Axes *ax;
RT_LookatCamera *cam;
RT_Polyhedron *ph;
RT_Polyvertex *py;
RT_Surface su;

int runCMD(ClientData, Tcl_Interp *, int, char *[]) {
    float f = 1;
    int p = 1;
    while(1) {
	cam->rendering();
	py->vtDeleteSurface( p );
	p++;
	if (p == 7) p = 0;
	py->vtSurface( p, su );
	po->rotate( RT_Vector( 0, -0.2, 0 ));
	quad->rotate( RT_Vector( -0.2, 0, 0 ));
	ax->rotate( RT_Vector( -0.01, 0, -0.2 ));
	ph->rotate( RT_Vector( -0.02, 0, 0 ));
	py->vtPoint( 5, RT_Vector( 0, f, 0 ));
	f += 0.01;
	if (f > 3) f = -1;
    }
    // never reached:
    return TCL_OK;
}

int main() {
    RT_init();

    RTM_command( "run", runCMD );

    rt_AttributeObject->fillstyle( 1 );
    
    RT_Scene *sc = new RT_Scene("sc");
    
    RT_Light *al;
    sc->insert( al = new RT_AmbientLight( "al" ));
    al->color( RT_Color( 0.2, 0.2, 0 ));
    
    RT_Vector vs[10];
    int nr  = 0;
    vs[nr++] = RT_Vector( -1,0,-1 );
    vs[nr++] = RT_Vector( 1,0,-1 );
    vs[nr++] = RT_Vector( 1, 0,1 );
    vs[nr++] = RT_Vector( -1,0,1 );
    vs[nr++] = RT_Vector( -1,0,-1 );
    vs[nr++] = RT_Vector( 0,1,0 );
    vs[nr++] = RT_Vector( 1,0,1 );
    py = new RT_Polyline( "py", nr, vs );    
    sc->insert( py);
    py->diffuse( RT_Color( 1,1,1));
    py->gnormal( RT_Vector( 0,1, 0.1));

    // data for points, surfaces, normals:
    RT_Vector coord[4];
    RT_Surface phsf[4];
    RT_Vector phvec[4];
    phsf[0].emmi = RT_Color(1,0,0);
    phsf[1].emmi = RT_Color(0,1,0);
    phsf[2].emmi = RT_Color(0,0,1);
    phsf[3].diff = RT_Color(1,0,0);
    coord[0] = RT_Vector(-1.5, 0.5, 1.0);
    coord[1] = RT_Vector(0.5, -1.5, 3.0);
    coord[2] = RT_Vector(0.5, 1.5, 3.0);
    coord[3] = RT_Vector(1.5, 0.3, 1.0);

    // indices for facets:
    static int f1[3] = { 0,1,2 };
    static int f2[3] = { 1,3,2 };
    RT_Facet fac[2];
    fac[0] = RT_Facet( 3, f1);
    fac[1] = RT_Facet( 3, f2);

    // create the polyhedron with the datas from above:
    ph = new RT_Polyhedron( "ph", 4, 2, fac, coord, phsf, phvec );

    // commented because core dump when using X11 shader
    //    sc->insert( ph ); 
    
    // change the fillstyle to solid:
    ph->fillstyle(1);
    //    ph->diffuse( RT_Color( 0.2,0,1));
    //    ph->gnormal( RT_Vector( 0,1, 0.1));
    ph->scale(RT_Vector(0.5, 0.5, 0.5));

    // add two points to the polyhedron:
    RT_Vector p2[2];
    p2[0] = RT_Vector(2.0,-0.3,2.0);
    p2[1] = RT_Vector(2.2,1.6,1.0);
    ph->appendPoints(2,p2,0,0);

    // add one facet with four points to the polyhedron:
    static int f3[4] = { 2,3,4,5 };
    RT_Facet fac2 = RT_Facet( 4, f3 );
    ph->appendFacets(1, &fac2);
    
    // change the color of one point via indirect access: (facet #, point #)
    phsf[0].emmi = RT_Color(1,1,0);
    ph->vtSurface(2,3,phsf[0]);
    
    sc->insert( ax = new RT_Axes( "ax"));
    ax->scale( RT_Vector( 2,2,2));

    RT_Vector pg[10];
    int pgnr  = 0;
    pg[pgnr++] = RT_Vector( -1,-1,-1 );
    pg[pgnr++] = RT_Vector( 1,-1,-1 );
    pg[pgnr++] = RT_Vector( 1, -1,1 );
    pg[pgnr++] = RT_Vector( -1,-1,1 );
    po = new RT_Polygon( "po", pgnr, pg );
    sc->insert( po );
    po->scale( RT_Vector( 2,1,0.5));
    po->diffuse( RT_Color( 1,1,1));
    po->gnormal( RT_Vector( 0,1, 0.1));

    RT_Spline *sp;
    RT_Vector spv[10];
    int spn  = 0;
    spv[spn++] = RT_Vector( -1,1,-1 );
    spv[spn++] = RT_Vector( 1,2,-1 );
    spv[spn++] = RT_Vector( 1,2,1 );
    spv[spn++] = RT_Vector( -1,1,1 );
    sc->insert( sp = new RT_Spline( "sp", spn, spv ));
    sp->gnormal( RT_Vector( 1,0, 0));

    sc->insert( quad = new RT_Quader( "quad", 1, 1, 1 ));
    quad->diffuse( RT_Color( 1,1,1));

    RT_Light *red = new RT_PointLight( "red" );
    red->color( RT_Color(1,0,0));
    red->origin( RT_Vector( 3, 1, 10));
    sc->insert( red );

    RT_Light *blue = new RT_PointLight( "blue" );
    blue->color( RT_Color(0,0,1));
    blue->origin( RT_Vector( -5, 3, 4));
    sc->insert( blue );

    RT_PixmapDisplay *px = new RT_PixmapDisplay( "px", 700, 700 );
    px->doublebuffer();
    cam = new RT_LookatCamera("cam", RT_Vector( 5, 5, 10), RT_Vector(0,0,0));
    cam->zfar( 15 ); cam->angle( 20 );

    sp->diffuse( RT_Color( 1, 1, 0 ));
    su.tran = 1;
    su.diff.setRGB( 0, 1, 0 );
    po->vtSurface(1 , su );
    su.diff.setRGB( 0, 0, 1 );
    po->vtSurface(2 , su );
    su.diff.setRGB( 1, 0, 0 );
    po->vtSurface(0 , su );
    py->vtSurface(1 , su );

    cam->pixmap( px );
    cam->scene( sc );
    sp->diffuse( RT_Color( 1, 1, 1 ));

    fprintf( stdout, "Initial rendering. X11 port users stay in tune, please.\n" );
    cam->rendering();
    fprintf( stdout, "Type \"run\" to have a little animation.\n" );

    RT_FileDevice *console = new RT_FileDevice( "console", 0, 1 ); 
    console->addCB( new RT_ConsoleInputCB );
    
    rt_InputServer->loop();
}

