////////////////////////////////////////////////////////////////////////////////
// This file shows how to change the normals and/or intersections of an AUTOMA//
// TICALLY ray-traced primitive.                                              //  
//  LAST EDIT: Tue Aug 16 10:55:01 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include <yart.h>

void BP_bumpWall(RT_Vector &pt, RT_Vector &orig) {
    // a very simple bump mapping

    double dx = pt.x; double dy = pt.y; double dz = pt.z; 

    const int BP_D = 10;

    while (dx < 0) dx += BP_D;
    while (dx > BP_D) dx -= BP_D;

    while (dy < 0) dy += BP_D;
    while (dy > BP_D) dy -= BP_D;

    orig = RT_Vector( 0,0,1 );
    if ( dx < 0.1 * BP_D ) {
	if ( dx < dy && (BP_D - dy) > dx  ) orig.x = 1;
    }
    else if ( dx > 0.9 * BP_D ) {
	if ( dx > dy && (BP_D - dy) < dx  )  orig.x = -1;
    }
    if ( dy < 0.1 * BP_D ) { 
	if ( dy < dx && (BP_D - dx) > dy ) orig.y = 1;
    }
    else if ( dy > 0.9 * BP_D ) {
	if ( dy > dx && (BP_D - dx) < dy ) orig.y = -1;
    }
    orig = orig.UNITIZE();
}

class BP_BumpPlane: public RT_Primitive {
    RT_Plane *pl;
  public:
    BP_BumpPlane(char *a): RT_Primitive( a ) {
	pl = new RT_Plane( 0, 0,0,1,0 );
	pl->father( this);
    }
    ~BP_BumpPlane() { delete pl; }

    const char *get_class() const { return "BumpPlane"; }
    const char *get_description() const { return "A little demo showing how to manipulate the normals and intersections of parts, that are automatically raytraced."; }


    int intersect(const RT_Ray &aa, RT_InterSectionList &bb) {
	int r = pl->intersect( aa, bb );
	bb.replace( pl, this );
	return r;
	// get intersections from list, and replace pl with this
    }
    void normal(const RT_Vector &a, RT_Vector &b) {
	pl->normal(a,b); 
	BP_bumpWall(wc2mc( a), b );
    } 
};

int main() {
    RT_init();
    RT_Pixmap *display = new RT_PixmapDisplay( "display", 200, 200 );
    RT_LookatCamera *cam = new RT_LookatCamera( "cam", RT_Vector( 0,0,40), RT_Vector( 0,0,0));
    RT_Scene *sc = new RT_Scene( "sc" );
    cam->scene( sc ); cam->pixmap( display ); cam->angle( 60 ); cam->mode( RTE_LC_RAY_TRACING );

    RT_Primitive *bump = new BP_BumpPlane( "bump" );
    bump->diffuse( RT_Color( 1,1,1));

    sc->insert( bump, new RT_Sphere( "sp", 5 ), 0);

    RT_Light *al = new RT_AmbientLight( "al" );
    al->color( RT_Color( 0.1,0.1,0.1 ));
    sc->insert( al );

    RT_Light *pl = new RT_PointLight( "pl" );
    pl->color( RT_Color( 0.5, 0.5, 1.0 ));
    pl->origin(RT_Vector( 2, 5, 5 ));
    sc->insert( pl );

    RT_Light *pl2 = new RT_PointLight( "pl2" );
    pl2->color( RT_Color( 1, 1, 1 ));
    pl2->origin(RT_Vector( -8, -3, 13 ));
    sc->insert( pl2 );

    cam->rendering();

    (new RT_FileDevice( 0, 0, 1 ))->addCB( new RT_ConsoleInputCB );
    
    rt_InputServer->loop();
}
