////////////////////////////////////////////////////////////////////////////////
//  A crazy quadmesh                                                          //  
//  LAST EDIT: Tue Aug  9 18:34:14 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

extern "C" {
#include <math.h>
}

#include <yart.h>

double xSize = 2;
double ySize = 2;

const int xDim = 10;
const int yDim = 10;

int main() {
    RT_Vector vecs[xDim * yDim];
    RT_Vector tmp;
    tmp.y = 0;

    double dx = xSize / (double)xDim;
    double dy = ySize / (double)yDim;

    double tmpx, tmpy = 0;
    for (int i = 0; i < yDim; i++) {
	tmp.z = tmpy;
	tmpx = 0;
	for (int j = 0; j < yDim; j++) {
	    tmp.x = tmpx;
	    vecs[i * xDim + j] = tmp;
	    tmpx += dx;
	}
	tmpy += dy;
    }

    RT_init(); 
    RT_Scene *sc = new RT_Scene( "sc" );
    RT_Quadmesh *qu = new RT_Quadmesh( "qu", xDim, yDim, vecs );
    sc->insert( qu );
    qu->fillstyle( 1 );
    
    RT_Light *red = new RT_PointLight( "red" );
    red->color( RT_Color(1,0,0));
    red->origin( RT_Vector( 0, 10, 0));
    sc->insert( red );

    RT_PixmapDisplay *p1 = new RT_PixmapDisplay( "p1", 800, 800 );
    p1->doublebuffer();

    RT_LookatCamera *cam = new RT_LookatCamera( "cam", RT_Vector( 5,5,10), RT_Vector( 0,0,0) );
    cam->angle( 20 ); cam->zfar( 15 );
    cam->scene( sc );  cam->pixmap( p1 );

    RT_Surface surf;
    surf.diff = RT_Color( 0.2, 0.2, 0.2 );
    qu->surface( surf );
    surf.diff = RT_Color( 1, 1, 1 );
    int x = 0, y = 0, ox = 0, oy = 0;
    RT_Vector point;

    while (1) {
	switch (random() & (long)3) {	
	  case 0:
	    if ( x < (xDim-1)) x++;
	    break;
	  case 1:
	    if ( x > 0) x--;
	    break;
	  case 2:
	    if ( y < (yDim-1)) y++;
	    break;
	  case 3:
	    if ( y > 0) y--;
	    break;
	}
	qu->vtDeleteSurface( ox, oy );
	
	qu->vtSurface( x, y, surf );
	point = qu->get_vtPoint( x, y );
	point.y = ((random() & 31) - 15) * 0.03;
	qu->vtPoint( x, y, point );
	qu->computeNormals();

	ox = x; oy = y;
	cam->rendering();
    }
}
