////////////////////////////////////////////////////////////////////////////////
//  This file demonstrates text features.                                     //  
//  LAST EDIT: Fri Aug  5 09:09:27 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include <yart.h>

RT_Axes *ax;
RT_LookatCamera *cam;
RT_Text *t;

int runCMD(ClientData, Tcl_Interp *, int, char *[]) {
    double w = 5.0;
    double h = 0.7;
    float wincr = 0.05;
    float hincr = 0.05;
    int rounds = 0;
    while (1) {
	cam->rendering();
	t->height(h);
	t->width(w);
	w += wincr;
	h += hincr;
	if ( w> 8.0 ) wincr = -wincr;
	if ( w<= 0.5) wincr = -wincr;
	if ( h> 4.0 ) hincr = -hincr;
	if ( h<= 0.5) hincr = -hincr;
	rounds++;
	if ( rounds == 500 ) t->text( "It's enough !!!" );
	if ( rounds == 1000 ) t->text( "... boring. Really." );
	ax->rotate( RT_Vector( -0.2, 0, 0 ));
    }
    // never reached:
    return TCL_OK;
}

int main() {
    RT_init(); 

    RTM_command( "run", runCMD );

    RT_Scene *sc = new RT_Scene("sc");

    RT_Light *al;
    sc->insert( al = new RT_AmbientLight( "al" ));
    al->color( RT_Color( 0.2, 0.2, 0 ));
    
    sc->insert( t = new RT_Text( "txt", "It's only a test !", RT_Vector(0, 0, 0)) );

    t->xalign(0);
    t->yalign(0);
    t->height(0.8);
    t->width(2.0);
    t->diffuse( RT_Color(1, 0, 0) );

    RT_Light *red = new RT_PointLight( "red" );
    red->color( RT_Color(1,1,1));
    red->origin( RT_Vector( 3, 1, 10));
    sc->insert( red );

    RT_Light *blue = new RT_PointLight( "blue" );
    blue->color( RT_Color(1,1,1));
    blue->origin( RT_Vector( -5, 3, 4));
    sc->insert( blue );

    sc->insert( ax = new RT_Axes( "ax"));

    RT_PixmapDisplay *px = new RT_PixmapDisplay( "px", 400, 400 );
    px->doublebuffer();
    cam = new RT_LookatCamera("cam", RT_Vector( 5, 5, 10), RT_Vector(0,0,0));
    cam->zfar( 15 ); cam->angle( 40 );

    cam->pixmap( px );
    cam->scene( sc );
    cam->rendering();
    char cmd[100];
    fprintf( stdout, "Type \"run\" to have a little animation.\n" );

    RT_FileDevice *console = (RT_FileDevice *)RT_Object::getObject( "console" );
    console = new RT_FileDevice( "console", 0, 1 ); 
    console->addCB( new RT_ConsoleInputCB );
    
    rt_InputServer->loop();
}




