////////////////////////////////////////////////////////////////////////////////
//  Example for a user-defined interaction class.                             //  
//  LAST EDIT: Fri Aug  5 09:09:26 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include <yart.h>

const char *RTN_POLYVERTEX_EDITOR = "PolyvertexEditor";

class RT_PolyvertexEditor: public RT_InputDevice {
    RT_Locator *loc;
    RT_Polyvertex *pv;
  public:
    RT_PolyvertexEditor(char *n, RT_Polyvertex *_pv): RT_InputDevice( n ), pv(_pv) {
	loc = new RT_Locator( 0 );
    }
    ~RT_PolyvertexEditor() { delete loc; }

    void father(RT_Object *o) {
	loc->father( o );
	RT_InputDevice::father( o );
    }

    void event(RT_Event *ev) {
	if ( ev && ev->isA( RTN_BUTTON_EVENT )) {
	    RT_ButtonEvent &pev = *(RT_ButtonEvent*)ev;
	    if (pev.left) {
		pv->vtInsert( pv->get_number(), loc->get_location() );
		if (get_father() && get_father()->isA( RTN_CAMERA ))
		    ((RT_Camera*)get_father())->refresh();
	    }
	    else if (pev.right) callCBs();
	}
	else loc->event( ev );
    }
    
    const char *get_description() const {  return "A polyvertex editor may be used to add vertices to an polyvertex based object like a polyline or polygon. The cursor position may be changed with mouse motions and rigt button pressed down. A left button click adds the current vertex to th primitive; a right button click calls the callbacks meaning the end of the editing."; }
    const char *get_class() const { return RTN_POLYVERTEX_EDITOR; } 
    int isA(const char *c) const { 
	return RT_InputDevice::isA( c ) || RTM_isA( RTN_POLYVERTEX_EDITOR, c );
    }
};

main() {
    RT_init();
    RT_eval( "source $env(GOOD_ROOT_DIR)/YART/demos/spheres.yrt; delete pi" );
    RT_Vector v( 0, 0, 0 );
    (new RT_PolyvertexEditor( "polyed", new RT_Polyline( "pl", 1, &v, 0, 0 )))
	->father( RT_Object::getObject( "cam" ) );
    RT_eval( "sc -insert pl" );
    rt_InputServer->loop();
}



