////////////////////////////////////////////////////////////////////////////////
//  A three-dimensional vector class and some similar and trivial classes.    //  
//  LAST EDIT: Tue Mar  7 15:56:08 1995 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#ifndef __VECTOR_H__
#define __VECTOR_H__

#ifndef RTD_CPP_INCLUDES
extern "C" {
#endif

#include <math.h>
#include <stdio.h>

#ifndef RTD_CPP_INCLUDES
}
#endif

#include "global.h"

#define RTM_MAX(a,b) a>b?a:b

class RT_Vector {
    friend class RT_Matrix;
  public:
    double x, y, z;
    RT_Vector() { x = y = z = 0; }
    RT_Vector(const RT_Vector &v) { x = v.x; y = v.y; z = v.z; }
    RT_Vector( double _val[3]): x(_val[0]), y(_val[1]), z(_val[2]) {  }
    RT_Vector( double a, double b , double c): x(a), y(b), z(c) {}
    int operator ==(const RT_Vector &) const;
    RT_Vector operator + (const RT_Vector &v) const { RT_Vector c( x+v.x, y+v.y,z+v.z);return c; }
    RT_Vector operator -( const RT_Vector &v) const {RT_Vector c( x-v.x, y-v.y, z-v.z );return c; }
    RT_Vector operator *(const double d) const {RT_Vector c(x*d, y*d, z*d);return c;  }
    // vector operators:
    double ABS() const {return sqrt( x*x + y*y + z*z);   }
    RT_Vector SCALE(double f) const {	return *this * f;    }
    double DOT(const RT_Vector &v) const {
	return x*v.x + y*v.y + z*v.z;    
    }
    RT_Vector CROSS(const RT_Vector &v) const {
	RT_Vector c(y*v.z - z*v.y, z*v.x - x*v.z, x*v.y - y*v.x   );return c;   
    }
    RT_Vector EVAL(const RT_Vector &v) const {
	RT_Vector c(x*v.x, y*v.y, z*v.z );return c;  
    }
    RT_Vector UNITIZE() const {
	double r = ABS();
	if (r == 0.) r = 1.; // avoiding numerical overflows 
	RT_Vector c(x/r, y/r, z/r);
	return c;
    }
    RT_Vector NEGATE() {RT_Vector c( -x, -y, -z );return c; }
    // print the vector:
    void print(FILE *f, char *n = 0) const {
	fprintf( f, "%s{%lf %lf %lf} ", n ? n : "", x, y, z );
    }
    void get(double f[3]) const { f[0] = x; f[1] = y; f[2] = z; }
    void get(float f[3]) const { f[0] = x; f[1] = y; f[2] = z; }
    RT_Vector MAXIMAL(const RT_Vector &v) const {
	// return a vector with the maximal value of both vectors in EACH direction:
	return RT_Vector( RTM_MAX( x, v.x),  RTM_MAX( y, v.y),  RTM_MAX( z, v.z) );
    }
};

class RT_Ray {
  public:
    RT_Ray() { tmin = rt_RayEps; tmax = HUGE; }
    RT_Vector pt, dir;
    double tmin, tmax;
    void print(FILE *f) const {
	fprintf( f, "[%lf, %lf %lf] + t [%lf %lf %lf]\n",
		pt.x, pt.y, pt.z, dir.x, dir.y, dir.z );
    }
    int valid(double t) const {
	return (t > tmin) && (t < tmax);
    }
    int valid(double bmin, double bmax) const {
	// sort it:
	if (bmin > bmax) {
	    double t = bmin; bmin = bmax; bmax = t;
	}
	return !(( bmax < tmin) || (bmin > tmax ));
    }
};

class RT_Point {
  public:
    float x, y;
    RT_Point(float _x = 0.0, float _y = 0.0): x(_x), y(_y) {}
};

class RT_Bounds {
  public:
    RT_Vector min, max; 
    void print(FILE *f) { fprintf( f, "x: %lf %lf, y: %lf %lf, z: %lf %lf\n",
				  min.x, max.x, min.y, max.y, min.z, max.z ); }
    RT_Bounds(): min( 0,0,0), max( 0,0,0) {}
};

#endif




