#ifndef lint
/* static char *SccsId = "@(#)comment.c 3.1 (Delft University of Technology) 08/14/92"; */
#endif
/**********************************************************

Name/Version      : seadali/3.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.J. van der Hoeven
                    P. van der Wolf
Creation date     : 27-March-1991


        ESE Electronic Systems Engineering B.V.
	Martinus Nijhofflaan 2, Suite 7.21
	2624 ES Delft
	Phone: - 31 15 627266
	Fax:   - 31 15 624621

        COPYRIGHT (C) 1991, All rights reserved
**********************************************************/
#ifdef ESE
#include "header.h"
#include "comment.h"
#include <math.h>

extern  DM_CELL * ckey;

extern int   pict_arr[];
extern int   Textnr;

Comment * firstElement = NULL;

int line (x1, y1, x2, y2, arrow_mode)
Coor x1, y1, x2, y2;
int arrow_mode;
{
    Comment * element;

    MALLOC (element, Comment);
    element -> type = LINE;
    LINEOBJ.arrow_mode = arrow_mode;
    LINEOBJ.x1 = x1;
    LINEOBJ.y1 = y1;
    LINEOBJ.x2 = x2;
    LINEOBJ.y2 = y2;
    add_comment (element);

    pict_arr[Textnr] = DRAW;

    return 1;
}

int text (x, y, orient)
Coor x, y;
int orient;
{
    Comment * element;
    char * rindex ();

    MALLOC (element, Comment);
    element -> type = TXT;
    ask_string ("enter_text: ", TEXTOBJ.text);

    if (rindex (TEXTOBJ.text, '~') != NULL) {
	ptext ("text contains illegal character '~'");
	free ((char *) element);
	return 0;
    }

    TEXTOBJ.orient = orient;
    TEXTOBJ.x = x;
    TEXTOBJ.y = y;
    add_comment (element);

    pict_arr[Textnr] = DRAW;

    return 1;
}

float comm_dist (x, y, element)
Coor x, y;
Comment * element;
{
    float d1, d2;
    float width, height;
    double sqrt ();

    switch (element -> type) {
	case LINE:
	    d1 = sqrt ((double) ((LINEOBJ.x1 - x) * (LINEOBJ.x1 - x) +
		    (LINEOBJ.y1 - y) * (LINEOBJ.y1 - y)));
	    d2 = sqrt ((double) ((LINEOBJ.x2 - x) * (LINEOBJ.x2 - x) +
		    (LINEOBJ.y2 - y) * (LINEOBJ.y2 - y)));
	    return Min (d1, d2);
	case TXT:
	    d1 = sqrt ((double) ((TEXTOBJ.x - x) * (TEXTOBJ.x - x) +
		    (TEXTOBJ.y - y) * (TEXTOBJ.y - y)));
	    return d1;
	default:
	    return 20;
    }
}

Comment * find_comment (x, y)
Coor x, y;
{
    float width, height;
    float length = 0;

    Comment * element;
    float dist;

    ch_siz (& width, & height);

    for (element = firstElement; element != NULL;
	    element = element -> next) {
	dist = comm_dist (x, y, element);
	if (dist < (width + height)) {
	    return element;
	}
    }
    return NULL;
}

del_comment (element)
Comment * element;
{
    if (!element) {
	return;
    }

    if (firstElement == element) {
	firstElement = element -> next;
    }
    if (element -> next) {
	element -> next -> prev = element -> prev;
    }
    if (element -> prev) {
	element -> prev -> next = element -> next;
    }
    free (element);

    pict_arr[Textnr] = ERAS_DR;
}

void draw_all_comments () {
    Comment * element;

    for (element = firstElement; element != NULL;
				    element = element -> next) {
	switch (element -> type) {
	    case LINE:
		show_line ((float) LINEOBJ.x1, (float) LINEOBJ.y1,
		    (float) LINEOBJ.x2, (float) LINEOBJ.y2, LINEOBJ.arrow_mode);
		break;
	    case TXT:
		show_text ((float) TEXTOBJ.x, (float) TEXTOBJ.y,
			TEXTOBJ.text, TEXTOBJ.orient);
		break;
	}
    }
}

static int add_comment (element)
Comment * element;
{
    element -> next = firstElement;
    element -> prev = NULL;
    if (firstElement) {
	firstElement -> prev = element;
    }
    firstElement = element;
    return 1;
}

static int show_text (x, y, text, mode)
float x;
float y;
char * text;
int mode;
{
    float width, height;
    float length = 0;

    ch_siz (& width, & height);
    switch (mode) {
        case LEFT:
            break;
        case RIGHT:
            length = strlen (text) * width;
            x -= length;
            break;
        case CENTER:
            length = strlen (text) * width;
            x -= length/2;
            break;
        default:
            break;
    }
    d_text (x, y, text);
    return 1;
}

static show_line (x1, y1, x2, y2, arrow_mode)
float x1, y1, x2, y2;
int arrow_mode;
{
    float width, height;
    float length = 0;
    float dx, dy;
    float newdx, newdy;

    ch_siz (& width, & height);

    width *= 2;

    dx = x2 - x1;
    dy = y2 - y1;

    length = sqrt (dx * dx + dy * dy);

    dx = (dx / length) * width * 1.5;
    dy = (dy / length) * width * 1.5;

    d_line (x1, y1, x2, y2);

    if (arrow_mode & FW_ARROW) {
	rotate (-dx, -dy, ARRANGLE, &newdx, &newdy);
	d_line (x2, y2, x2 + newdx, y2 + newdy);
	rotate (-dx, -dy, -ARRANGLE, &newdx, &newdy);
	d_line (x2, y2, x2 + newdx, y2 + newdy);
    }

    if (arrow_mode & BW_ARROW) {
	rotate (dx, dy, ARRANGLE, &newdx, &newdy);
	d_line (x1, y1, x1 + newdx, y1 + newdy);
	rotate (dx, dy, -ARRANGLE, &newdx, &newdy);
	d_line (x1, y1, x1 + newdx, y1 + newdy);
    }
    return 1;
}

static int rotate (xin, yin, angle, xout, yout)
float xin, yin, * xout, * yout;
double angle;
{
    * xout = cos (angle) * xin + sin (angle) * yin;
    * yout = -sin (angle) * xin + cos (angle) * yin;
}

inp_comment (cellKey)
DM_CELL * cellKey;
{
    Comment * element;
    DM_STREAM * dmfp;
    int type;
    int x1, y1, x2, y2;
    int x, y;

    if (!(dmfp = dmOpenStream (cellKey, "annotations", "r"))) {
        return (-1);
    }

    while (dmScanf (dmfp, "%d", &type) == 1) {
	MALLOC (element, Comment);
	element -> type = type;

	switch (type) {
	    case LINE:
		if (dmScanf (dmfp, "%d %d %d %d %d\n",
			&x1, &y1, &x2, &y2, &(LINEOBJ.arrow_mode)) != 5) {
		    goto err;
		}
		LINEOBJ.x1 = x1 * QUAD_LAMBDA;
		LINEOBJ.y1 = y1 * QUAD_LAMBDA;
		LINEOBJ.x2 = x2 * QUAD_LAMBDA;
		LINEOBJ.y2 = y2 * QUAD_LAMBDA;
		break;
	    case TXT:
		/* Need quoted strings, because they can contain spaces. */
		if (dmScanf (dmfp, "%d %d %d ~%[^~]~\n",
			&x, &y,
			&(TEXTOBJ.orient), TEXTOBJ.text) != 4) {
		    goto err;
		}
		TEXTOBJ.x = x * QUAD_LAMBDA;
		TEXTOBJ.y = y * QUAD_LAMBDA;
		break;
        }
	add_comment (element);
    }
    dmCloseStream (dmfp, COMPLETE);
    return (0);

err:
    dmCloseStream (dmfp, QUIT);
    return (-1);
}

outp_comment () {
    DM_STREAM * dmfp;
    Comment * element;

    if (!(dmfp = dmOpenStream (ckey, "annotations", "w"))) {
        return (FALSE);
    }

    for (element = firstElement;
	    element != NULL;
	    element = element -> next) {
	switch (element -> type) {
	    case LINE:
		dmPrintf (dmfp, "%d %d %d %d %d %d\n",
			LINE,
			LINEOBJ.x1 / QUAD_LAMBDA, LINEOBJ.y1 / QUAD_LAMBDA,
			LINEOBJ.x2 / QUAD_LAMBDA, LINEOBJ.y2 / QUAD_LAMBDA,
			LINEOBJ.arrow_mode);
		break;
	    case TXT:
		dmPrintf (dmfp, "%d %d %d %d ~%s~\n",
			TXT,
			TEXTOBJ.x / QUAD_LAMBDA, TEXTOBJ.y / QUAD_LAMBDA,
			TEXTOBJ.orient, TEXTOBJ.text);
		break;
        }
    }
    dmCloseStream (dmfp, COMPLETE);
    return TRUE;
}

void comment_win (ll, rr, bb, tt)
Coor * ll;
Coor * rr;
Coor * bb;
Coor * tt;
{
    
    Comment * element;

    if (firstElement == NULL) {
	*ll = *rr = *bb = *tt = 0;
	return;
    }

    element = firstElement;
    /* It is necessary to initialize the bounding box */
    switch (element -> type) {
	case LINE:
	    *ll = LINEOBJ.x1;
	    *rr = LINEOBJ.x1;
	    *bb = LINEOBJ.y1;
	    *tt = LINEOBJ.y1;
	    break;
	case TXT:
	    *ll = TEXTOBJ.x;
	    *rr = TEXTOBJ.x;
	    *bb = TEXTOBJ.y;
	    *tt = TEXTOBJ.y;
	    break;
    }

    for (element = firstElement;
	    element != NULL;
	    element = element -> next) {
	switch (element -> type) {
	    case LINE:
		*ll = Min (*ll, Min (LINEOBJ.x1, LINEOBJ.x2));
		*rr = Max (*rr, Max (LINEOBJ.x1, LINEOBJ.x2));
		*bb = Min (*bb, Min (LINEOBJ.y1, LINEOBJ.y2));
		*tt = Max (*tt, Max (LINEOBJ.y1, LINEOBJ.y2));
		break;
	    case TXT:
		*ll = Min (*ll, TEXTOBJ.x - QUAD_LAMBDA);
		*rr = Max (*rr, TEXTOBJ.x + QUAD_LAMBDA);
		*bb = Min (*bb, TEXTOBJ.y - QUAD_LAMBDA);
		*tt = Max (*tt, TEXTOBJ.y + QUAD_LAMBDA);
		break;
        }
    }
}

int no_comments () {
    if (firstElement == NULL) {
	return TRUE;
    }
    else {
	return FALSE;
    }
}

empty_comments () {
    while (firstElement != NULL) {
	del_comment (firstElement);
    }
}
#endif
