// Thought you'd get C, but you ended up looking at a -*- C++ -*- header file!
//
// 	@(#)set.h 1.12 08/19/94 Delft University of Technology
// 

#ifndef __SET_H			// only include this stuff once...
#define __SET_H

#include <stream.h>
#include <stdlib.h>

#ifndef NIL
#   define NIL 0
#endif
#ifndef TRUE
#   define TRUE 1
#endif

const MaintainBackwardReference = TRUE;	// 3rd argument to construct of set.

// In this file we declare/define the following classes:
class set;
class setElmt;
class setNextElmtIterator;
class setPrevElmtIterator;

//////////////////////////////////////////////////////////////////////////////
//				      set                                   //
//////////////////////////////////////////////////////////////////////////////
enum setOrdering
{
   NonOrderedSet, IncreasingOrderedSet, DecreasingOrderedSet
};

class set
{
   setElmt     *firstelmt,*lastelmt;
   setOrdering ordering;
   char        *name;
   int         elmtcount;
   int         maintainBackRef;	// TRUE if we must maintain setElmt.myset
   friend class setNextElmtIterator;
   friend class setPrevElmtIterator;
protected:
   virtual void postElmtInstallHandler(setElmt *) {}
public:
   set(setOrdering =NonOrderedSet, char * =NIL,
       int maintainBackwardReference = NIL);
   virtual ~set();
   set	        *add(setElmt *);    // add a new element to the set
   set	        *remove(setElmt *); // remove one element from the set
   set	        *del(setElmt *); // delete one element in the set
   set	        *delAll();	    // delete all elements in the set
   int	        isEmpty();	    // return TRUE if set is empty
   set          *move(set *s);	    // move elmts from s to this set
   set          *unite(set *s);	    // alias for move()
   void	        putName(char *thename);	// (re)name the set
   char	        *getName() {return name;} // return the name of the set
   setOrdering  getOrdering() {return ordering;}
   int size()   {return elmtcount;}
   virtual setElmt *firstElmt() {return firstelmt;}
   virtual setElmt *lastElmt() {return lastelmt;}
   virtual setElmt *nextElmt(setElmt *);
   virtual setElmt *prevElmt(setElmt *);
   void ckConsistency();	// abort if data structure is corrupted
   virtual void print();
};


//////////////////////////////////////////////////////////////////////////////
//				    setElmt                                 //
//////////////////////////////////////////////////////////////////////////////
class setElmt
{
   setElmt *nxt,*prv;
   set     *myset;		// pointer to the set this elmt is part of
   friend class set;
   friend class setNextElmtIterator;
   friend class setPrevElmtIterator;
public:
   setElmt() {nxt=prv=NIL; myset=NIL;}
   set *mySet() {return myset;}
   virtual ~setElmt() {}
   virtual int ordinate() {return 0;} // used by set::add() for ordering
   virtual void print();
};

///////////////////////////////////////////////////////////////////////////////
// ...and now for some iterators!

///////////////////////////////////////////////////////////////////////////////
//			      setNextElmtIterator			     //
///////////////////////////////////////////////////////////////////////////////
class setNextElmtIterator
{
private:
   setElmt *currentelmt;
   int     ordinate,filter; // ordinate and theset only used if filter!=NIL
   set     *theset;
   void    initialize2();
public:
   setNextElmtIterator(set *s);
   setNextElmtIterator(set *s, int ord);
   setElmt *operator()();	// return the next setElmt in the set
   int     more() {return currentelmt!=NIL;} // TRUE if anything left
   void    initialize(set *s);
   void    initialize(set *s, int ord);
   void    skip(setElmt*);
};

///////////////////////////////////////////////////////////////////////////////
//			      setPrevElmtIterator			     //
///////////////////////////////////////////////////////////////////////////////
class setPrevElmtIterator
{
private:
   setElmt *currentelmt;
   int     ordinate,filter; // ordinate and theset only used if filter!=NIL
   set     *theset;
   void    initialize2();
public:
   setPrevElmtIterator(set *s);
   setPrevElmtIterator(set *s, int ord);
   setElmt *operator()();	// return the previous setElmt in the set
   int     more() {return currentelmt!=NIL;} // TRUE if anything left
   void    initialize(set *s);
   void    initialize(set *s, int ord);
   void    skip(setElmt*);
};

///////////////////////////////////////////////////////////////////////////////

void ::setError(const char *msg ="unknown error");


#endif // __SET_H
