/*
 *                            COPYRIGHT
 *
 *  PCB, interactive printed circuit board design
 *  Copyright (C) 1994,1995 Thomas Nau
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Contact addresses for paper mail and Email:
 *  Thomas Nau, Schlehenweg 15, 88471 Baustetten, Germany
 *  Thomas.Nau@rz.uni-ulm.de
 *
 *  RCS: $Header: move.h,v 2.1 94/09/28 14:26:15 nau Exp $
 */

/* prototypes for move routines
 */

#ifndef	__MOVE_INCLUDED__
#define	__MOVE_INCLUDED__

#include "global.h"

/* ---------------------------------------------------------------------------
 * some useful transformation macros and constants
 */
#define	MOVE(xs,ys,deltax,deltay)							\
	{														\
		((xs) += (deltax));									\
		((ys) += (deltay));									\
	}
#define	MOVE_VIA_LOWLEVEL(v,dx,dy)	MOVE((v)->X,(v)->Y,(dx),(dy))
#define	MOVE_PIN_LOWLEVEL(p,dx,dy)	MOVE((p)->X,(p)->Y,(dx),(dy))
#define	MOVE_ARC_LOWLEVEL(a,dx,dy)	MOVE((a)->X,(a)->Y,(dx),(dy))
#define	MOVE_LINE_LOWLEVEL(l,dx,dy)							\
	{														\
		MOVE((l)->X1,(l)->Y1,(dx),(dy))						\
		MOVE((l)->X2,(l)->Y2,(dx),(dy))						\
	}
#define	MOVE_BOX_LOWLEVEL(b,dx,dy)		\
	{									\
		MOVE((b)->X1,(b)->Y1,(dx),(dy))	\
		MOVE((b)->X2,(b)->Y2,(dx),(dy))	\
	}
#define	MOVE_TEXT_LOWLEVEL(t,dx,dy)								\
	{															\
		MOVE_BOX_LOWLEVEL(&((t)->BoundingBox),(dx),(dy));		\
		MOVE((t)->X, (t)->Y, (dx), (dy));						\
	}

#define	MOVE_TYPES              \
	(VIA_TYPE | LINE_TYPE | TEXT_TYPE | \
	ELEMENT_TYPE | ELEMENTNAME_TYPE | POLYGON_TYPE | POLYGONPOINT_TYPE)


/* ---------------------------------------------------------------------------
 * prototypes
 */
void	MovePolygonLowLevel(PolygonTypePtr, Position, Position);
void	MoveElementLowLevel(ElementTypePtr, Position, Position);
void	MoveObject(int, void *, void *, Position, Position);

#endif
