/*-------------------------------------------------------------------------
 *
 * heap.h--
 *    prototypes for functions in lib/catalog/heap.c
 *
 *
 * Copyright (c) 1994, Regents of the University of California
 *
 * heap.h,v 1.3 1995/02/21 23:21:40 andrew Exp
 *
 *-------------------------------------------------------------------------
 */
#ifndef HEAP_H
#define HEAP_H

extern Relation heap_creatr(char *relname, unsigned natts,
			    unsigned smgr, TupleDesc att);

extern void CheckAttributeNames(unsigned natts, TupleDesc tupdesc);
extern int RelationAlreadyExists(Relation pg_class_desc, char relname[]);
extern void AddNewAttributeTuples(Oid new_rel_oid, unsigned natts,
				  TupleDesc tupdesc);
extern void addNewRelationType(Name typeName, Oid new_rel_oid);

extern void AddPgRelationTuple(Relation pg_class_desc,
	Relation new_rel_desc, Oid new_rel_oid, int arch, unsigned natts);

extern Oid heap_create(char relname[], int arch, unsigned natts,
		       unsigned smgr, TupleDesc tupdesc);

extern void RelationRemoveInheritance(Relation relation);
extern void RelationRemoveIndexes(Relation relation);
extern void DeletePgRelationTuple(Relation rdesc);
extern void DeletePgAttributeTuples(Relation rdesc);
extern void DeletePgTypeTuple(Relation rdesc);
extern void heap_destroy(char relname[]);

#endif	/* HEAP_H */
