/*-------------------------------------------------------------------------
 *
 * c.h--
 *    Fundamental C definitions.  This is included by every .c file in
 *    postgres.
 *
 *
 * Copyright (c) 1994, Regents of the University of California
 *
 * c.h,v 1.11 1995/05/25 17:58:11 andrew Exp
 *
 *-------------------------------------------------------------------------
 */
/*
 *   TABLE OF CONTENTS
 *
 *	When adding stuff to this file, please try and put stuff
 *	into the relevent section, or add new sections as appropriate.
 *
 *    section	description
 *    -------	------------------------------------------------
 *	1)	palloc debugging defines
 *	2)	bool, true, false, TRUE, FALSE
 *	3)	__STDC__, non-ansi C definitions:
 *		Pointer typedef, NULL
 *		cpp magic macros
 *		ARGS() prototype macro
 *		type prefixes: const, signed, volatile, inline
 *
 *	4)	standard system types
 *	5)	malloc, free, malloc_debug stuff, new, delete, ALLOCATE
 *	6)	IsValid macros for system types
 *	7)	offsetof, lengthof, endof 
 *	8)	exception handling definitions, Assert, Trap, etc macros
 *	9)	Min, Max, Abs macros
 *	10)	<dead> (was LintCast, RevisionId, RcsId, SccsId macros)
 *	11)	<dead>
 *	12)	externs
 *	13)	system-specific hacks
 *
 *   NOTES
 *	This file reorganized as a result of eliminating wastful
 *	nested IsValid calls -cim 4/27/91
 *
 *	This file is MACHINE AND COMPILER dependent!!!  (For now.)
 *
 * ----------------------------------------------------------------
 */
#ifndef	C_H
#define C_H

/* ----------------------------------------------------------------
 *		Section 1:  palloc debugging defines
 * ----------------------------------------------------------------
 */

/* ----------------
 *	file / line macros
 *
 *	_FLD_ 		File/Line Data
 *	_FLV_ 		File/Line Variables
 *	_FLV_DCL_ 	File/Line Variable Declarations
 *
 *	the FLD0 and FLV0 macros are for functions taking no arguments
 * ----------------
 */
#define _FLD_ 		__FILE__, __LINE__, 
#define _FLD0_ 		__FILE__, __LINE__
#define _FLV_ 		_FL_file, int _FL_line,
#define _FLV0_ 		_FL_file, int _FL_line
#define _FLV_DCL_ 	char *_FL_file; int _FL_line;
#define _FL_PRINT_	printf("f: %s l: %d ", _FL_file, _FL_line)

/* ----------------
 *	storage managers
 *
 *	These are experimental and are not supported in the code that
 *	we distribute to other sites.
 * ----------------
 */
#ifdef SEQUOIA
#define MAIN_MEMORY
#endif

/* -------------------
 *	buffer pool pin count debugging stuff
 * -------------------
 */
#undef BUFMGR_DEBUG

#ifdef BUFMGR_DEBUG
#define IncrBufferRefCount(buffer)	IncrBufferRefCount_Debug(_FLD_ buffer)
#define ReleaseBuffer(buffer)		ReleaseBuffer_Debug(_FLD_ buffer)
#define ReleaseAndReadBuffer(buffer, relation, blockNum) \
		ReleaseAndReadBuffer_Debug(_FLD_ buffer, relation, blockNum)
#define ReadBuffer(reln, blockNum)	ReadBuffer_Debug(_FLD_ reln, blockNum)
#define WriteBuffer(buffer)		WriteBuffer_Debug(_FLD_ buffer)
/*
#define PinBuffer(buf)			PinBuffer_Debug(_FLD_ buf)
#define UnpinBuffer(buf)		UnpinBuffer_Debug(_FLD_ buf)
*/
#endif /* BUFMGR_DEBUG */

/*
 * Begin COMPILER DEPENDENT section
 */

/* ----------------------------------------------------------------
 *		Section 2:  bool, true, false, TRUE, FALSE
 * ----------------------------------------------------------------
 */
/*
 * bool --
 *	Boolean value, either true or false.
 *
 */
#define false	((char) 0)
#define true	((char) 1)
typedef char	bool;
typedef bool	*BoolPtr;

#ifndef TRUE
#define TRUE	1
#endif /* TRUE */
#ifndef FALSE
#define FALSE	0
#endif /* FALSE */

/* ----------------------------------------------------------------
 *		Section 3: __STDC__, non-ansi C definitions:
 *
 *		cpp magic macros
 *		ARGS() prototype macro
 *		Pointer typedef, NULL
 *		type prefixes: const, signed, volatile, inline
 * ----------------------------------------------------------------
 */

#ifdef	__STDC__ /* ANSI C */

#if defined(__GNUC__)
#define PROTOTYPES
#endif

/*
 * Pointer --
 *	Variable holding address of any memory resident object.
 */

/*
 *	XXX Pointer arithmetic is done with this, so it can't be void *
 *	under "true" ANSI compilers.
 */
typedef char *Pointer;

#ifndef	NULL
/*
 * NULL --
 *	Null pointer.
 */
#define NULL	((void *) 0)
#endif	/* !defined(NULL) */

#define	HAVE_ANSI_CPP	/* all ANSI C compilers must have this! */
#if defined(NEED_STD_HDRS)
#undef NEED_STD_HDRS	/* all ANSI systems must have stddef/stdlib */
#endif /* NEED_STD_HDRS */

#else	/* !defined(__STDC__) */ /* NOT ANSI C */

/*
 * Pointer --
 *	Variable containing address of any memory resident object.
 */
typedef char	*Pointer;

#ifndef	NULL
/*
 * NULL --
 *	Null pointer.
 */
#define NULL	0
#endif	/* !defined(NULL) */

/*
 * const --
 *	Type modifier.  Identifies read only variables.
 *
 * Example:
 *	extern const Version	RomVersion;
 */
#define const		/* const */

/*
 * signed --
 *	Type modifier.  Identifies signed integral types.
 */
#define signed		/* signed */

/*
 * volatile --
 *	Type modifier.  Identifies variables which may change in ways not
 *	noticeable by the compiler, e.g. via asynchronous interrupts.
 *
 * Example:
 *	extern volatile unsigned int	NumberOfInterrupts;
 */
#define volatile	/* volatile */

#endif	/* !defined(__STDC__) */ /* NOT ANSI C */

/*
 * CppAsString --
 *	Convert the argument to a string, using the C preprocessor.
 * CppConcat --
 *	Concatenate two arguments together, using the C preprocessor.
 */
#if defined(HAVE_ANSI_CPP)

#define CppAsString(identifier)	#identifier
#define CppConcat(x, y)		x##y
#define CppConcat0(x, y)	x##y
#define CppConcat1(x, y)	x##y
#define CppConcat2(x, y)	x##y
#define CppConcat3(x, y)	x##y
#define CppConcat4(x, y)	x##y

#else /* !HAVE_ANSI_CPP */

#define CppAsString(identifier)	"identifier"

/*
 * CppIdentity -- On Reiser based cpp's this is used to concatenate
 *	two tokens.  That is
 *		CppIdentity(A)B	==> AB
 *	We renamed it to _private_CppIdentity because it should not
 *	be referenced outside this file.  On other cpp's it
 *	produces  A  B.
 */
#define _priv_CppIdentity(x)x
#define CppConcat(x, y)		_priv_CppIdentity(x)y
#define CppConcat0(x, y)	_priv_CppIdentity(x)y
#define CppConcat1(x, y)	_priv_CppIdentity(x)y
#define CppConcat2(x, y)	_priv_CppIdentity(x)y
#define CppConcat3(x, y)	_priv_CppIdentity(x)y
#define CppConcat4(x, y)	_priv_CppIdentity(x)y

#endif /* !HAVE_ANSI_CPP */

#ifndef __GNUC__	/* GNU cc */
# define inline
#endif

#if defined(NEED_STD_HDRS)
/*
 * You're doomed.  We've removed almost all of our own C library 
 * extern declarations because they conflict on the different
 * systems.  You'll have to write your own stdlib.h.
 */
#include "stdlib.h"
#else /* NEED_STD_HDRS */
#include <stddef.h>
#include <stdlib.h>
#endif /* NEED_STD_HDRS */

/* ----------------------------------------------------------------
 *		Section 4:  standard system types
 * ----------------------------------------------------------------
 */

/*
 * End COMPILER DEPENDENT section
 */


/*
 * Begin COMPILER AND HARDWARE DEPENDENT section
 */

/*
 * intN --
 *	Signed integer, AT LEAST N BITS IN SIZE,
 *	used for numerical computations.
 */
typedef signed char	int8;		/* >= 8 bits */
typedef signed short	int16;		/* >= 16 bits */
typedef signed int	int32;		/* >= 32 bits */

/*
 * uintN --
 *	Unsigned integer, AT LEAST N BITS IN SIZE,
 *	used for numerical computations.
 */
typedef unsigned char	uint8;		/* >= 8 bits */
typedef unsigned short	uint16;		/* >= 16 bits */
typedef unsigned int	uint32;		/* >= 32 bits */

/*
 * floatN --
 *	Floating point number, AT LEAST N BITS IN SIZE,
 *	used for numerical computations.
 *
 *	Since sizeof(floatN) may be > sizeof(char *), always pass
 *	floatN by reference.
 */
typedef float		float32data;
typedef double		float64data;
typedef float		*float32;
typedef double		*float64;

/*
 * boolN --
 *	Boolean value, AT LEAST N BITS IN SIZE.
 */
typedef uint8		bool8;		/* >= 8 bits */
typedef uint16		bool16;		/* >= 16 bits */
typedef uint32		bool32;		/* >= 32 bits */

/*
 * bitsN --
 *	Unit of bitwise operation, AT LEAST N BITS IN SIZE.
 */
typedef uint8		bits8;		/* >= 8 bits */
typedef uint16		bits16;		/* >= 16 bits */
typedef uint32		bits32;		/* >= 32 bits */

/*
 * wordN --
 *	Unit of storage, AT LEAST N BITS IN SIZE,
 *	used to fetch/store data.
 */
typedef uint8		word8;		/* >= 8 bits */
typedef uint16		word16;		/* >= 16 bits */
typedef uint32		word32;		/* >= 32 bits */

/*
 * Size --
 *	Size of any memory resident object, as returned by sizeof.
 */
typedef unsigned int	Size;

/*
 * Index --
 *	Index into any memory resident array.
 *
 * Note:
 *	Indices are non negative.
 */
typedef unsigned int	Index;

#define MAXDIM 6
typedef struct {
	int indx[MAXDIM];
} IntArray;

/*
 * Offset --
 *	Offset into any memory resident array.
 *
 * Note:
 *	This differs from an Index in that an Index is always
 *	non negative, whereas Offset may be negative.
 */
typedef signed int	Offset;

/*
 * String --
 *	String of characters.
 */
typedef char	*String;

/* ----------------------------------------------------------------
 *		Section 5:  malloc, free, malloc_debug stuff
 *			    new, delete macros
 * ----------------------------------------------------------------
 */
/* ----------------------------------------------------------------
 *		Section 6:  IsValid macros for system types
 * ----------------------------------------------------------------
 */
/*
 * BoolIsValid --
 *	True iff bool is valid.
 */
#define	BoolIsValid(boolean)	((boolean) == false || (boolean) == true)

#define boolIsValid(b) \
    ((bool) ((b) == false || (b) == true))

/*
 * PointerIsValid --
 *	True iff pointer is valid.
 */
#define PointerIsValid(pointer)	(bool)((void*)(pointer) != NULL)

/*
 * PointerIsInBounds --
 *	True iff pointer is within given bounds.
 *
 * Note:
 *	Assumes the bounded interval to be [min,max),
 *	i.e. closed on the left and open on the right.
 */
#define PointerIsInBounds(pointer, min, max) \
	((min) <= (pointer) && (pointer) < (max))

/*
 * PointerIsAligned --
 *	True iff pointer is properly aligned to point to the given type.
 */
#define PointerIsAligned(pointer, type)	\
	(((long)(pointer) % (sizeof (type))) == 0)

/*
 * SizeIsValid --
 *	True iff size is valid.
 *
 * Note:
 *	Assumes that Size is an unsigned type.
 *
 *	Assumes valid size to be in the interval (0,infinity).
 */
#define SizeIsValid(size)		((size) > 0)

/*
 * SizeIsInBounds --
 *	True iff size is within given bounds.
 *
 * Note:
 *	Assumes Size is an unsigned type.
 *
 *	Assumes the bounded interval to be (0,max].
 */
#define SizeIsInBounds(size, max)	(0 < (size) && (size) <= (max))

/*
 * IndexIsValid --
 *	True iff index is valid.
 *
 * Note:
 *	Assumes Index is an unsigned type.
 *
 *	Assumes valid index to be in the interval [0,infinity).
 */
#define IndexIsValid(index)	true

/*
 * IndexIsInBounds --
 *	True iff index is within given bounds.
 *
 * Note:
 *	Assumes Index is an unsigned type.
 *
 *	Assumes the bounded interval to be [0,max).
 */
#define IndexIsInBounds(index, max)	((index) < (max))

/*
 * OffsetIsInBounds --
 *	True iff offset is within given bounds.
 *
 * Note:
 *	Assumes the bounded interval to be [0,max).
 */
#define OffsetIsInBounds(offset, min, max) \
	((min) <= (offset) && (offset) < (max))

/*
 * StringIsValid --
 *	True iff string is valid.
 */
#define	StringIsValid(string)	PointerIsValid(string)

/*
 * End COMPILER AND HARDWARE DEPENDENT section
 */

/*
 * Begin COMPILER AND MACHINE INDEPENDENT section
 */
/* ----------------------------------------------------------------
 *		Section 7:  offsetof, lengthof, endof
 * ----------------------------------------------------------------
 */
/*
 * offsetof --
 *	Offset of a structure/union field within that structure/union.
 *
 *	XXX This is supposed to be part of stddef.h, but isn't on
 *	some systems (like SunOS 4).
 */
#ifndef offsetof
#define offsetof(type, field)	((long) &((type *)0)->field)
#endif /* offsetof */

/*
 * lengthof --
 *	Number of elements in an array.
 */
#define lengthof(array)	(sizeof (array) / sizeof ((array)[0]))

/*
 * endof --
 *	Address of the element one past the last in an array.
 */
#define endof(array)	(&array[lengthof(array)])

/* ----------------------------------------------------------------
 *		Section 8:  exception handling definitions
 *			    Assert, Trap, etc macros
 * ----------------------------------------------------------------
 */
/*
 * Exception Handling definitions
 */

typedef String	ExcMessage;
typedef struct Exception {
	ExcMessage	message;
} Exception;

extern Exception	FailedAssertion;
extern Exception	BadArg;
extern Exception	BadState;

/* in utils/error/assert.c */
extern int ExceptionalCondition(String conditionName,
	Exception *exceptionP, String details,
	String fileName, int lineNumber);


/*
 * NO_ASSERT_CHECKING, if defined, turns off all the assertions.
 * - plai  9/5/90
 *
 * It should _NOT_ be undef'ed in releases or in benchmark copies
 * 
 * #undef NO_ASSERT_CHECKING
 */

/*
 * Trap --
 *	Generates an exception if the given condition is true.
 *
 */
#define Trap(condition, exception) \
	{ if (condition) \
		ExceptionalCondition(CppAsString(condition), &(exception), \
			(String)NULL, __FILE__, __LINE__); }

/*    
 *  TrapMacro is the same as Trap but it's intended for use in macros:
 *
 *	#define foo(x) (AssertM(x != 0) && bar(x))
 *
 *  Isn't CPP fun?
 */
#define TrapMacro(condition, exception) \
    ((bool) ((! condition) || \
	     (ExceptionalCondition(CppAsString(condition), \
				  &(exception), \
				  (String) NULL, __FILE__, __LINE__))))
    
#ifdef NO_ASSERT_CHECKING
#define Assert(condition)
#define AssertMacro(condition)	true
#define AssertArg(condition)
#define AssertState(condition)
#else
#define Assert(condition) \
	Trap(!(condition), FailedAssertion)

#define AssertMacro(condition) \
	TrapMacro(!(condition), FailedAssertion)

#define AssertArg(condition) \
	Trap(!(condition), BadArg)

#define AssertState(condition) \
	Trap(!(condition), BadState)

#endif   /* NO_ASSERT_CHECKING */

/*
 * LogTrap --
 *	Generates an exception with a message if the given condition is true.
 *
 */
#define LogTrap(condition, exception, printArgs) \
	{ if (condition) \
		ExceptionalCondition(CppAsString(condition), &(exception), \
			form printArgs, __FILE__, __LINE__); }

/*    
 *  LogTrapMacro is the same as LogTrap but it's intended for use in macros:
 *
 *	#define foo(x) (LogAssertMacro(x != 0, "yow!") && bar(x))
 */
#define LogTrapMacro(condition, exception, printArgs) \
    ((bool) ((! condition) || \
	     (ExceptionalCondition(CppAsString(condition), \
				   &(exception), \
				   form printArgs, __FILE__, __LINE__))))
    
#ifdef NO_ASSERT_CHECKING
#define LogAssert(condition, printArgs)
#define LogAssertMacro(condition, printArgs) true
#define LogAssertArg(condition, printArgs)
#define LogAssertState(condition, printArgs)
#else
#define LogAssert(condition, printArgs) \
	LogTrap(!(condition), FailedAssertion, printArgs)

#define LogAssertMacro(condition, printArgs) \
	LogTrapMacro(!(condition), FailedAssertion, printArgs)

#define LogAssertArg(condition, printArgs) \
	LogTrap(!(condition), BadArg, printArgs)

#define LogAssertState(condition, printArgs) \
	LogTrap(!(condition), BadState, printArgs)

#endif   /* NO_ASSERT_CHECKING */

/* ----------------------------------------------------------------
 *		Section 9:  Min, Max, Abs macros
 * ----------------------------------------------------------------
 */
/*
 * Max --
 *	Return the maximum of two numbers.
 */
#define Max(x, y)	((x) > (y) ? (x) : (y))

/*
#ifndef MAX
#define MAX(x, y)	((x) > (y) ? (x) : (y))
#endif
*/

/*
 * Min --
 *	Return the minimum of two numbers.
 */
#define Min(x, y)	((x) < (y) ? (x) : (y))

/*
 * Abs --
 *	Return the absolute value of the argument.
 */
#define Abs(x)		((x) >= 0 ? (x) : -(x))

/* ----------------------------------------------------------------
 *		Section 12: externs
 * ----------------------------------------------------------------
 */

/* ----------------
 *	form is used by assert and the exception handling stuff
 * ----------------
 */
extern String form(char *fmt, ...);

/* ----------------------------------------------------------------
 *		Section 13: system-specific hacks
 *
 *	This should be limited to things that absolutely have to be
 *	included in every source file.  The changes should be factored
 *	into a separate file so that changes to one port don't require
 *	changes to c.h (and everyone recompiling their whole system).
 * ----------------------------------------------------------------
 */

#if defined(PORTNAME_hpux) 
#include "port/hpux/fixade.h"		/* for 8.07 unaligned access fixup */
#endif /* PORTNAME_hpux */

#if defined(PORTNAME_sparc)
#define	memmove(d, s, l)	bcopy(s, d, l)
#endif

/* These are for things that are one way on Unix and another on NT */
#ifndef WIN32
#define	NULL_DEV	"/dev/null"
#define COPY_CMD	"cp"
#define SEP_CHAR	'/'
#else
#define NULL_DEV	"NUL"
#define COPY_CMD	"copy"
#define SEP_CHAR 	'\\'
#endif /* WIN32 */

#if defined(WIN32)
#include "port/win32/nt.h"
#endif /* WIN32 */

/* ----------------
 *	end of c.h
 * ----------------
 */
#endif	/* C_H */
