#-------------------------------------------------------------------------
#
# Makefile.inc--
#    Makefile for the parser module
#
# Copyright (c) 1994, Regents of the University of California
#
#
# IDENTIFICATION
#    /usr/local/devel/pglite/cvs/src/backend/parser/Makefile.inc,v 1.3 1995/03/22 19:58:51 andrew Exp
#
#-------------------------------------------------------------------------

VPATH:= $(VPATH):$(CURDIR)/parser

PARSEYACCS= gram.c parse.h

$(PARSEYACCS): gram.y
	cd $(objdir); \
	yacc $(YFLAGS) $<; \
	mv y.tab.c gram.c; \
	mv y.tab.h parse.h

$(objdir)/gram.o: gram.c
	$(cc_inobjdir)


scan.c:	scan.l
	cd $(objdir); lex $<; mv lex.yy.c scan.c

$(objdir)/scan.o: scan.c
	$(cc_inobjdir)


SRCS_PARSER+= analyze.c catalog_utils.c dbcommands.c gram.c io.c \
	keywords.c parser.c parse_query.c scan.c scanner.c 

CLEANFILES+= scan.c ${PARSEYACCS}

POSTGRES_DEPEND+= scan.c $(PARSEYACCS)

#.if ${PORTNAME} == "bsd44"
#YFLAGS+= -l
#.endif

HEADERS+= catalog_utils.h io.h parse_query.h parsetree.h \
	dbcommands.h keywords.h
