/*-------------------------------------------------------------------------
 *
 * buf.h--
 *    Basic buffer manager data types.
 *
 *
 * Copyright (c) 1994, Regents of the University of California
 *
 * buf.h,v 1.2 1995/03/03 07:57:05 andrew Exp
 *
 *-------------------------------------------------------------------------
 */
#ifndef	BUF_H
#define BUF_H

#define InvalidBuffer	(0)
#define UnknownBuffer	(-99999)

typedef long	Buffer;

#define BUFFER_IS_LOCAL(b)		((b) < 0)


/*
 * BufferIsInvalid --
 *	True iff the buffer is invalid.
 */
#define BufferIsInvalid(buffer)	 ((buffer) == InvalidBuffer)

/*
 * BufferIsUnknown --
 *	True iff the buffer is unknown.
 */
#define BufferIsUnknown(buffer)  ((buffer) == UnknownBuffer)


/*
 * If NO_BUFFERISVALID is defined, all error checking using BufferIsValid()
 * are suppressed.  Decision-making using BufferIsValid is not affected.
 * This should be set only if one is sure there will be no errors.
 * - plai 9/10/90
 */
#undef NO_BUFFERISVALID

#endif	/* BUF_H */
