/*-------------------------------------------------------------------------
 *
 * off.h--
 *    POSTGRES disk "offset" definitions.
 *
 *
 * Copyright (c) 1994, Regents of the University of California
 *
 * off.h,v 1.2 1995/04/09 20:27:32 andrew Exp
 *
 *-------------------------------------------------------------------------
 */
#ifndef	OFF_H
#define OFF_H

#include "c.h"
#include "machine.h"		/* for BLCKSZ */
#include "storage/itemid.h"

typedef uint16		OffsetNumber;
typedef uint16		OffsetIndex;

#define InvalidOffsetNumber	((OffsetNumber) 0)
#define FirstOffsetIndex	((OffsetIndex) 0)
#define	MaxOffsetNumber		((OffsetNumber) (BLCKSZ / sizeof(ItemIdData)))
#define	OffsetNumberMask	(0xffff)		/* valid uint16 bits */

/* ----------------
 *	support macros
 * ----------------
 */

/*
 * OffsetNumberIsValid --
 *	True iff the offset number is valid.
 */
#define OffsetNumberIsValid(offsetNumber) \
    ((bool) ((offsetNumber != InvalidOffsetNumber) && \
	     (offsetNumber <= MaxOffsetNumber)))

#endif	/* OFF_H */

