#-------------------------------------------------------------------------
#
# postgres.lib.mk--
#    rules for building libraries. To use the rules, set the following
#    variables:
#	LIBSRCS    - source files for objects to be built in the library
#	LIB	   - name of the library (eg. LIB=pq for libpq.a)
#    postgres.mk should be included before this file.
#
# Copyright (c) 1994-5, Regents of the University of California
#
#
# IDENTIFICATION
#    /usr/local/devel/pglite/cvs/src/mk/postgres.lib.mk,v 1.8 1995/05/25 23:27:46 jolly Exp
#
#-------------------------------------------------------------------------

LIBOBJS:=	$(LIBSRCS:.c=.o)
ifndef LINUX_ELF
lib:=		lib$(LIB).a
else
lib:=		lib$(LIB).so.1
endif

$(lib):	$(addprefix $(objdir)/,$(LIBOBJS))
	@rm -f $(objdir)/$(lib)
ifdef LINUX_ELF
	cd $(objdir); gcc -shared -o $(lib) $(LIBOBJS)
	cp $(objdir)/$(lib) /lib
else
ifdef MK_NO_LORDER
	cd $(objdir); $(AR) $(AROPT) $(lib) $(LIBOBJS); $(RANLIB) $(lib)
else
	cd $(objdir); $(AR) $(AROPT) $(lib) `lorder $(LIBOBJS) | tsort`; $(RANLIB) $(lib)
endif
endif

CLEANFILES+= $(LIBOBJS) $(lib)

install:: localobj $(lib)
	$(INSTALL) $(INSTL_LIB_OPTS) $(objdir)/$(lib) $(DESTDIR)$(LIBDIR)/$(lib)
	@cd $(DESTDIR)$(LIBDIR); $(RANLIB) $(lib)


