#!/bin/sh
# /usr/local/devel/pglite/cvs/src/test/regress/regress.sh,v 1.4 1995/04/29 21:05:06 jolly Exp
#
if [ -d ./obj ]; then
	cd ./obj
fi

#FRONTEND=monitor
FRONTEND="psql -n -e -q"

echo =============== destroying old regression database... =================
destroydb regression

echo =============== creating new regression database... =================
createdb regression
if [ $? -ne 0 ]; then
     echo createdb failed
     exit 1
fi

$FRONTEND regression < create.sql
if [ $? -ne 0 ]; then
     echo the creation script has an error
     exit 1
fi

echo =============== running regression queries ... =================
$FRONTEND regression < queries.sql
if [ $? -ne 0 ]; then
     echo the queries script causes an error
     exit 1
fi

echo =============== running error queries ... =================
$FRONTEND regression < errors.sql
if [ $? -ne 0 ]; then
     echo the errors script has an unanticipated problem
     exit 1
fi

echo =============== clearing regression database... =================
$FRONTEND regression < destroy.sql
if [ $? -ne 0 ]; then
     echo the destroy script has an error
     exit 1
fi

echo =============== destroying regression database... =================
destroydb regression
if [ $? -ne 0 ]; then
     echo destroydb failed
     exit 1
fi

exit 0
