#ifndef lint
static       char    rcsid[] = "$Header: block.c,v 1.1 90/06/17 03:34:51 zhang Exp $";
#endif

/*
 * $Log:	block.c,v $
 * 
 * Revision 1.1  90/06/17  03:34:51  zhang
 * Initial revision
 * 
 */

#include "defs.h"

#define	BLOCKFLAG_ANONYMOUS	1	/* an "anonymous" block */
#define	BLOCKFLAG_ATTRIBUTES	2	/* a block having attributes */

/*
 * data struture for a block is defined in defs.h
 */

#ifdef	NEVER_DEFINED
typedef	struct	block	{
	CHAR	*name;			/* block name */
	INT	flag;			/* block type flags */
	FLOAT	basepoint[3];		/* block base points */
	ENTITY	*entitylist;		/* list of entities in the block */
	ATTRIB	*attrib;		/* attributes of the block, if any */
	LAYER	*layerlist;		/* layers defined in the block */
/*	LAYER	*layer;			 * layer name of the block * 
					 * NOT USED NOW */
	OPTIONS	*options;		/* optional parameters */
	BLOCK	*next;			/* next block in the list */
} BLOCK;
#endif

/*
 * parse a BLOCK
 */

BLOCK	*BlockDxfParse()
{
	BLOCK	*block;
	ENTITY	*entity;
	ENTITY	*entitylisttail;
	OPTIONS	*endblkoptions;
	INT	layernameset = 0;
	INT	blocknameset = 0;
	INT	blocktypeset = 0;
	INT	blockbaseset = 0;
	INT	defaultflag = 0;

	block = Malloc(BLOCK, 1);

	/*
	 * parse the block header
	 */

	do {
		GetNextGroup();
		switch(Group->code) {
		case 8:
			/*
			 * layer name
			 */

			if (layernameset != 0)
				DXFERR("duplicated layer name %s for a BLOCK\n",
					Group->string);

			/*
			 * should the layer name of a block be process ?
			 *
			 * block->layer = Malloc(LAYER, 1);
			 * block->layer->name =
			 * 	Malloc(CHAR, strlen(Group->string) + 1);
			 */

			layernameset = 1;
			break;

		case 2:
			/*
			 * block name
			 */

			if (blocknameset != 0)
				DXFERR("duplicated name %s for a BLOCK\n",
					Group->string);

			blocknameset = 1;

			block->name = Malloc(CHAR, strlen(Group->string) + 1);
			(VOID) strcpy(block->name, Group->string);

			/*
			 * check if the block is defined
			 */

			if (BlockSearch(block->name) != NULL)
				DXFERR("BLOCK %s redefined\n", Group->string);

			break;

		case 70:
			/*
			 * block type flags
			 * its value must be 1 or 2
			 *
			 * some time the value is 64, i do not know why :-(
			 */

			if (blocktypeset != 0)
				DXFERR("duplicated type %s for a BLOCK\n",
					Group->string);

			/*
			 * should the block type be check ?
			 *
			 * if (Group->intnum != BLOCKFLAG_ANONYMOUS &&
			 *     Group->intnum != BLOCKFLAG_ATTRIBUTES) {
			 *	DXFERR("wrong flag %s for a BLOCK\n",
			 *			Group->string);
			 */

			blocktypeset = 1;
			block->flag = Group->intnum;
			break;

		case 10:
			/*
			 * block base point
			 * 10, 20, 30
			 */

			if (blockbaseset != 0)
				DXFERR("duplicated base point for an BLOCK %s", "\n");

			blockbaseset = 1;
			CoordDxfParse(0, block->basepoint);
			break;

		default:
			if (OptionsDxfParse(&block->options) == 0)
				defaultflag = 1;
			break;
		}
	} while (defaultflag == 0);

	/*
	 * check if layer name, block name, block type flags
	 * and block base point are all defined
	 */

	if (blocknameset == 0)
		DXFERR("name undefined for a BLOCK %s", "\n");

	if (layernameset == 0)
		DXFERR("layer undefined for BLOCK %s\n", block->name);

	if (blocktypeset == 0)
		DXFERR("type undefined for BLOCK %s\n", block->name);

	if (blockbaseset == 0)
		DXFERR("base point undefined for BLOCK %s\n", block->name);

	/*
	 * parse the block body
	 */

	while (CmpGroupString(Group, 0, "ENDBLK") == 0) {
		entity = EntityDxfParse(&block->layerlist);
		if (entity != NULL)
			if (block->entitylist == NULL)
				block->entitylist = entitylisttail = entity;
		else {
			entitylisttail->next = entity;
			entitylisttail = entity;
		}
	}

	(VOID) LayerDxfParse(&block->layerlist);
	while (OptionsDxfParse(&endblkoptions) != 0)
		free(endblkoptions);

	GetNextGroup();

	return(block);
}

/*
 * check if a block is defined in the global list
 * if true, return the pointer to the block, else NULL
 */

BLOCK	*BlockSearch(blockname)
CHAR	*blockname;
{
	BLOCK	*block;

	for (block = BlockList; block != NULL; block = block->next)
		if (strcmp(block->name, blockname) == 0)
			return(block);

	return(NULL);
}

/*
 * output a BLOCK into DEF file
 */

VOID	BlockDefOutput(block)
BLOCK	*block;
{
	ENTITY	*entity;

	for (entity = block->entitylist; entity != NULL; entity = entity->next)
		(*(EntityProcs[entity->type].defoutput)) (entity);
}

/*
 * output a BLOCK into NFF file
 */

VOID	BlockNffOutput(block)
BLOCK	*block;
{
	ENTITY	*entity;

	for (entity = block->entitylist; entity != NULL; entity = entity->next)
		(*(EntityProcs[entity->type].nffoutput)) (entity);
}

/*
 * output a BLOCK into DXF file
 */

VOID	BlockDxfOutput(block)
BLOCK	*block;
{
	ENTITY	*entity;

	for (entity = block->entitylist; entity != NULL; entity = entity->next)
		(*(EntityProcs[entity->type].dxfoutput)) (entity);
}

/*
 * output a BLOCK into RAD file
 */

VOID	BlockRadOutput(block)
BLOCK	*block;
{
	ENTITY	*entity;

	for (entity = block->entitylist; entity != NULL; entity = entity->next)
		(*(EntityProcs[entity->type].radoutput)) (entity);
}
