/***********************************************************************/
/*                                                                     */
/* Project      : GRAV                                                 */
/* Current Rel. : 3.1                                                  */
/* Creator      : Michael Knigge                                       */
/* Creation Date: 01/30/95                                             */
/* Description  : read file                                            */
/*                                                                     */
/* Functions    : grav_read_file()                                     */
/*                                                                     */
/***********************************************************************/

#include <stdio.h>
#include <fcntl.h>
#include <malloc.h>
#include <ncurses.h>
#include "standard.h"
#include "gbm.h"
#include "png.h"
#include "defines.h"
#include "readgbm.h"
#include "readpcd.h"
#include "readjpg.h"
#include "readpng.h"

char *grav_read_file(int *error_id, int flag, int index, DIRTAB dirtab[], GBM *gbm, GBMFT *gbmft, GBMRGB gbmrgb[])
{
   char *bitmap;

   switch(dirtab[index].gfx_type)
   {
   case 100: bitmap = grav_read_jpg_file(error_id,
                                         READ_ENTIRE_FILE,
                                         index,
                                         dirtab,
                                         gbm,
                                         gbmft,
                                         gbmrgb);
             break;
                   
   case 110: bitmap = grav_read_pcd_file(error_id,
                                         READ_ENTIRE_FILE,
                                         index,
                                         dirtab,
                                         gbm,
                                         gbmft,
                                         gbmrgb);
             break;

   case 120: bitmap = grav_read_png_file(error_id,
                                         READ_ENTIRE_FILE,
                                         index,
                                         dirtab,
                                         gbm,
                                         gbmft,
                                         gbmrgb);
             break;
                                               
   default:  bitmap = grav_read_gbm_file(error_id, 
                                         READ_ENTIRE_FILE, 
                                         index, 
                                         dirtab, 
                                         gbm, 
                                         gbmft, 
                                         gbmrgb);
            break;
         }
         
   return(bitmap);
}
