/* test.c - test background mode drivers
 * Copyright (C) 1992 by Scott Howard, all rights reserved
 * Permission is hereby granted to freely copy and use this code or derivations thereof
 * as long as no charge is made to anyone for its use
 * this program is a very simple monitor program which will allow the user
 * examine and change memory and registers, start/stop/reset/single step, etc.
 * Functions which are common to both CPU32 and CPU16 targets are in this file
 * test16.c and test32.c contain the code specific to the target
 */

#include	<stdio.h>

#include	<ctype.h>
#include	<string.h>
#include	<setjmp.h>
#include	"bdmcalls.h"
#include	"trgtstat.h"
#include	"bdmerror.h"
#include	"bdm-util.h"
#include	"textio.h"

#define		MaxBuffer	128

extern void DumpRegisters (void);
extern char *TargetName;
int GetCommandString (char *where, int count);
char exiting [] = "Exiting \n";
jmp_buf Saviour;

/* DriverError is a function called by background mode drivers when error detected
 * this version simply prints an error corresponding to the error code and exits
 */

static char *ErrorStrings [] =
{
NEWLINE "Unknown Error Encountered - Check Communications Speed" NEWLINE ,
NEWLINE "Power Failed on Target MCU" NEWLINE,
NEWLINE "Cable Disconnected on Target MCU" NEWLINE,
NEWLINE "No Response from Target MCU" NEWLINE,
NEWLINE "Can't Clock Target MCU while in Reset" NEWLINE ,
NEWLINE "Specified Parallel Port Not Available on this PC" NEWLINE
};

int ErrorCode, ErrorRW;
LONG ErrorAddress;

void DriverError (int ErrCode, int LastRW, LONG LastAddress)
{
	ErrorCode = ErrCode;
	ErrorRW = LastRW;
	ErrorAddress = LastAddress;
	longjmp (Saviour, 1);
}
void ReportError (void)
{
	if (ErrorCode == BDM_FAULT_BERR)
		printf (NEWLINE "Bus error %s address %lx" NEWLINE ,
			ErrorRW ? "reading" : "writing",
			ErrorAddress);
	else puts (ErrorStrings [ErrorCode]);
}

int main ()
{
	unsigned CharCount, Counter, Counter1, SR, GotOne = 0, Ports = ValidPorts ();
	int Stopped, Speed = -1, SelectedPort = 0;
	char *ptr, Buffer [MaxBuffer], QuitFlag = '\0';
	LONG LongTemp, MemDump = 0;
	BYTE ByteTemp;

/* clear screen here */
	linux_io_init();

	printf ("Test Program for %s Background Mode Drivers" NEWLINE , TargetName);
	printf ("Available LPT Ports: <");
	for (SR = 1, Counter = 1; Counter <= 16; Counter++, SR <<= 1)
	{
		if (SR & Ports)
		{
			if (GotOne) putchar (',');
			GotOne = 1;
			printf ("%d", Counter);
		}
	}
	if (!GotOne) puts ("none");
	puts ( ">" NEWLINE );
	if (!Ports)
	{
		printf ("I need at least one parallel printer port to function!" NEWLINE "%s", exiting);
		exit (1);
	}
	for (;;)
	{
		puts ("Please select Printer Port:");
		CharCount = GetCommandString (Buffer, MaxBuffer);
		if (!CharCount || !sscanf (Buffer, "%d", &SelectedPort)) return 0;
		do
		{
			puts ("Please select Clock Speed (0-100): ");
			CharCount = GetCommandString (Buffer, MaxBuffer);
			if (!CharCount || !sscanf (Buffer, "%d", &Speed)) return 0;
		}
		while (Speed < 0 || Speed > 100);
		if (setjmp (Saviour)) ReportError ();
		else if (Init (SelectedPort, Speed))
			printf ("Can't initialize port %d at speed %d" NEWLINE,
				SelectedPort, Speed);
		else break;
	}
	printf ("Port %d Initialized at Speed %d" NEWLINE , SelectedPort, Speed);
	puts ("Resetting Target MCU to enable BDM" NEWLINE );
	ResetChip ();
	while (!QuitFlag)
	{
		if (setjmp (Saviour)) ReportError ();
		puts ("Enter Command DHMRSQ('H' for Help):");
		GetCommandString (Buffer, MaxBuffer);
		for (ptr = Buffer ;isspace (*ptr); ptr++) ;
		switch (toupper (*ptr))
		{
		case	'B':
			RestartChip ();

		case	'D':
			DumpRegisters ();
			break;

		case	'H':
			printf ("Help for TEST (%s Target)" NEWLINE
				"B: Begin Program Execution from Reset" NEWLINE
				"D: Dump Target MCU Registers" NEWLINE
				"H: Print This Help Summary" NEWLINE
				"L: Load S-Record File into Target" NEWLINE
				"M: Memory Hex/ASCII Display" NEWLINE
				"R: Hardware Reset Target MCU" NEWLINE
				"S: Single Step Target MCU" NEWLINE
				"Q: Quit" NEWLINE , TargetName);
			break;

		case	'L':
			printf ("S-Record File to Load: ");
			if (!GetCommandString (Buffer, MaxBuffer)) break;
			PrintEachRecord = ".";
			do_load (0, Buffer);
			break;

		case	'M':
			printf ("Memory Dump start address in hex:");
			GetCommandString (Buffer, MaxBuffer);
			if (!sscanf (Buffer, "%lx", &LongTemp))
				LongTemp = MemDump;
			Stopped = StopChip ();
			set_fc ();
			for (Counter = 1; Counter; Counter--)
			{
				printf ("%08lX ", LongTemp);
				for (Counter1 = 16; Counter1; Counter1--)
					printf ("%02X ", (BYTE) GetByte (LongTemp++));
				LongTemp -= 16;
				putchar (' ');
				for (Counter1 = 16; Counter1; Counter1--)
				{
					ByteTemp = GetByte (LongTemp++);
					putchar (isprint (ByteTemp) ? ByteTemp : '.');
				}
				puts (NEWLINE);
			}
			MemDump = LongTemp;
			restore_fc ();
			if (Stopped) RunChip (0);
			break;

		case	'R':
			printf ("Resetting Target MCU" NEWLINE );
			ResetChip ();
			break;

		case	'S':
			printf ("Single Step" NEWLINE );
			StepChip ();
			DumpRegisters ();
			break;

		case    'Q':
			QuitFlag = 1;
		}
	}
	DeInit ();
	puts (exiting);
	return 0;
}

/* GetCommandString returns keyboard entry in buffer, to max length specified */

int GetCommandString (char *where, int count)
{
	gets (where);
	puts (NEWLINE);
	return strlen(where);
}
