#include "SDLSystem_DemonGame.h"

SDLSystem_DemonGame::SDLSystem_DemonGame(int system, CNEventScheduler *sched, CNRandom *ch_rnd):
CNSDLManager(system, sched)
{
signal_receiver = new ProcessType [sr_size = End_of_DemonGame_Signallist];
	signal_receiver[0] = 0;
	signal_receiver[Newgame] = 2;
	signal_receiver[Bump] = 3;
	signal_receiver[Score] = 1;
	signal_receiver[Lose] = 1;
	signal_receiver[Win] = 1;
	signal_receiver[Endgame] = 2;
	signal_receiver[Result] = 3;
	signal_receiver[Probe] = 3;
	signal_receiver[GameOver] = 3;

channels = new CNSDLChannel *[ch_size = End_of_DemonGame_Channellist];
for (int i = 0; i < End_of_DemonGame_Channellist; i++)
	channels[i] = new CNSDLChannel(ch_rnd);

processes = new CNSDLProcessData *[pr_size = 5];

	processes[1] = CNSDLEnvironment::pointer_to_environment_data;
	processes[4] = new CNSDLProcessData(4,1,2);
	create(new SDLProcess_Demon("Demon",this,4), 2);
	processes[3] = new CNSDLProcessData(3,1,3);
	processes[2] = new CNSDLProcessData(2,1,4);
	create(new SDLProcess_Main("Main",this,2), 4);

}

/***** Default I/O member function for CNCL classes **************************/

// Normal output
void SDLSystem_DemonGame::print(ostream &strm) const
{
	strm << "..." << endl;
}

// Debug output
void SDLSystem_DemonGame::dump(ostream &strm) const
{
	strm << "SDLSystem_DemonGame { $Revision: 1.25 $ ..."
	<< " }" << endl;
}

/***** CNCL stuff for type information ***************************************/

// Describing object for class SDLSystem_DemonGame
static CNClass SDLSystem_DemonGame_desc("SDLSystem_DemonGame", "$Revision: 1.25 $",
			SDLSystem_DemonGame::new_object);

// "Type" for type checking functions
CNClassDesc CN_SDLSYSTEM_DemonGame = &SDLSystem_DemonGame_desc;