Chapter 4 

The Sorter 
==========


   The  sorter is  not really  a  cluster since  it only  contains one 
   class. And this one class is  not in the spirit of object--oriented 
   programming  since it  does not  implement  a data  abstraction but 
   rather an algorithm. 


   The sorter  is provided  for the  efficient sorting  of arrays. The 
   class 

   SORTER [ G -> ORDER ] 

   has only one feature 

 sort (a : ARRAY [ G ] , lower, upper : INTEGER) 

   whose job is to sort the portion of the array a between the indices 
   lower and upper (inclusive). The preconditions are 

   lower <= upper a.lower <= lower and then upper <= a.upper 

   A typical use of the sorter is the following. 

   a : ARRAY [ G ] s : SORTER [ G ] l, u : INTEGER 
     ... 
     !!s s.sort (a, l, u) 
     ... 

   The algorithm used by the sorter  is bottom up heapsort (cf. meh ). 
   It sorts the array in place  and thus requires no additional space. 
   If  we  let n  :=  upper  - lower  +  1  then its  worst  case time 
   complexity is 

   O (n * lg n) 

   Bottom up heapsort is  typically about as fast  as quicksort in the 
   cases where quicksort is  good (and much better,  of course, in the 
   cases  where  quicksort  degenerates to  O  (n  2)  behavior). This 
   algorithm  can even  be faster  than quicksort  in cases  where the 
   items  in the  array are  complex  and the  comparison of  two such 
   objects costly. 






Chapter 5 

MATH 
====


   The class MATH provides some  common mathematical functions such as 
   the logarithm and the trigonometrical functions as well as a couple 
   of commonly  used constants. Classes  that need  these functions or 
   constants should inherit from MATH. 


   The constants defined in the class MATH are 

 pi : REAL 
 e : REAL 
 deg : REAL -- degrees / radian 
 phi : REAL -- the golden ratio 


   The functions defined by the class are 

 arccos (x : REAL) : REAL 
 arccosh (x : REAL) : REAL 
 arcsin (x : REAL) : REAL 
 arcsinh (x : REAL) : REAL 
 arctan (x : REAL) : REAL 
 arctanh (x : REAL) : REAL 
 ceil (x : REAL) : INTEGER 
 cos (x : REAL) : REAL 
 cosh (x : REAL) : REAL 
 exp (x : REAL) : REAL 
 abs (x : REAL) : REAL 
 floor (x : REAL) : INTEGER 
 log (x : REAL) : REAL 
 sin (x : REAL) : REAL 
 sinh (x : REAL) : REAL 
 sqrt (x : REAL) : REAL 
 tan (x : REAL) : REAL 
 tanh (x : REAL) : REAL 
 rand : INTEGER -- random number between 0 and 32767 
 srand (seed : INTEGER) -- to initialize rand 

 
   Errors which may occur during  the execution of these functions --- 
   for example  because the argument  is out  of range ---  lead to an 
   appropriate exception. 


   The exceptions that can occur here are the following 

   ARITH_DOMAIN -- argument outside domain of definition 
   ARITH_SINGULAR -- argument at a singularity of function 
   ARITH_OVERFLOW -- result causes overflow 
   ARITH_UNDERFLOW -- result causes underflow 
   ARITH_TOTAL_LOSS -- total loss of precision 
   ARITH_PARTIAL_LOSS -- partial loss of precision 



Example 

   The functions sin,  cos and tan are  only computed with sufficient 
   precision  if  their arguments  are  not  too far  from  0.  As the 
   argument  gets further  away from  0  the result  will be  first an 
   exception of type PARTIAL_LOSS and with still more extreme values 
   of type TOTAL_LOSS. 



