Eiffel/S release 1.3S (8/95)
============================

Release Notes 
=============

0.1 Eiffel/S Compiler 


0.1.1 External C Functions 

    The most significant change  to Eiffel/S in this  release has to do 
    with  the  declaration  of  external  C  functions.  Until  now the 
    declaration 

            external "C"

    meant that  the external routine  would get Current  as its first 
    argument. If one did  not want this to  happen one instead had to 
    write 

            external "CWC"

    (`CWC' = C Without Current). 

    In ETL-2, however,  we read that an  external routine that is 
    declared with 

            external "C"

    will   not   get  Current   as  its   first  argument.  Tower 
    Technologies   and  ISE  follow   this  convention.  We  have 
    therefore decided to do so  as well. This will facilitate the 
    use of libraries from different sources. 

    Unfortunately this  change means  a certain  amount of work 
    for you. Before you can use Eiffel/S 1.3 you should carry out 
    the following steps: 

 1. [ a) ] Make a backup copy of your Eiffel source texts. 

 2. [ b) ] Change all declarations of external C functions as follows: 

    Before                  After

   external "C"            external "CWC"
   external "CWC"          external "C"

    That is, you must systematically trade "C" and "CWC". We recommend 
    that you add  a suitable comment after  each altered declaration so 
    that you do not make the switch twice by mistake. 


      IMPORTANT 
      =========

    The  Eiffel/S  libraries  and  examples  that  are  delivered  with 
    Eiffel/S   release  1.3  have  already  been  adapted  to  the  new 
    convention. Do  not change them.  You must, of  course, replace the 
    old library classes and examples with the new versions. 

      Switch "C"  and "CWC"  systematically. If  you overlook  even one 
    such declaration  the corresponding C  routine will  be called with 
    incorrect parameters and the program will not work. 
      When writing new external C routines  be sure to remember the new 
    convention: 

   external "C"     = call without `Current'
   external "CWC"   = call with `Current' (C With Current).


   0.1.2 A New Compiler Option 

   The Eiffel/S compiler recognizes a new option: 

   -F  (for : "Final version")

     This  causes a  complete new  compilation  of the  program. The 
     resulting executable  is even  better optimized  for speed than 
     with the option -O since the compiler generates inline code for 
     certain   routines.  Compilation  with   the  option  -F  takes 
     noticeably longer than with -O. 

       Please be sure to delete the ".op" and ".pdb" directories for 
     your program  after compiling with  the option -F  (you can use 
     eclean to do  this). It is  not possible to  do a recompilation 
     with  option -O  or without  option  after compilation  with -F 
     unless you delete these directories. 

0.1.3 Validity Rule VAPE 
========================

     Eiffel/S 1.3  now correctly checks  the VAPE  rule (cf. ETL-2). 
     This  could mean  that the  compiler now  finds errors  in your 
     classes that  hitherto remained  unnoticed. This  probably will 
     not happen  often and  VAPE errors  are easy  to repair. Please 
     reread the corresponding sections in ETL-2. 

0.1.4 Cryptified Files 
======================

     The Eiffel/S compiler can  now read specially cryptified source 
     texts. If you produce library classes  to be used by others and 
     are  interested  in  this  possibility  please  contact Frieder 
     Monninger at SiG (fm@eiffel.de) 

0.1.5 eansi.h 
=============+

     The compiler now produces a file with ANSI C prototypes for all 
     external routines  that are called  by your program  as well as 
     for  all routines  in interface  classes.  This file  is called 
     eansi.h  and will  be produced  in the  directory in  which the 
     compiler was called. 

0.2 Libraries 
=============

     The cluster BASIC has two  classes not described in the library 
     manual. The first  of these was  implemented already in Release 
     1.21:    OBJECT_STRUCTURE,   a   class   supporting   object 
     introspection. Using an object of  this type the programmer can 
     obtain information  about any  object, information  that may be 
     useful in some applications: the name of the class of which the 
     object  is an  instance,  the number,  names  and types  of its 
     attributes, etc. 

       A typical use of the class OBJECT_STRUCTURE might look like 
     this: 

some_routine (arg : SOME_TYPE) is

    local
        io : BASIC_IO
        os : OBJECT_STRUCTURE

    do
        debug ( "ARG_TYPE" )
            !!io
            !!os
            io.put_string ("some_routine : ")
            io.put_string ("argument of type ")
            io.put_string (os.classname (arg))
            io.put_newline
        end

        ...
    end

          A reader needing  such internal information  about objects is 
          encouraged to look at the class OBJECT_STRUCTURE. 

            The  other  new  class  in  the  cluster  BASIC  is  PART_ 
          COMPARABLE that implements  sets with a  partial order. It is 
          now a parent  of the class  COMPARABLE. The class COMPARABLE 
          has acquired two new features min and max. 

            The class GENERAL has a  new feature null_pointer (a once 
          function). This feature can be used to test whether a pointer 
          (class POINTER)  is a  null pointer  (the default  value for 
          this type). It  can also be  used to set  a pointer entity to 
          the default value: 

    ptr : POINTER

    ... 

    if ptr = null_pointer then ...

    ptr := null_pointer

          Please note that entities of type POINTER are automatically 
          initialized to be null pointers. 
            In  connection  with  the  NICE  interoperability program 
          Tower Technologies and SiG  Computer have reached agreement 
          on some of the basic classes. These are: 

     PART_COMPARABLE, COMPARABLE, HASHABLE, NUMERIC, POINTER

          The new  classes are  already incorporated  into Eiffel/S 1.3. 
          We are still working on  a unification of the remaining 
          basic classes. 

0.3 The Runtime System 


      The routines 

      deep_equal, deep_clone

      from the class GENERAL are now implemented in Eiffel/S. 
      Please note  that the  algorithm described  in ETL-2 is 
      incomplete and  incorrect. It  is incomplete,  since it 
      does not deal with the type POINTER. Eiffel/S does not 
      compare attributes  of type POINTER.  It is incorrect, 
      since the algorithm is not  suited to prove or disprove 
      the isomorphism of two  object graphs. If, for example, 
      two circular linked  lists of lengths n  and m in which 
      all items are the  same are compared using deep_equal 
      as  described in  ETL-2 the  algorithm will  always say 
      they are deep  equal -- independent of  the values of n 
      and m . 

        Neither  the semantics  of  deep_equal nor  that of 
      deep_clone can  be influenced by  the programmer. The 
      two   routines  are  implemented  inside  the  Eiffel/S 
      runtime  system and  do not  use is_equal,  clone or 
      copy. 

      0.4 ERCC 


      In the ".rcl" file  for your program you  can now add a 
      line of the form 

      sys_val_chk : on

         or

      sys_val_chk : off

      This turns system validity checks on or off globally. 
      The default value  is `off'. This  option only has an 
      effect  in debug  mode  and (unfortunately)  does not 
      find all possible system validity errors. 

      0.5 PDL Files 


      In ".pdl" files you can now include statements of the 
      form 

      include path

      This means the following: this line in the PDL-file 
      will be replaced by the entire contents of the file 
      designated    by  path   before  the   PDL-file  is 
      interpreted. This instruction must  stand in a line 
      by itself and the path must be quoted. 

        This  mechanism is  not recursive.  A file  to be 
      included with include should not contain an include 
      instruction. 

