-----------------------------------------------------------
--                   Eiffel/S libraries                  --
-----------------------------------------------------------
--               Copyright (C) 1991 - 1993               --
--                           by                          --
--                   SiG Computer GmbH                   --
--                  All rights reserved                  --
-----------------------------------------------------------
-- Release : 1.3 - October 1993                          --
-----------------------------------------------------------
-- Authors : Lambert Strether & Michael Schweitzer       --
-----------------------------------------------------------
  
class   ENVIRONMENT 
                        -- Command line arguments and 
                        -- environment variables

-----------------------------------------------------------
feature {ANY}
-----------------------------------------------------------

    arg_item (index : INTEGER) : STRING is
                        -- Return `command line' argument no. `index'
        require
            valid_index : 1 <= index and then index <= arg_count

        external "C" -- changed by x_c_cwc
        alias    "RTC5E_arg_item"
        end
-----------------------------------------------------------

    arg_count : INTEGER is
                        -- No. of `command line' arguments,
                        -- excluding the program name!
        external "C" -- changed by x_c_cwc
        alias    "RTC5_arg_count"
        end
-----------------------------------------------------------

    program_name : STRING is
                        -- Name with which program was started
        external "C" -- changed by x_c_cwc
        alias    "RTC5E_program_name"
        end
-----------------------------------------------------------

    env_item (environment_variable : STRING) : STRING is

        require
            variable_not_void : environment_variable /= Void

        do
            Result := rt_env_item (environment_variable.to_external)
        end
-----------------------------------------------------------

    env_put (environment_variable, text : STRING) is
                    -- Set `environment_variable' to `text'
        require
            variable_not_void : environment_variable /= Void
            text_not_void     : text /= Void

        do
            rt_env_put (environment_variable.to_external, text.to_external)
        end
-----------------------------------------------------------
feature {NONE}
-----------------------------------------------------------

    rt_env_item (environment_variable : POINTER) : STRING is

        external "C" -- changed by x_c_cwc
        alias    "RTC5E_env_item"
        end
-----------------------------------------------------------

    rt_env_put (environment_variable, text : POINTER) is
                    -- Set `environment_variable' to `text'
        external "C" -- changed by x_c_cwc
        alias    "RTC5E_env_put"
        end
-----------------------------------------------------------

end -- class ENVIRONMENT 

