-----------------------------------------------------------
--                   Eiffel/S libraries                  --
-----------------------------------------------------------
--               Copyright (C) 1991 - 1993               --
--                           by                          --
--                   SiG Computer GmbH                   --
--                  All rights reserved                  --
-----------------------------------------------------------
-- Release : 1.3 - October 1993                          --
-----------------------------------------------------------
-- Authors : Lambert Strether & Michael Schweitzer       --
-----------------------------------------------------------
  
class   ES3_SPEC [G]
                            -- For EIFFEL/S internal use only!
                            -- You cannot inherit from this class.
                            -- Don't modify this class!!!
inherit
    ANY
        redefine
            is_equal, copy
    end
-----------------------------------------------------------
creation {ANY}
    make
-----------------------------------------------------------
feature {ANY}
-----------------------------------------------------------

    count : INTEGER

-----------------------------------------------------------

    make (size : INTEGER) is
                        -- Make room for `size' elements of type `G'.
        require
            non_negative_size : size >= 0
        do
            resize (size)
            count := size
        end
-----------------------------------------------------------

    clear (from_index, to_index : INTEGER) is
                        -- Reset all elements to default values.
        require
            valid_range   : from_index <= to_index
            inside_bounds : 0 <= from_index and then to_index < count
        external "CWC" -- changed by x_c_cwc
        alias    "RTC0_clear"
        end
-----------------------------------------------------------

    resize (new_size : INTEGER) is
                        -- Make room for `new_size' elements of type `G'.
                        -- Keep all elements previously stored, if possible.
        require
            non_negative_size : new_size >= 0

        external "CWC" -- changed by x_c_cwc
        alias    "RTC0_resize"
        end
-----------------------------------------------------------

    resize_and_copy (new_size : INTEGER, shift : INTEGER) is
                        -- Make room for `new_size' elements of type `G'.
                        -- Keep all elements previously stored, if possible.
                        -- Copy old to new with index shift `shift'.
        require
            non_negative_size : new_size >= 0

        external "CWC" -- changed by x_c_cwc
        alias    "RTC0_resize_and_copy"
        end
-----------------------------------------------------------

    put (element : G, index : INTEGER) is
                        -- Put `element' at position `index'.
        require
            inside_bounds : 0 <= index and then index < count
        do
            exchg := element
            rt_put (index)
        ensure
            in_place : item (index) = element
        end
-----------------------------------------------------------

    move (start_index, end_index, distance : INTEGER) is
                        -- Move range towards higher indices, if
                        -- distance is positive, towards lower indices
                        -- otherwise.
        require
            valid_interval : start_index <= end_index
            inside_bounds  : 0 <= start_index and then end_index < count
                                        and then
                             0 <= start_index + distance and then
                                    end_index + distance < count
        external "CWC" -- changed by x_c_cwc
        alias    "RTC0_move"
        end
-----------------------------------------------------------

    copy (other : ES3_SPEC [G]) is
                        -- Copy `other' onto Current. Areas occupied
                        -- by Current and `other' will be different but
                        -- will contain the same elements.
        external "CWC" -- changed by x_c_cwc
        alias    "RTC0_copy"
        end
-----------------------------------------------------------

    at (lower : INTEGER) : POINTER is
                        -- Don't care.
        external "CWC" -- changed by x_c_cwc
        alias    "RTC0_at"
        end
-----------------------------------------------------------

    all_cleared : BOOLEAN is
                        -- Are all elements set to their default values?
        external "CWC" -- changed by x_c_cwc
        alias    "RTC0_all_cleared"
        end
-----------------------------------------------------------

    item (index : INTEGER) : G is 
                        -- Return element at position `index'.
        require
            inside_bounds : 0 <= index and then index < count
        do
            rt_item (index)
            Result := exchg
        end
-----------------------------------------------------------

    is_equal (other : ES3_SPEC [G]) : BOOLEAN is
                        -- Is Current elementwise equal to `other'?
        external "CWC" -- changed by x_c_cwc
        alias    "RTC0_is_equal"
        end
-----------------------------------------------------------
feature {STRING}
-----------------------------------------------------------

    fill_with (ch : CHARACTER, how_many : INTEGER) is

        external "CWC" -- changed by x_c_cwc
        alias    "RTC0_fill_with"
        end
-----------------------------------------------------------

    sv_lit is

        external "CWC" -- changed by x_c_cwc
        alias    "RTC0_sv_lit"
        end
-----------------------------------------------------------

    puts (p : POINTER, index : INTEGER) is

        external "CWC" -- changed by x_c_cwc
        alias    "RTC0_puts"
        end
-----------------------------------------------------------

    gets (from_idx, to_idx : INTEGER) : POINTER is

        external "CWC" -- changed by x_c_cwc
        alias    "RTC0_gets"
        end
-----------------------------------------------------------
feature {NONE, STRING, ARRAY, BIT_N}
-----------------------------------------------------------

    exchg : G
    lit   : BOOLEAN
    store : POINTER

-----------------------------------------------------------

    rt_put (index : INTEGER) is

        external "CWC" -- changed by x_c_cwc
        alias    "RTC0_put"
        end
-----------------------------------------------------------

    rt_item (index : INTEGER) is

        external "CWC" -- changed by x_c_cwc
        alias    "RTC0_item"
        end
-----------------------------------------------------------

end -- class ES3_SPEC [G]

