-----------------------------------------------------------
--                   Eiffel/S libraries                  --
-----------------------------------------------------------
--               Copyright (C) 1991 - 1993               --
--                           by                          --
--                   SiG Computer GmbH                   --
--                  All rights reserved                  --
-----------------------------------------------------------
-- Release : 1.3 - October 1993                          --
-----------------------------------------------------------
-- Authors : Lambert Strether & Michael Schweitzer       --
-----------------------------------------------------------
  
class   EXCEPTION 
                        -- Exception handling

-----------------------------------------------------------
feature {ANY}
-----------------------------------------------------------

    SIG_NONE         : INTEGER is 0      -- No signal occured
    SIG_HANGUP       : INTEGER is 10036
    SIG_INTERRUPT    : INTEGER is 10037
    SIG_QUIT         : INTEGER is 10038
    SIG_FLOAT        : INTEGER is 10039
    SIG_SYSTEM       : INTEGER is 10040
    SIG_PIPE         : INTEGER is 10041
    SIG_ALARM        : INTEGER is 10042
    SIG_OTHER        : INTEGER is 10043
    SIG_BUS          : INTEGER is 10044
    SIG_SEGMENTATION : INTEGER is 10045
    SYSTEM_VALIDITY  : INTEGER is 10046

-----------------------------------------------------------

    catch_signal (sigcode : INTEGER) is
                        -- Catch signal `sigcode' - do not
                        -- raise an exception.
        external "C" -- changed by x_c_cwc
        alias    "RTC15_catch"
        end
-----------------------------------------------------------

    raise_on_signal (sigcode : INTEGER) is
                        -- Raise exception, if signal `sigcode'
                        -- occurs
        external "C" -- changed by x_c_cwc
        alias    "RTC15_raise"
        end
-----------------------------------------------------------

    last_signal : INTEGER is
                        -- Code of most recent signal
        external "C" -- changed by x_c_cwc
        alias    "RTC15_last_signal"
        end
-----------------------------------------------------------

    reset_signal : INTEGER is
                        -- Reset `last_signal' to SIG_NONE.
        external "C" -- changed by x_c_cwc
        alias    "RTC15_reset"
        end
-----------------------------------------------------------

    raise (routine_name : STRING, message : STRING, 
                                    code : INTEGER, xobject : ANY) is
                            -- Raise an exception in routine
                            -- `routine_name' with 
                            -- text `message', exception code
                            -- `code' and associated object 
                            -- `xobject'. 
        local
            rp, mp : POINTER
        do
            if routine_name /= Void then
                rp := routine_name.to_external
            end

            if message /= Void then
                mp := message.to_external
            end

            rt_raise (rp, mp, code, xobject)
        end
-----------------------------------------------------------
            
    last_etext : STRING is
                            -- Text of last exception
                            -- May be Void
        external "C" -- changed by x_c_cwc
        alias    "RTC4_last_etext"
        end
-----------------------------------------------------------

    last_ecode : INTEGER is
                            -- Code of last exception
        external "C" -- changed by x_c_cwc
        alias    "RTC4_last_ecode"
        end
-----------------------------------------------------------

    last_eobj  : ANY is
                            -- Object associated with last exception
                            -- May be Void
        external "C" -- changed by x_c_cwc
        alias    "RTC4_last_eobj"
        end
-----------------------------------------------------------

    last_ecall  : STRING is
                            -- Routine in which exception occured
        external "C" -- changed by x_c_cwc
        alias    "RTC4_last_ecall"
        end
-----------------------------------------------------------
-- Predefined exception codes
-- User defined codes should use the range 0 ... 9999
-----------------------------------------------------------

        INTERRUPT               : INTEGER is 10000
        PRECONDITION            : INTEGER is 10001
        POSTCONDITION           : INTEGER is 10002
        CLASS_INVARIANT         : INTEGER is 10003
        LOOP_VARIANT            : INTEGER is 10004
        LOOP_INVARIANT          : INTEGER is 10005
        CHECK_INSTRUCTION       : INTEGER is 10006
        INVALID_INSPECT_VALUE   : INTEGER is 10007
        NO_MORE_MEMORY          : INTEGER is 10008
        VOID_CALL_TARGET        : INTEGER is 10009
        ARITH_DOMAIN            : INTEGER is 10010
        ARITH_SINGULAR          : INTEGER is 10011
        ARITH_OVERFLOW          : INTEGER is 10012
        ARITH_UNDERFLOW         : INTEGER is 10013
        ARITH_TOTAL_LOSS        : INTEGER is 10014
        ARITH_PARTIAL_LOSS      : INTEGER is 10015
        ARITH_ERROR             : INTEGER is 10016
        SIGNAL                  : INTEGER is 10017
        ILLEGAL_FREE            : INTEGER is 10018
        INTERNAL                : INTEGER is 10019
        NO_PERMISSION           : INTEGER is 10020
        INVALID_PATH            : INTEGER is 10021
        INTERRUPTED             : INTEGER is 10022
        PHYSICAL_IO_ERROR       : INTEGER is 10023
        DRIVE_NOT_READY         : INTEGER is 10024
        BAD_FILE_DESCRIPTOR     : INTEGER is 10025
        NOT_A_DIRECTORY         : INTEGER is 10026
        IS_A_DIRECTORY          : INTEGER is 10027
        FILE_TOO_LARGE          : INTEGER is 10028
        NO_MORE_SPACE           : INTEGER is 10029
        OS_ERROR                : INTEGER is 10030
        ILLEGAL_HOOK            : INTEGER is 10031
        VOID_ASSIGNED_TO_EXP    : INTEGER is 10032
        TYPE_MISMATCH           : INTEGER is 10033
        NOT_IN_UNIVERSE         : INTEGER is 10034

-----------------------------------------------------------
feature {NONE}
-----------------------------------------------------------

    rt_raise (routine_name : POINTER, message : POINTER, 
                                    code : INTEGER, xobject : ANY) is
                            -- Raise an exception in routine
                            -- `routine_name' with 
                            -- text `message', exception code
                            -- `code' and associated object 
                            -- `xobject'. 
        external "C" -- changed by x_c_cwc
        alias    "RTC4_raise"
        end
-----------------------------------------------------------

end -- class EXCEPTION 

