MODULE FormsVBTPixmapsBundle;
(* Generated by m3bundle; see its manpage. *)

IMPORT Bundle, BundleRep, Text;
IMPORT Thread, Wr, TextWr;

TYPE T = Bundle.T OBJECT OVERRIDES get := LookUp END;

VAR bundle: T := NIL;

PROCEDURE Get(): Bundle.T =
  BEGIN
    IF (bundle = NIL) THEN bundle := NEW (T) END;
    RETURN bundle;
  END Get;

PROCEDURE LookUp (<*UNUSED*> self: T;  element: TEXT): TEXT = 
  BEGIN
    FOR i := 0 TO LAST (Names)-1 DO
      IF Text.Equal (Names[i], element) THEN
        IF Elements[i] = NIL THEN Elements[i] := GetElt (i) END;
        RETURN Elements[i];
      END;
    END;
    RETURN NIL;
  END LookUp;

CONST Names = ARRAY [0..7] OF TEXT {
  "triangleSE.pbm",
  "close.pbm",
  "arrowUp.pbm",
  "grow.pbm",
  "Digital.pbm",
  "arrowDown.pbm",
  "blank.pbm",
  NIL
};

VAR Elements := ARRAY [0..7] OF TEXT {
  E0,
  E1,
  E2,
  E3,
  NIL (* E4 .. E4_15 *),
  E5,
  E6,
  NIL
};

PROCEDURE GetElt (n: INTEGER): TEXT =
  <*FATAL Thread.Alerted, Wr.Failure *>
  VAR wr := TextWr.New ();
  BEGIN
    CASE n OF
    | 4 =>
        Wr.PutText (wr, E4);
        Wr.PutText (wr, E4_0);
        Wr.PutText (wr, E4_1);
        Wr.PutText (wr, E4_2);
        Wr.PutText (wr, E4_3);
        Wr.PutText (wr, E4_4);
        Wr.PutText (wr, E4_5);
        Wr.PutText (wr, E4_6);
        Wr.PutText (wr, E4_7);
        Wr.PutText (wr, E4_8);
        Wr.PutText (wr, E4_9);
        Wr.PutText (wr, E4_10);
        Wr.PutText (wr, E4_11);
        Wr.PutText (wr, E4_12);
        Wr.PutText (wr, E4_13);
        Wr.PutText (wr, E4_14);
        Wr.PutText (wr, E4_15);
    ELSE (*skip*)
    END;
    RETURN TextWr.ToText (wr);
  END GetElt;

CONST E0 = 
   "P4\n# created by \'xv /tmp_mnt/bamboozle/r/dlusers6/bharat/m3/Dialog/sr"
 & "c/ui/spot3.pbm\'\n15 14\n\000\001\000\011\000\031\0009\000y\000\371\001"
 & "\331\003\231\007\031\016\031\034\031?\371\177\371\000\001";

CONST E1 = 
   "P4\n# created by \'xv <nil>\'\n14 17\n\000\003\000\003\377\377\200\007\200"
 & "\007\207\307\217\347\237\367\237\367\237\367\237\367\237\367\217\347\207"
 & "\307\200\007\377\377\000\003";

CONST E2 = 
   "P4\n# created by \'xv <nil>\'\n24 17\n\000\000\000\000\000\000\000\000\000"
 & "\000\020\000\000|\000\001\377\000\007\377\300\037\377\360\000|\000\000|"
 & "\000\000|\000\000|\000\000|\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000";

CONST E3 = 
   "P4\n# created by \'xv <nil>\'\n18 18\n\000\000?\000\000??\377?!\021?!\021"
 & "?!\021?!\021??\021? \021? \021? \021??\361? \001? \001? \001??\377?\000"
 & "\000?\000\000?";

CONST E4 = 
   "P1\n# created by \'xv /tmp_mnt/bamboozle/r/dlusers6/bharat/foo.ppm\'\n1"
 & "95 85\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 ";

CONST E4_0 = 
   "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 ";

CONST E4_1 = 
   "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 "
 & "1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 \n0 1"
 & " 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 \n1 "
 & "1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n0"
 & " 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 \n"
 & "1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 0 0 0 0 1 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 \n"
 & "1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n"
 & "1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 \n"
 & "1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 \n"
 & "1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 \n"
 & "0 0 1 0 0 0 1 1 0 0 0 1 1 0 0 0 0 ";

CONST E4_2 = 
   "0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0"
 & " 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1"
 & " 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 1"
 & " 1 1 0 0 0 0 0 1 0 0 0 1 0 1 0 1 0 1 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 1 "
 & "1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n0 0 0 1 1 1 1 1 1 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 "
 & "0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 0 0 0 1 1 1 1 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 "
 & "1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 0 0 0 0 0 1 0 0 0 1"
 & " 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 \n1 1 1 1 1 1 1 1 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 0 0 0"
 & " 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 \n0 1 1 1 1 1 1 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1"
 & " 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 \n0 0 1 1 1 1 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 1 0 0 0 1 0 0 0 \n0 0 1 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 0 0 0 "
 & "1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 \n1 1 1 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 0 "
 & "0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 \n1 1 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 "
 & "1 0 0 0 0 0 1 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 \n1 1 1 1 1 "
 & "1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 0 0"
 & " 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 \n1 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1"
 & " 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 1 0 0 \n0 1 0 "
 & "0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 ";

CONST E4_3 = 
   "1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 0 0 \n0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 "
 & "1 0 0 0 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 1 1 1 \n0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 "
 & "1 1 1 0 0 0 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0"
 & " 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1"
 & " 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 0 0 "
 & "0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 \n1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 \n1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 "
 & "0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 \n1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 "
 & "1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 \n0 0 0 1 1 1 1 1 1 1 1 0 0 0 "
 & "0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 0"
 & " 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 \n1 0 0 0 1 1 1 1 1 1 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1"
 & " 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 \n1 1 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1"
 & " 1 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 \n1 1 1 1 1 1 1 1 0 0 0 "
 & "1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 \n0 1 1 1 1 1 1 1 1 0 0"
 & " 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 0 \n0 1 1 1 1 1 1 1 1 1 "
 & "0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 \n0 0 1 1 1 1 1 1 1 1"
 & " 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 ";

CONST E4_4 = 
   "1 1 1 1 0 0 \n0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 0"
 & " 0 0 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 "
 & "1 1 0 0 1 1 1 \n1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1"
 & " 1 1 0 0 0 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 "
 & "1 1 1 0 0 0 0 1 \n1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 \n0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 0 "
 & "0 0 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 \n1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 "
 & "1 0 0 0 1 1 1 1 1 1 \n1 1 0 0 0 0 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 "
 & "1 1 1 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1"
 & " 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 1 0 0 \n0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1"
 & " 0 0 0 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 "
 & "0 0 0 0 1 1 1 1 1 1 1 1 1 \n0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1"
 & " 1 1 0 0 0 1 1 1 1 1 1 1 1 \n0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1"
 & " 1 1 0 0 0 0 1 1 1 0 0 0 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 "
 & "0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 \n1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 "
 & "1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1"
 & " 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 \n0 0 0 0 0 0 1 1 0 0 0 0 1 1 1 0 0 0"
 & " 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 \n1 1 1 0 0 0 1 1 1 1 1 1 1 0 0 0 0 "
 & "0 0 1 1 0 0 0 0 1 1 1 0 0 0 1 1 1 1 \n1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0"
 & " 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 \n1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 "
 & "0 0 0 0 0 0 1 1 1 1 1 1 1 0 0 0 1 1 1 \n1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1"
 & " 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 "
 & "1 1 1 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 1 ";

CONST E4_5 = 
   "\n0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 0 0 0"
 & " \n0 0 0 0 0 1 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 "
 & "1 \n1 0 0 0 1 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 0"
 & " 0 \n0 0 0 0 0 0 0 0 0 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 "
 & "1 1 \n1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 1 1 \n1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 "
 & "0 0 0 \n1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1"
 & " 1 0 0 \n0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 0 "
 & "0 0 0 0 \n0 0 0 1 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 1"
 & " 1 1 1 0 \n0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 \n0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 "
 & "0 0 1 1 1 1 \n1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1"
 & " 0 0 0 0 1 1 \n1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 1 1 1 "
 & "1 1 0 0 0 1 1 \n1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 0 0 0 1 1 1 1 1 1"
 & " 1 1 0 0 0 0 1 \n1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 \n0 0 0 1 1 1 1 0 0 0 0 0 1 1 1 0 0 0 0 0 0 0 1 1 1 0 0"
 & " 0 1 1 1 1 1 1 1 \n1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 0 0 0 0 "
 & "1 1 0 0 0 0 0 0 0 \n1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1"
 & " 0 0 0 1 1 1 1 1 1 \n1 1 0 0 0 0 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 "
 & "0 1 1 1 1 1 1 0 0 0 \n0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1"
 & " 1 1 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 "
 & "1 1 1 0 0 0 0 1 1 1 1 \n1 1 0 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0"
 & " 0 1 1 1 1 1 1 1 1 0 0 \n0 1 1 1 1 0 0 0 0 1 1 1 1 1 1 0 0 0 0 0 1 1 1 "
 & "0 0 0 1 1 1 1 1 1 1 1 0 \n0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0"
 & " 0 0 0 1 1 1 1 1 1 1 1 1 \n0 0 0 1 1 1 1 1 0 0 1 1 1 1 1 1 1 0 0 0 0 1 "
 & "1 1 0 0 0 1 1 1 1 1 1 1 1 \n0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 1 1 1 0 0 0 0 0 1 1 1 1 1 "
 & "1 0 0 0 0 0 1 1 1 0 0 0 1 1 \n1 1 1 1 1 1";

CONST E4_6 = 
   " 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 0 0 1 1 1 1 1 1 \n0 0 0 0 0 "
 & "1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 \n1 1 1 1 1"
 & " 1 1 0 0 0 0 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 0 0 "
 & "0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 \n0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 0 0 0 0 \n1 1 1 "
 & "1 1 1 1 1 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 \n1 1 1"
 & " 0 0 0 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 0 0 0 1 1 1 1 \n1 1 "
 & "1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 \n1 1"
 & " 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 1 1 1 0 0 0 1 1 1 \n1 "
 & "1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 \n"
 & "0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 1 1 \n"
 & "1 1 1 1 1 1 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 \n"
 & "1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 \n"
 & "1 1 1 0 0 0 0 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 \n"
 & "1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 \n"
 & "1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 \n"
 & "1 1 1 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 0 0 \n"
 & "0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 \n"
 & "0 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 0 \n"
 & "0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 \n"
 & "0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 0 \n"
 & "0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 \n"
 & "1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 1 0 0 0 1 1 \n"
 & "1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 \n"
 & "1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 \n"
 & "1 0 0 0 0 1 1 1 1 1 1 1";

CONST E4_7 = 
   " 1 0 0 0 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 \n1 1 1 0 0 0 1 1 1 1 1 "
 & "1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 \n1 1 0 0 0 0 1 1 1 1 1"
 & " 1 1 1 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 1 0 0 0 \n0 1 1 1 0 0 0 1 1 1 "
 & "1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 0 0 0 0 1 1 1 1 1 \n1 1 1 0 0 0 0 1 1 "
 & "1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 \n0 1 1 1 0 0 0 0 1"
 & " 1 1 1 1 1 1 1 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 \n0 0 0 1 1 1 1 1 "
 & "1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 1 \n0 0 0 1 1 1 0 0"
 & " 0 0 0 1 1 1 1 1 1 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 \n0 0 0 0 1 1 1 "
 & "1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0"
 & " 0 1 1 1 0 0 0 0 0 1 1 1 1 1 1 0 0 0 0 0 1 1 1 0 0 0 1 1 \n1 1 1 1 1 1 "
 & "0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 1 1 1 1 \n0 0 0 0 0 1"
 & " 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 \n1 1 1 1 1 "
 & "1 1 0 0 0 0 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 1 1 1 1 1 \n1 1 0 0 0"
 & " 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 \n0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 0 0 0 \n0 1 1 1"
 & " 1 1 1 0 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 \n1 1 1 "
 & "0 0 0 1 1 1 1 0 0 0 0 1 1 1 1 1 1 0 0 0 0 0 1 1 1 0 0 0 1 1 1 1 \n1 1 1"
 & " 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 \n1 1 "
 & "1 1 1 0 0 0 1 1 1 0 0 0 0 1 1 1 1 1 1 1 0 0 0 0 1 1 1 0 0 0 1 1 1 \n1 1"
 & " 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 1 1 1 1 0 0 0 0 0 0 1 1 1 \n0"
 & " 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 0 0 0 \n"
 & "1 1 1 1 0 0 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 \n"
 & "1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 0 0 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 \n"
 & "1 1 1 1 1 1 0 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 \n"
 & "1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 \n"
 & "1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 \n"
 & "1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 0";

CONST E4_8 = 
   " 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 0 0 \n0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 "
 & "1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 \n0 0 0 0 0 1 1 1 1 1 0 0 0 1 1 1 0"
 & " 0 0 0 0 1 1 0 0 0 0 0 0 0 0 1 1 1 0 \n0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 "
 & "1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 "
 & "1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 \n1 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 \n1 1 1 1 1 1 0 0 0 1 1 1 1 1 "
 & "1 1 1 0 0 0 0 0 0 0 0 1 1 1 1 1 0 0 0 1 1 \n1 1 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 \n1 1 1 1 1 1 1 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 1 1 1 1 1 1 0 0 0 0"
 & " 0 0 0 0 1 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 \n1 0 0 0 0 1 1 1 1 1 1 1 "
 & "1 0 0 0 1 1 1 1 1 1 0 0 0 0 0 0 0 0 1 0 0 0 0 \n1 1 1 0 0 0 1 1 1 1 1 1"
 & " 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 \n1 1 1 0 0 0 0 0 0 0 1 "
 & "1 1 1 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 1 0 0 0 \n0 1 1 1 0 0 0 1 1 1 1"
 & " 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 0 0 0 0 0 \n0 1 1 0 0 0 0 1 1 1"
 & " 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 \n0 1 1 1 1 1 1 1 0 "
 & "0 0 0 0 0 1 1 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 \n0 0 0 1 1 1 1 1 1"
 & " 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 \n0 0 0 1 1 1 1 1 "
 & "1 0 0 0 0 1 1 1 1 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 \n0 0 0 0 1 1 1 1"
 & " 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 "
 & "0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 \n1 1 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 0 0 0 0 1 "
 & "1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 \n1 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 "
 & "1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 \n0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 \n1 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 0"
 & " 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0";

CONST E4_9 = 
   " 0 1 1 1 0 0 0 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1"
 & " 1 1 1 1 1 1 0 0 0 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 1 1 1 \n0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 "
 & "1 1 0 0 0 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 0 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 "
 & "1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1"
 & " 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 0 0 "
 & "1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 0 0 \n0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1"
 & " 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 \n0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1"
 & " 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 0 \n0 0 0 0 0 1 1 1 1 0 0 0 0 0 1 "
 & "1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 0 0 0 1 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 "
 & "1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 1 1 1 1 1 1 1 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1"
 & " 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 \n1 1 1 0 0 0 1 1 1 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1"
 & " 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 0 0 0 1 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 "
 & "0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 \n0 1 1 1 1 1 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 1 1 1 1 1 0 0 0 1 1 1 1";

CONST E4_10 = 
   " 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 "
 & "1 1 1 1 1 1 \n0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1"
 & " 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1"
 & " 1 1 0 0 0 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 "
 & "0 0 0 0 0 0 0 0 \n0 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1"
 & " 1 1 1 1 0 0 0 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1"
 & " 1 1 1 1 1 1 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 \n1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 "
 & "1 1 1 1 0 0 0 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 "
 & "1 1 1 1 1 1 0 0 0 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 1 1 1 1 \n0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1"
 & " 1 0 0 0 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1"
 & " 1 1 1 1 0 0 0 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 "
 & "1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 \n0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 "
 & "1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 \n0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 "
 & "1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1"
 & " 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n";

CONST E4_11 = 
   "1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 \n"
 & "1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 \n"
 & "1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 ";

CONST E4_12 = 
   "0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 \n1 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 \n0 0 0 0 1"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 0 0 0 0 0 \n0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 "
 & "1 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0"
 & " 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 \n1 1"
 & " 1 0 0 0 1 1 1 0 0 0 0 1 1 1 0 0 0 1 0 1 1 0 0 1 1 0 0 0 0 1 1 1 0 \n0 "
 & "0 0 0 0 0 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 0 0 0 0 1 1 1 0 0 0 0 1 1 1 \n0"
 & " 0 0 0 1 1 1 0 0 0 1 0 1 1 1 0 0 1 1 1 0 0 0 1 0 1 1 0 0 0 0 0 0 0 0 \n"
 & "0 1 0 0 0 0 0 0 0 0 1 1 1 0 0 0 1 0 1 1 0 0 0 1 1 1 0 0 0 0 1 1 1 0 0 \n"
 & "0 1 0 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 1 0 0 0 0 0 0 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 0 1 0 0 0 0 1 0 0 \n"
 & "0 1 0 0 1 1 0 0 1 1 0 0 1 0 0 1 0 0 0 1 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 \n"
 & "0 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 1 1 0 0 0 \n"
 & "0 1 0 0 0 1 0 0 1 1 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 1 0 0 0 1 0 \n"
 & "0 1 1 0 0 1 0 0 0 1 0 0 0 0 1 0 0 0 1 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 0 0 0 1 0 0 \n"
 & "0 1 0 0 1 0 0 0 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 0 1 0 0 \n"
 & "1 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 0 0 0 1 0 0 0 1 0 0 1 0 0 0 0 0 \n"
 & "0 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 0 0 0 0 0 1 0 0 0 0 0 0 1 0 0 0 1 0 0 \n"
 & "0 0 0 0 0 0 1 0 0 0 0 0 0 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 0 1 0 0 0 0 1 \n"
 & "0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 1 0 0 0 1 0 0 0 1 1 1 0 0 0 0 1 0 0 \n"
 & "0 0 1 1 1 1 1 0 0 1 0 0 0 1 0 0 0 1 0 0 0 1 1 1 0 0 0 0 0 0 0 0 0 0 1 \n"
 & "0 1 0 0 0 0 0 1 1 1 1 1 0 0 0 1 1 1 0 0 0 1 1 1 1 1 0 0 1 0 0 0 1 0 0 \n"
 & "1 0 0 0 0 0 1 0 0 0 0 0 ";

CONST E4_13 = 
   "0 1 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 1 \n1 1 1 1 0 0 1 0 0 0 1 0"
 & " 0 0 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 \n0 0 1 0 0 0 1 0 0 0 0"
 & " 0 0 1 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 1 0 0 0 1 0 \n0 0 1 0 0 0 0 0 0 1 "
 & "0 0 0 0 0 0 0 0 0 1 0 0 1 0 0 0 0 1 0 0 0 0 0 0 0 \n0 0 0 1 0 0 1 0 0 0"
 & " 0 0 0 1 0 0 0 1 0 0 1 0 0 0 0 0 1 0 0 0 0 0 0 1 0 \n0 0 1 0 0 0 0 0 0 "
 & "0 0 1 0 0 0 0 0 0 0 1 0 0 0 0 0 0 1 0 0 0 1 0 0 0 1 \n0 0 0 0 1 0 0 0 0"
 & " 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 1 0 0 0 0 1 0 0 1 0 0 0 1 0 0 1 0 0 0 1 0 \n0 0 1 0 0 0 0 1"
 & " 0 0 0 1 0 0 1 0 0 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 0 0 0 \n0 0 0 0 1 0 0 "
 & "0 1 0 0 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 1 0 \n0 0 1 0 0 1 0"
 & " 0 0 0 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 \n0 1 0 0 1 0 "
 & "0 0 1 0 0 1 0 0 0 1 0 0 0 1 0 0 0 0 1 0 0 0 1 0 0 1 0 0 0 \n0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n1 1 1 1 0 "
 & "0 0 0 1 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 0 0 0 1 1 1 0 0 0 1 \n0 0 0 1 0"
 & " 0 0 1 0 0 0 1 1 1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 0 0 0 1 1 \n1 0 0 0 "
 & "0 1 1 1 0 0 0 0 1 1 1 0 0 0 0 1 1 1 1 0 0 1 0 0 0 0 0 0 1 1 1 \n0 0 0 1"
 & " 0 0 0 1 0 0 0 0 0 0 0 0 0 1 1 1 1 0 0 0 0 1 1 1 0 0 0 1 0 0 0 \n1 0 0 "
 & "0 0 1 1 0 0 0 1 1 1 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 \n0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 ";

CONST E4_14 = 
   "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 \n1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 ";

CONST E4_15 = 
   "0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 ";

CONST E5 = 
   "P4\n# created by \'xv <nil>\'\n24 17\n\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000>\000\000>\000\000>\000\000>\000\000>\000\017\377\370\003"
 & "\377\340\000\377\200\000>\000\000\010\000\000\000\000\000\000\000\000\000"
 & "\000";

CONST E6 = 
   "P4\n# created by \'xv /tmp_mnt/bamboozle/r/dlusers6/bharat/m3/Dialog/sr"
 & "c/ui/blank2.pbm\'\n2 2\n??";


BEGIN
END FormsVBTPixmapsBundle.
