(* Copyright 1992 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)
(* Example.i3 *)
(* Last modified on Wed Feb 23 18:15:10 PST 1994 by wobber  *)
(*      modified on Sat Dec  5 17:48:18 1992 by gnelson *)
(* This is an example of an interface that defines a network object type. *)

INTERFACE Example;

IMPORT NetObj, Thread;

EXCEPTION Invalid;

TYPE
  T = NetObj.T OBJECT METHODS
     get(key: TEXT) : TEXT
       RAISES {Invalid, NetObj.Error, Thread.Alerted};
     put(key: TEXT; value: TEXT)
       RAISES {Invalid, NetObj.Error, Thread.Alerted};
  END;

END Example.

(* Notice that the object methods must raise "NetObj.Error" or else 
   communications failures will be treated as checked runtime errors.  
   Also notice that "Thread.Alerted" is present in the "RAISES" clause 
   of all methods.  This is not required, but is strongly advised.  
   If "Thread.Alerted" is not propagated then not only is it impossible 
   to alert remote invocations, but the server implementation must 
   guarantee that "Alerted" will never be raised.  This guarantee 
   must hold even though the network object runtime uses "Thread.Alert" 
   to recover server threads when the client address space dies. *)
