#! moat
#
# Font selection demo.
################# Create the interface ###################
xtAppInitialize

xmForm .top managed \
	-marginHeight 10 -marginWidth 10 \
	-spacing 10 \

xmScrolledList .top.fonts managed \
	-visibleItemCount 10 \
	-listSizePolicy variable

xmLabel .top.text managed \
	-topAttachment widget_atachment -topWidget .top.fonts \
	-labelString "\
THE QUICK BROWN FOX JUMPS OVER THE LAZY DOG,
the quick brown fox jumps over the lazy dog.
0123456789"

.top.fonts defaultActionCallback {
	puts "Selecting font %item"
	.top.text setValues -fontList "%item"
}

xmPushButton .top.quit managed \
	-x 200 -y 250 \
	-labelString "Quit"
.top.quit activateCallback {exit 0}

############### Read font list ##############################

set font [open "/usr/lib/X11/fonts/75dpi/fonts.dir" r]
set fonts {}
foreach line [lrange [split [read $font nonewline] "\n"] 1 1000] {
	set f [lrange $line 1 100]
	lappend fonts $f
}
foreach f [lsort $fonts] {
	.top.fonts addItem $f 0
}
#############################################################

. realizeWidget
. mainLoop
