/*
 *  linux/fs/msdos/namei.c
 *
 *  Written 1992,1993 by Werner Almesberger
 */

#ifdef MODULE
#include <linux/module.h>
#endif

#include <asm/segment.h>

#include <linux/sched.h>
#include <linux/msdos_fs.h>
#include <linux/kernel.h>
#include <linux/errno.h>
#include <linux/string.h>
#include <linux/stat.h>

#include "msbuffer.h"

/* Begin GV Added Code +++ */
#include "lfn.h"
int msdos_scan_lfn(struct inode *dir,char *name,struct buffer_head **res_bh,
    struct msdos_dir_entry **res_de,int *ino,const char *longname,int lenlfn,
    int *piCount,int *piEntry,int *piNbLfnEntry);
int msdos_write_lfn_entry(struct inode *dir,const char* longname,int lenlfn,
        BYTE bCheckSum,int iCount,int iEntry);

/* End GV Added Code +++ */

#define PRINTK(x)

/* MS-DOS "device special files" */

static char *reserved_names[] = {
    "CON     ","PRN     ","NUL     ","AUX     ",
    "LPT1    ","LPT2    ","LPT3    ","LPT4    ",
    "COM1    ","COM2    ","COM3    ","COM4    ",
    NULL };


/* Characters that are undesirable in an MS-DOS file name */
  
static char bad_chars[] = "*?<>|\"";
static char bad_if_strict[] = "+=,; ";


/* Formats an MS-DOS file name. Rejects invalid names. */
/* conv : methode de conversion (?)
   name = nom (long?) original, len : longeur de name, res : pointer dur les 11 char
  du 8.3 */

/*
static int msdos_format_name(char conv,const char *name,int len,char *res,
  int dot_dirs)
{
	char *walk,**reserved;
	unsigned char c;
	int space;

	if (IS_FREE(name)) return -EINVAL;
	if (name[0] == '.' && (len == 1 || (len == 2 && name[1] == '.'))) {
		if (!dot_dirs) return -EEXIST;
		memset(res+1,' ',10);
		while (len--) *res++ = '.';
		return 0;
	}
	space = 1; / * disallow names starting with a dot * /
	c = 0;
	for (walk = res; len && walk-res < 8; walk++) {
	    	c = *name++;
		len--;
		if (conv != 'r' && strchr(bad_chars,c)) return -EINVAL;
		if (conv == 's' && strchr(bad_if_strict,c)) return -EINVAL;
  		if (c >= 'A' && c <= 'Z' && conv == 's') return -EINVAL;
		if (c < ' ' || c == ':' || c == '\\') return -EINVAL;
		if (c == '.') break;
		space = c == ' ';
		*walk = c >= 'a' && c <= 'z' ? c-32 : c;
	}
	if (space) return -EINVAL;
	if (conv == 's' && len && c != '.') {
		c = *name++;
		len--;
		if (c != '.') return -EINVAL;
	}
	while (c != '.' && len--) c = *name++;
	if (c == '.') {
		while (walk-res < 8) *walk++ = ' ';
		while (len > 0 && walk-res < MSDOS_NAME) {
			c = *name++;
			len--;
			if (conv != 'r' && strchr(bad_chars,c)) return -EINVAL;
			if (conv == 's' && strchr(bad_if_strict,c))
				return -EINVAL;
			if (c < ' ' || c == ':' || c == '\\' || c == '.')
				return -EINVAL;
			if (c >= 'A' && c <= 'Z' && conv == 's') return -EINVAL;
			space = c == ' ';
			*walk++ = c >= 'a' && c <= 'z' ? c-32 : c;
		}
		if (space) return -EINVAL;
		if (conv == 's' && len) return -EINVAL;
	}
	while (walk-res < MSDOS_NAME) *walk++ = ' ';
	for (reserved = reserved_names; *reserved; reserved++)
		if (!strncmp(res,*reserved,8)) return -EINVAL;
	return 0;
}
*/

/* Locates a directory entry. */

/* Begin GV Added Code +++ */

/* Formats an MS-DOS file name. Rejects invalid names. */
/* conv : methode de conversion (?)
   name = nom (long?) original, len : longeur de name, res : pointer sur
   les 11 char du 8.3 */
static int msdos_format_name_lfn(char conv,const char *name,int len,char *res,
  int dot_dirs,char *pcMinMajinfo, int *piGoodLfn,int *piNeedTail)
{
	char *walk,**reserved;
	unsigned char c;
	int space;
        int iExistNameMaj, iExistNameMin, iExistExtMaj,iExistExtMin;
        int iRet=0;

        iExistNameMaj = iExistNameMin = iExistExtMaj = iExistExtMin = 0;
        *pcMinMajinfo = '\0';
        *piGoodLfn=0;
        if (piNeedTail != NULL) *piNeedTail=0;

	if (IS_FREE(name)) return -EINVAL;
	if (name[0] == '.' && (len == 1 || (len == 2 && name[1] == '.'))) {
		if (!dot_dirs) return -EEXIST;
		memset(res+1,' ',10);
		while (len--) *res++ = '.';
                *piGoodLfn=1;
		return 0;
	}

        while (((*name)=='.') && len)
          {
            name++;
            len--,
            iRet=-EINVAL;
          }
	space = 1; /* disallow names starting with a dot */
	c = 0;
	for (walk = res; len && walk-res < 8; walk++) {
	    	c = *name++;
		len--;
                space = c == ' ';
		if (conv != 'r' && strchr(bad_chars,c)) return -EINVAL;
                if (space)
                  iRet = -EINVAL;
                else
		  if (conv == 's' && strchr(bad_if_strict,c)) return -EINVAL;
  		/*if (c >= 'A' && c <= 'Z' && conv == 's') return -EINVAL;*/
                if (c >= 'A' && c <= 'Z') iExistNameMaj = 1;
                if (c >= 'a' && c <= 'z') iExistNameMin = 1;
		if (c < ' ' || c == ':' || c == '\\') return -EINVAL;
		if (c == '.') break;		
		*walk = c >= 'a' && c <= 'z' ? c-32 : c;
	}
	if (space) iRet= -EINVAL;
	if (/*conv == 's' && */len && c != '.') {
		c = *name++;
		len--;		
	}
	while (c != '.' && len) 
	  {
	    c = *name++;
            iRet = -EINVAL;
            len--;
          }
	if (c == '.') {
		while (walk-res < 8) *walk++ = ' ';
                {
                int i=1;
                int inclen=0;
                 while (i<len)
                   {
                     if ((*(name+i))=='.')
                       {
                         inclen=i+1;
                         iRet=-EINVAL;
                       }
                     i++;
                   }
                 name+=inclen;
                 len-=inclen;
                }
		while (len > 0 && walk-res < MSDOS_NAME) {
			c = *name++;
			len--;
			space = c == ' ';
			if (conv != 'r' && strchr(bad_chars,c)) return -EINVAL;
                        if (space)
                          iRet = -EINVAL;
                        else
			  if (conv == 's' && strchr(bad_if_strict,c))
				return -EINVAL;
			if (c < ' ' || c == ':' || c == '\\' || c == '.')
				return -EINVAL;
			/*if (c >= 'A' && c <= 'Z' && conv == 's') return -EINVAL;*/
			if (c >= 'A' && c <= 'Z') iExistExtMaj = 1;
			if (c >= 'a' && c <= 'z') iExistExtMin = 1;
			*walk++ = c >= 'a' && c <= 'z' ? c-32 : c;
		}
		if (space) iRet= -EINVAL;
		if (/*conv == 's' &&*/ len) iRet = -EINVAL;
	}
	while (walk-res < MSDOS_NAME) *walk++ = ' ';
	for (reserved = reserved_names; *reserved; reserved++)
		if (!strncmp(res,*reserved,8)) return -EINVAL;


	if ((piNeedTail	!= NULL) && (iRet!=0))
          *piNeedTail=1;
        if (iExistExtMaj && iExistExtMin)
          iRet = -EINVAL;
        if (iExistNameMaj && iExistNameMin)
          iRet = -EINVAL;
        *piGoodLfn = iRet<0;
        if (iExistNameMin) *pcMinMajinfo |= 0x08;
        if (iExistExtMin)  *pcMinMajinfo |= 0x10;
	return iRet;
}

static void tailname(char *msdos_name, int iNbTrail)
{
int i,pos;
  for (i=0;i<8;i++)
    if ((*(msdos_name+i))== ' ')
      *(msdos_name+i)='_';

  pos=7;
  while (iNbTrail || (pos==7))
    {
    int digit = iNbTrail % 10;
      *(msdos_name+pos)=(char)(digit+'0');
      pos--;
      iNbTrail = (iNbTrail-digit)/10;
    }
  *(msdos_name+pos)='~';
}

static int msdos_find(struct inode *dir,const char *name,int len,
    struct buffer_head **bh,struct msdos_dir_entry **de,int *ino,
    int *piCount,int *piEntry,int *piNbLfnEntry)
{
	char msdos_name[MSDOS_NAME];
	int res;
        char cMinMajInfo;
        int iGoodLfn;

	res = msdos_format_name_lfn(MSDOS_SB(dir->i_sb)->name_check,name,len,
	    msdos_name,1,&cMinMajInfo,&iGoodLfn,NULL);

if ((res<0) && (iGoodLfn==0)) return res;

	return msdos_scan_lfn(dir,msdos_name,bh,de,ino,name,len,piCount,piEntry,piNbLfnEntry);
/*
	if (res >= 0) 
          return msdos_scan_lfn(dir,msdos_name,bh,de,ino,name,len,piCount,piEntry,piNbLfnEntry);
        if (iGoodLfn)
	  return msdos_scan_lfn(dir,NULL,bh,de,ino,name,len,piCount,piEntry,piNbLfnEntry);*/
        return res;	
}
/* End GV Added Code +++ */
/* Begin GV Removed Code +++ *
static int msdos_find(struct inode *dir,const char *name,int len,
    struct buffer_head **bh,struct msdos_dir_entry **de,int *ino)
{
	char msdos_name[MSDOS_NAME];
	int res;

	if ((res = msdos_format_name(MSDOS_SB(dir->i_sb)->name_check,name,len,
	    msdos_name,1)) < 0) return res;
	return msdos_scan(dir,msdos_name,bh,de,ino);
}
 * End GV Removed Code +++ */


int msdos_lookup(struct inode *dir,const char *name,int len,
    struct inode **result)
{
	struct super_block *sb = dir->i_sb;
	int ino,res;
	struct msdos_dir_entry *de;
	struct buffer_head *bh;
	struct inode *next;
	
	PRINTK (("msdos_lookup\n"));

	*result = NULL;
	if (!dir) return -ENOENT;
	if (!S_ISDIR(dir->i_mode)) {
		iput(dir);
		return -ENOENT;
	}
	PRINTK (("msdos_lookup 2\n"));
	if (len == 1 && name[0] == '.') {
		*result = dir;
		return 0;
	}
	if (len == 2 && name[0] == '.' && name[1] == '.') {
		ino = msdos_parent_ino(dir,0);
		iput(dir);
		if (ino < 0) return ino;
		if (!(*result = iget(dir->i_sb,ino))) return -EACCES;
		return 0;
	}
	PRINTK (("msdos_lookup 3\n"));
	if ((res = msdos_find(dir,name,len,&bh,&de,&ino,NULL,NULL,NULL)) < 0) {
		iput(dir);
		return res;
	}
	PRINTK (("msdos_lookup 4\n"));
	if (bh) brelse(bh);
	PRINTK (("msdos_lookup 4.5\n"));
/* printk("lookup: ino=%d\n",ino); */
	if (!(*result = iget(dir->i_sb,ino))) {
		iput(dir);
		return -EACCES;
	}
	PRINTK (("msdos_lookup 5\n"));
	if (MSDOS_I(*result)->i_busy) { /* mkdir in progress */
		iput(*result);
		iput(dir);
		return -ENOENT;
	}
	PRINTK (("msdos_lookup 6\n"));
	while (MSDOS_I(*result)->i_old) {
		next = MSDOS_I(*result)->i_old;
		iput(*result);
		if (!(*result = iget(next->i_sb,next->i_ino))) {
			fs_panic(dir->i_sb,"msdos_lookup: Can't happen");
			iput(dir);
			return -ENOENT;
		}
	}
	PRINTK (("msdos_lookup 7\n"));
	iput(dir);
	PRINTK (("msdos_lookup 8\n"));
	return 0;
}


/* Creates a directory entry (name is already formatted). */
/*
static int msdos_create_entry(struct inode *dir,char *name,int is_dir,
    struct inode **result)
{
	struct super_block *sb = dir->i_sb;
	struct buffer_head *bh;
	struct msdos_dir_entry *de;
	int res,ino;

	if ((res = msdos_scan(dir,NULL,&bh,&de,&ino)) < 0) {
		if (res != -ENOENT) return res;
		if (dir->i_ino == MSDOS_ROOT_INO) return -ENOSPC;
		if ((res = msdos_add_cluster(dir)) < 0) return res;
		if ((res = msdos_scan(dir,NULL,&bh,&de,&ino)) < 0) return res;
	}
	/ *
	 * XXX all times should be set by caller upon successful completion.
	 * /
	dir->i_ctime = dir->i_mtime = CURRENT_TIME;
	dir->i_dirt = 1;
	memcpy(de->name,name,MSDOS_NAME);
	memset(de->unused, 0, sizeof(de->unused));
	de->attr = is_dir ? ATTR_DIR : ATTR_ARCH;
	de->start = 0;
	date_unix2dos(dir->i_mtime,&de->time,&de->date);
	de->size = 0;
	mark_buffer_dirty(bh, 1);
	if ((*result = iget(dir->i_sb,ino)) != NULL)
		msdos_read_inode(*result);
	brelse(bh);
	if (!*result) return -EIO;
	(*result)->i_mtime = (*result)->i_atime = (*result)->i_ctime =
	    CURRENT_TIME;
	(*result)->i_dirt = 1;
	return 0;
} */

/*
int msdos_create_entrymm(struct inode *dir,char *name,int is_dir,
    struct inode **result,char cMinMajInfo)
{
	struct super_block *sb = dir->i_sb;
	struct buffer_head *bh;
	struct msdos_dir_entry *de;
	int res,ino;

	if ((res = msdos_scan(dir,NULL,&bh,&de,&ino)) < 0) {
		if (res != -ENOENT) return res;
		if (dir->i_ino == MSDOS_ROOT_INO) return -ENOSPC;
		if ((res = msdos_add_cluster(dir)) < 0) return res;
		if ((res = msdos_scan(dir,NULL,&bh,&de,&ino)) < 0) return res;
	}
	/ *
	 * XXX all times should be set by caller upon successful completion.
	 * /
	dir->i_ctime = dir->i_mtime = CURRENT_TIME;
	dir->i_dirt = 1;
	memcpy(de->name,name,MSDOS_NAME);
	memset(de->unused, 0, sizeof(de->unused));
	de->attr = is_dir ? ATTR_DIR : ATTR_ARCH;
	de->start = 0;
	date_unix2dos(dir->i_mtime,&de->time,&de->date);
	de->size = 0;
	de->unused[0]=cMinMajInfo;
	mark_buffer_dirty(bh, 1);
	if ((*result = iget(dir->i_sb,ino)) != NULL)
		msdos_read_inode(*result);
	brelse(bh);
	if (!*result) return -EIO;
	(*result)->i_mtime = (*result)->i_atime = (*result)->i_ctime =
	    CURRENT_TIME;
	(*result)->i_dirt = 1;
	return 0;
}
*/
static int msdos_create_entry_lfn(struct inode *dir,char *name,int is_dir,
    struct inode **result,char cMinMajInfo,int iAddLfnEntry,
    const char* longname,int lenlongname,int iNeedTail)
{
	struct super_block *sb = dir->i_sb;
	struct buffer_head *bh;
	struct msdos_dir_entry *de;
	int res,ino;
        int iNbEntry;
        int iCount,iEntry;
        BYTE bCheckSum;
	
	if (iAddLfnEntry && iNeedTail)
          {
          int nbTail=1;
            do
              {
	        tailname(name,nbTail++);
              } while (msdos_scan_lfn(dir,name,NULL,NULL,&ino,NULL,0,NULL,NULL,NULL)>=0);
           }

        iNbEntry = 1 + (iAddLfnEntry ? GetNbLfnEntry(lenlongname) : 0);

	if ((res = msdos_scan_lfn(dir,NULL,&bh,&de,&ino,NULL,iNbEntry,&iCount,&iEntry,NULL)) < 0) {
		if (res != -ENOENT) 
		  {
                    if (bh) brelse(bh);
		    return res;
                  }
		if (dir->i_ino == MSDOS_ROOT_INO) 
		  {
                    if (bh) brelse(bh);
		    return -ENOSPC;
                  }
		if ((res = msdos_add_cluster(dir)) < 0) 
		  {
                    if (bh) brelse(bh);
		    return res;
                  }
		if ((res = msdos_scan_lfn(dir,NULL,&bh,&de,&ino,NULL,iNbEntry,&iCount,&iEntry,NULL)) < 0) 
		  {
                    if (res == -ENOENT)
                      {
                      	if ((res = msdos_add_cluster(dir)) < 0) return res;
      		          {
                                if (bh) brelse(bh);
		                return res;
                          }
		        res = msdos_scan_lfn(dir,NULL,&bh,&de,&ino,NULL,iNbEntry,&iCount,&iEntry,NULL);
                      }
                    if (res<0)
		        {
                          if (bh) brelse(bh);
		          return res;
                        }
		  }
	}
	/*
	 * XXX all times should be set by caller upon successful completion.
	 */
	dir->i_ctime = dir->i_mtime = CURRENT_TIME;
	dir->i_dirt = 1;
	memcpy(de->name,name,MSDOS_NAME);
	memset(de->unused, 0, sizeof(de->unused));
	de->attr = is_dir ? ATTR_DIR : ATTR_ARCH;
	de->start = 0;
	date_unix2dos(dir->i_mtime,&de->time,&de->date);
	de->size = 0;
        de->unused[0]=cMinMajInfo;
	mark_buffer_dirty(bh, 1);
	if ((*result = iget(dir->i_sb,ino)) != NULL)
		msdos_read_inode(*result);
	brelse(bh);
	if (!*result) return -EIO;
	(*result)->i_mtime = (*result)->i_atime = (*result)->i_ctime =
	    CURRENT_TIME;
	(*result)->i_dirt = 1;
        bCheckSum = ChkSum(name);
        if (iAddLfnEntry)
          msdos_write_lfn_entry(dir,longname,lenlongname,bCheckSum,iCount,iEntry);

	return 0;
}

/* Creates a directory entry (name is already formatted). */

/*
int msdos_create(struct inode *dir,const char *name,int len,int mode,
	struct inode **result)
{
	struct super_block *sb = dir->i_sb;
	struct buffer_head *bh;
	struct msdos_dir_entry *de;
	char msdos_name[MSDOS_NAME];
	int ino,res;

	if (!dir) return -ENOENT;
	if ((res = msdos_format_name(MSDOS_SB(dir->i_sb)->name_check,name,len,
	    msdos_name,0)) < 0) {
		iput(dir);
		return res;
	}
	lock_creation();
	if (msdos_scan(dir,msdos_name,&bh,&de,&ino) >= 0) {
		unlock_creation();
		brelse(bh);
		iput(dir);
		return -EEXIST;
 	}
	res = msdos_create_entry(dir,msdos_name,S_ISDIR(mode),result);
	unlock_creation();
	iput(dir);
	return res;
}
*/


int msdos_create(struct inode *dir,const char *name,int len,int mode,
	struct inode **result)
{
	struct super_block *sb = dir->i_sb;
	struct buffer_head *bh;
	struct msdos_dir_entry *de;
	char msdos_name[MSDOS_NAME];
	int ino,res;
        char cMinMajInfo;
        int iGoodLfn;
        int iNeedTail;

	if (!dir) return -ENOENT;
	res = msdos_format_name_lfn(MSDOS_SB(dir->i_sb)->name_check,name,len,
	    msdos_name,0,&cMinMajInfo,&iGoodLfn,&iNeedTail);
	if ((res < 0) && (!iGoodLfn)) {
		iput(dir);
		return res;
	}

	  lock_creation();
	  if (msdos_scan_lfn(dir,msdos_name,&bh,&de,&ino,name,len,NULL,NULL,NULL) >= 0) 
	    {
	  	unlock_creation();
		brelse(bh);
		iput(dir);
		return -EEXIST;
 	    }
          brelse(bh);
	  res = msdos_create_entry_lfn(dir,msdos_name,S_ISDIR(mode),result,
	                               cMinMajInfo,iGoodLfn,name,len,iNeedTail);
	  iput(dir);
	  unlock_creation();
	  return res;
}


#ifdef DEBUG

static void dump_fat(struct super_block *sb,int start)
{
	printk("[");
	while (start) {
		printk("%d ",start);
        	start = fat_access(sb,start,-1);
		if (!start) {
			printk("ERROR");
			break;
		}
		if (start == -1) break;
	}
	printk("]\n");
}

#endif

/* Creates a directory entry (name is already formatted). */

/*
int msdos_mkdir(struct inode *dir,const char *name,int len,int mode)
{
	struct super_block *sb = dir->i_sb;
	struct buffer_head *bh;
	struct msdos_dir_entry *de;
	struct inode *inode,*dot;
	char msdos_name[MSDOS_NAME];
	int ino,res;

	if ((res = msdos_format_name(MSDOS_SB(dir->i_sb)->name_check,name,len,
	    msdos_name,0)) < 0) {
		iput(dir);
		return res;
	}
	lock_creation();
	if (msdos_scan(dir,msdos_name,&bh,&de,&ino) >= 0) {
		unlock_creation();
		brelse(bh);
		iput(dir);
		return -EEXIST;
 	}
	if ((res = msdos_create_entry(dir,msdos_name,1,&inode)) < 0) {
		unlock_creation();
		iput(dir);
		return res;
	}
	dir->i_nlink++;
	inode->i_nlink = 2; / * no need to mark them dirty * /
	MSDOS_I(inode)->i_busy = 1; / * prevent lookups * /
	if ((res = msdos_add_cluster(inode)) < 0) goto mkdir_error;
	if ((res = msdos_create_entry(inode,MSDOS_DOT,1,&dot)) < 0)
		goto mkdir_error;
	dot->i_size = inode->i_size; / * doesn't grow in the 2nd create_entry * /
	MSDOS_I(dot)->i_start = MSDOS_I(inode)->i_start;
	dot->i_nlink = inode->i_nlink;
	dot->i_dirt = 1;
	iput(dot);
	if ((res = msdos_create_entry(inode,MSDOS_DOTDOT,1,&dot)) < 0)
		goto mkdir_error;
	unlock_creation();
	dot->i_size = dir->i_size;
	MSDOS_I(dot)->i_start = MSDOS_I(dir)->i_start;
	dot->i_nlink = dir->i_nlink;
	dot->i_dirt = 1;
	MSDOS_I(inode)->i_busy = 0;
	iput(dot);
	iput(inode);
	iput(dir);
	return 0;
mkdir_error:
	iput(inode);
	if (msdos_rmdir(dir,name,len) < 0)
		fs_panic(dir->i_sb,"rmdir in mkdir failed");
	unlock_creation();
	return res;
}
*/
int msdos_mkdir(struct inode *dir,const char *name,int len,int mode)
{
	struct super_block *sb = dir->i_sb;
	struct buffer_head *bh;
	struct msdos_dir_entry *de;
	struct inode *inode,*dot;
	char msdos_name[MSDOS_NAME];
	int ino,res;
        char cMinMajInfo;
        int iGoodLfn;
        int iNeedTail;

	if (!dir) return -ENOENT;
	res = msdos_format_name_lfn(MSDOS_SB(dir->i_sb)->name_check,name,len,
	    msdos_name,0,&cMinMajInfo,&iGoodLfn,&iNeedTail);
	if ((res < 0) && (!iGoodLfn)) {
		iput(dir);
		return res;
	}       

	  lock_creation();
	  if (msdos_scan_lfn(dir,msdos_name,&bh,&de,&ino,name,len,NULL,NULL,NULL) >= 0) 
	    {
	  	unlock_creation();
		brelse(bh);
		iput(dir);
		return -EEXIST;
 	    }
	  res = msdos_create_entry_lfn(dir,msdos_name,1,&inode,cMinMajInfo,iGoodLfn,name,len,iNeedTail);
/*
	if ((res = msdos_format_name(MSDOS_SB(dir->i_sb)->name_check,name,len,
	    msdos_name,0)) < 0) {
		iput(dir);
		return res;
	}
	lock_creation();
	if (msdos_scan(dir,msdos_name,&bh,&de,&ino) >= 0) {
		unlock_creation();
		brelse(bh);
		iput(dir);
		return -EEXIST;
 	}
	if ((res = msdos_create_entry(dir,msdos_name,1,&inode)) < 0) {*/
        if (res < 0) {
		unlock_creation();
		iput(dir);
                brelse(bh);
		return res;
	}
	dir->i_nlink++;
	inode->i_nlink = 2; /* no need to mark them dirty */
	MSDOS_I(inode)->i_busy = 1; /* prevent lookups */
	if ((res = msdos_add_cluster(inode)) < 0) goto mkdir_error;
	if ((res = msdos_create_entry_lfn(inode,MSDOS_DOT,1,&dot,0,0,".",1,0)) < 0)
		goto mkdir_error;
	dot->i_size = inode->i_size; /* doesn't grow in the 2nd create_entry */
	MSDOS_I(dot)->i_start = MSDOS_I(inode)->i_start;
	dot->i_nlink = inode->i_nlink;
	dot->i_dirt = 1;
	iput(dot);
	if ((res = msdos_create_entry_lfn(inode,MSDOS_DOTDOT,1,&dot,0,0,"..",2,0)) < 0)
		goto mkdir_error;
	unlock_creation();
	dot->i_size = dir->i_size;
	MSDOS_I(dot)->i_start = MSDOS_I(dir)->i_start;
	dot->i_nlink = dir->i_nlink;
	dot->i_dirt = 1;
	MSDOS_I(inode)->i_busy = 0;
	iput(dot);
	iput(inode);
	iput(dir);
	return 0;
mkdir_error:
	iput(inode);
	if (msdos_rmdir(dir,name,len) < 0)
		fs_panic(dir->i_sb,"rmdir in mkdir failed");
	unlock_creation();
	return res;
}


static int msdos_empty(struct inode *dir)
{
	struct super_block *sb = dir->i_sb;
	loff_t pos;
	struct buffer_head *bh;
	struct msdos_dir_entry *de;

	if (dir->i_count > 1)
		return -EBUSY;
	if (MSDOS_I(dir)->i_start) { /* may be zero in mkdir */
		pos = 0;
		bh = NULL;
		while (msdos_get_entry(dir,&pos,&bh,&de) > -1)
/*
			if (!IS_FREE(de->name) && strncmp(de->name,MSDOS_DOT,
			    MSDOS_NAME) && strncmp(de->name,MSDOS_DOTDOT,
			    MSDOS_NAME)) {*/

			if (!IS_FREE(de->name) && strncmp(de->name,MSDOS_DOT,
			    MSDOS_NAME) && strncmp(de->name,MSDOS_DOTDOT,
			    MSDOS_NAME) && (!IsValidLfnEntry(de))) {
				brelse(bh);
				return -ENOTEMPTY;
			}
		if (bh)
			brelse(bh);
	}
	return 0;
}


int msdos_rmdir(struct inode *dir,const char *name,int len)
{
	struct super_block *sb = dir->i_sb;
	int res,ino;
	struct buffer_head *bh;
	struct msdos_dir_entry *de;
	struct inode *inode;
        int iCount,iEntry,iNbLfnEntry;
        int iDoDelete=0;

	bh = NULL;
	inode = NULL;
	res = -EPERM;
        lock_creation();
	if (name[0] == '.' && (len == 1 || (len == 2 && name[1] == '.')))
		goto rmdir_done;
	if ((res = msdos_find(dir,name,len,&bh,&de,&ino,
	                      &iCount,&iEntry,&iNbLfnEntry)) < 0) 
	   goto rmdir_done;
	res = -ENOENT;
	if (!(inode = iget(dir->i_sb,ino))) goto rmdir_done;
	res = -ENOTDIR;
	if (!S_ISDIR(inode->i_mode)) goto rmdir_done;
	res = -EBUSY;
	if (dir->i_dev != inode->i_dev || dir == inode) goto rmdir_done;
	res = msdos_empty(inode);
	if (res)
		goto rmdir_done;
	inode->i_nlink = 0;
	inode->i_ctime = dir->i_ctime = dir->i_mtime = CURRENT_TIME;
	dir->i_nlink--;
	inode->i_dirt = dir->i_dirt = 1;
	de->name[0] = (__s8)DELETED_FLAG;
        iDoDelete=1;
	mark_buffer_dirty(bh, 1);
	res = 0;
rmdir_done:
	brelse(bh);
        if (iDoDelete && (iNbLfnEntry))
          msdos_write_lfn_entry(dir,NULL,iNbLfnEntry,0,iCount,iEntry);
        
	iput(dir);
	iput(inode);
        unlock_creation();
	return res;
}


static int msdos_unlinkx(
	struct inode *dir,
	const char *name,
	int len,
	int nospc)	/* Flag special file ? */
{
	struct super_block *sb = dir->i_sb;
	int res,ino;
	struct buffer_head *bh;
	struct msdos_dir_entry *de;
	struct inode *inode;
        int iCount,iEntry,iNbLfnEntry;
        int iDoDelete=0;
	bh = NULL;
	inode = NULL;
	if ((res = msdos_find(dir,name,len,&bh,&de,&ino,&iCount,&iEntry,&iNbLfnEntry)) < 0)
		goto unlink_done;
	if (!(inode = iget(dir->i_sb,ino))) {
		res = -ENOENT;
		goto unlink_done;
	}
	if (!S_ISREG(inode->i_mode) && nospc){
		res = -EPERM;
		goto unlink_done;
	}
	inode->i_nlink = 0;
	inode->i_ctime = dir->i_ctime = dir->i_mtime = CURRENT_TIME;
	MSDOS_I(inode)->i_busy = 1;
	inode->i_dirt = dir->i_dirt = 1;
	de->name[0] = (__s8)DELETED_FLAG;
        iDoDelete=1;
	mark_buffer_dirty(bh, 1);
unlink_done:
	brelse(bh);
        if (iDoDelete && (iNbLfnEntry))
          msdos_write_lfn_entry(dir,NULL,iNbLfnEntry,0,iCount,iEntry);
	iput(inode);
	iput(dir);
	return res;
}

int msdos_unlink(struct inode *dir,const char *name,int len)
{
	return msdos_unlinkx (dir,name,len,1);
}
/*
	Special entry for umsdos
*/
int msdos_unlink_umsdos(struct inode *dir,const char *name,int len)
{
	return msdos_unlinkx (dir,name,len,0);
}

static int rename_same_dir(struct inode *old_dir,char *old_name,
    struct inode *new_dir,char *new_name,struct buffer_head *old_bh,
    struct msdos_dir_entry *old_de,int old_ino,
    const char *oldlongname,int oldlonglen,
    const char *newlongname,int newlonglen,
    char cMinMajinfoOld,char cMinMajinfoNew,
    int iGoodLfnOld,int iGoodLfnNew,
    int iNeedTailOld,int iNeedTailNew,
    int iCountOld,int iEntryOld,int iNbLfnEntryOld)
{
	struct super_block *sb = old_dir->i_sb;
	struct buffer_head *new_bh;
	struct msdos_dir_entry *new_de;
	struct inode *new_inode,*old_inode;
	int new_ino,exists,error;
        int iCount,iEntry,iNbLfnEntry;

	/* if (!strncmp(old_name,new_name,MSDOS_NAME)) return 0; */
        if (oldlonglen==newlonglen)
          {
            if (!strncmp(oldlongname,newlongname,newlonglen)) return 0;
/*          int i;
            for (i=0;i<newlonglen;i++)
              {
              char c1 = *(oldlonglen+i);
              char c2 = *(newlonglen+i);
                  if (c1 >= 'A' && c1 <= 'Z') c1 += 32;
                  if (c2 >= 'A' && c2 <= 'Z') c2 += 32;
                  if (c1 != c2)
                    break;
              }
            if (i == newlonglen)            
              return 0;*/
          }
	exists = msdos_scan_lfn(new_dir,NULL,&new_bh,&new_de,&new_ino,
	                      newlongname,newlonglen,
	                      &iCount,&iEntry,&iNbLfnEntry) >= 0;
	if (*(unsigned char *) old_de->name == DELETED_FLAG) {
		if (exists) brelse(new_bh);
		return -ENOENT;
	}
	if (exists) {
		if (!(new_inode = iget(new_dir->i_sb,new_ino))) {
			brelse(new_bh);
			return -EIO;
		}
		error = S_ISDIR(new_inode->i_mode) ? (old_de->attr & ATTR_DIR) ?
		    msdos_empty(new_inode) : -EPERM : (old_de->attr & ATTR_DIR)
		    ? -EPERM : 0;
		if (error) {
			iput(new_inode);
			brelse(new_bh);
			return error;
		}
		if (S_ISDIR(new_inode->i_mode)) {
			new_dir->i_nlink--;
			new_dir->i_dirt = 1;
		}
		new_inode->i_nlink = 0;
		MSDOS_I(new_inode)->i_busy = 1;
		new_inode->i_dirt = 1;
		new_de->name[0] = (__s8)DELETED_FLAG;
		mark_buffer_dirty(new_bh, 1);
		iput(new_inode);
		brelse(new_bh);
                if (iNbLfnEntry)
                  msdos_write_lfn_entry(new_dir,NULL,iNbLfnEntry,0,iCount,iEntry);
	}
	memcpy(old_de->name,new_name,MSDOS_NAME);
        old_de->unused[0]=cMinMajinfoNew;
	mark_buffer_dirty(old_bh, 1);
	if (MSDOS_SB(old_dir->i_sb)->conversion == 'a') /* update binary info */
		if ((old_inode = iget(old_dir->i_sb,old_ino)) != NULL) {
			msdos_read_inode(old_inode);
			iput(old_inode);
		}
	return 0;
}


static int rename_diff_dir(struct inode *old_dir,char *old_name,
    struct inode *new_dir,char *new_name,struct buffer_head *old_bh,
    struct msdos_dir_entry *old_de,int old_ino,
    const char *oldlongname,int oldlonglen,
    const char *newlongname,int newlonglen,
    char cMinMajinfoOld,char cMinMajinfoNew,
    int iGoodLfnOld,int iGoodLfnNew,
    int iNeedTailOld,int iNeedTailNew,
    int iCountOld,int iEntryOld,int iNbLfnEntryOld)
{
	struct super_block *sb = old_dir->i_sb;
	struct buffer_head *new_bh,*free_bh,*dotdot_bh;
	struct msdos_dir_entry *new_de,*free_de,*dotdot_de;
	struct inode *old_inode,*new_inode,*free_inode,*dotdot_inode,*walk;
	int new_ino,free_ino,dotdot_ino;
	int error,exists,ino;
        int iCountExist,iEntryExist,iNbLfnEntryExist;
        int iCountFree,iEntryFree; /*iNbLfnEntryFree;*/

	if (old_dir->i_dev != new_dir->i_dev) return -EINVAL;
	if (old_ino == (int)(new_dir->i_ino)) return -EINVAL;
	if (!(walk = iget(new_dir->i_sb,new_dir->i_ino))) return -EIO;
	while (walk->i_ino != MSDOS_ROOT_INO) {
		ino = msdos_parent_ino(walk,1);
		iput(walk);
		if (ino < 0) return ino;
		if (ino == old_ino) return -EINVAL;
		if (!(walk = iget(new_dir->i_sb,ino))) return -EIO;
	}
	iput(walk);
	while ((error = msdos_scan_lfn(new_dir,NULL,&free_bh,&free_de,&free_ino,
	                   NULL,iGoodLfnNew ? (GetNbLfnEntry(newlonglen)+1) : 1,
	                   &iCountFree,&iEntryFree,NULL)) <
	     0) {
		if (error != -ENOENT) return error;
		error = msdos_add_cluster(new_dir);
		if (error) return error;
	}
	exists = msdos_scan_lfn(new_dir,new_name,&new_bh,&new_de,&new_ino,
	                         newlongname,newlonglen,
	                         &iCountExist,&iEntryExist,&iNbLfnEntryExist) >= 0;
	if (!(old_inode = iget(old_dir->i_sb,old_ino))) {
		brelse(free_bh);
		if (exists) brelse(new_bh);
		return -EIO;
	}
	if (*(unsigned char *) old_de->name == DELETED_FLAG) {
		iput(old_inode);
		brelse(free_bh);
		if (exists) brelse(new_bh);
		return -ENOENT;
	}
	new_inode = NULL; /* to make GCC happy */
	if (exists) {
		if (!(new_inode = iget(new_dir->i_sb,new_ino))) {
			iput(old_inode);
			brelse(new_bh);
			return -EIO;
		}
		error = S_ISDIR(new_inode->i_mode) ? (old_de->attr & ATTR_DIR) ?
		    msdos_empty(new_inode) : -EPERM : (old_de->attr & ATTR_DIR)
		    ? -EPERM : 0;
		if (error) {
			iput(new_inode);
			iput(old_inode);
			brelse(new_bh);
			return error;
		}
		new_inode->i_nlink = 0;
		MSDOS_I(new_inode)->i_busy = 1;
		new_inode->i_dirt = 1;
		new_de->name[0] = (__s8)DELETED_FLAG;
		mark_buffer_dirty(new_bh, 1);
	}
	memcpy(free_de,old_de,sizeof(struct msdos_dir_entry));
	memcpy(free_de->name,new_name,MSDOS_NAME);
        free_de->unused[0]=cMinMajinfoNew;
	if (!(free_inode = iget(new_dir->i_sb,free_ino))) {
		free_de->name[0] = (__s8)DELETED_FLAG;
/*  Don't mark free_bh as dirty. Both states are supposed to be equivalent. */
		brelse(free_bh);
		if (exists) {
			iput(new_inode);
			brelse(new_bh);
		}
		return -EIO;
	}
	if (exists && S_ISDIR(new_inode->i_mode)) {
		new_dir->i_nlink--;
		new_dir->i_dirt = 1;
	}
	msdos_read_inode(free_inode);
	MSDOS_I(old_inode)->i_busy = 1;
	cache_inval_inode(old_inode);
	old_inode->i_dirt = 1;
	old_de->name[0] = (__s8)DELETED_FLAG;
	mark_buffer_dirty(old_bh, 1);
	mark_buffer_dirty(free_bh, 1);



	if (!exists) iput(free_inode);
	else {
		MSDOS_I(new_inode)->i_depend = free_inode;
		MSDOS_I(free_inode)->i_old = new_inode;
		/* free_inode is put when putting new_inode */
		iput(new_inode);
		brelse(new_bh);
	}
	if (S_ISDIR(old_inode->i_mode)) {
		if ((error = msdos_scan(old_inode,MSDOS_DOTDOT,&dotdot_bh,
		    &dotdot_de,&dotdot_ino)) < 0) goto rename_done;
		if (!(dotdot_inode = iget(old_inode->i_sb,dotdot_ino))) {
			brelse(dotdot_bh);
			error = -EIO;
			goto rename_done;
		}
		dotdot_de->start = MSDOS_I(dotdot_inode)->i_start =
		    MSDOS_I(new_dir)->i_start;
		dotdot_inode->i_dirt = 1;
		mark_buffer_dirty(dotdot_bh, 1);
		old_dir->i_nlink--;
		new_dir->i_nlink++;
		/* no need to mark them dirty */
		dotdot_inode->i_nlink = new_dir->i_nlink;
		iput(dotdot_inode);
		brelse(dotdot_bh);
	}

	error = 0;
rename_done:
	brelse(free_bh);


        if (iGoodLfnNew)
          msdos_write_lfn_entry(new_dir,newlongname,newlonglen,
                         ChkSum((unsigned char*)new_name),iCountFree,iEntryFree);

        if (iNbLfnEntryExist && exists)
                   msdos_write_lfn_entry(new_dir,NULL,iNbLfnEntryExist,0,iCountExist,iEntryExist);

        if (iNbLfnEntryOld)
                   msdos_write_lfn_entry(old_dir,NULL,iNbLfnEntryOld,0,iCountOld,iEntryOld);

	iput(old_inode);
	return error;
}


int msdos_rename(struct inode *old_dir,const char *old_name,int old_len,
	struct inode *new_dir,const char *new_name,int new_len)
{
	struct super_block *sb = old_dir->i_sb;
	char old_msdos_name[MSDOS_NAME],new_msdos_name[MSDOS_NAME];
	struct buffer_head *old_bh;
	struct msdos_dir_entry *old_de;
	int old_ino,error,find_ino;
        int res;
        char cMinMajinfoOld,cMinMajinfoNew;
        int iGoodLfnOld,iGoodLfnNew;
        int iNeedTailOld,iNeedTailNew;
        int iCountOld,iEntryOld;
        int iNbLfnEntryOld,iNbLfnEntryNew;

	lock_creation();

	res = msdos_format_name_lfn(MSDOS_SB(old_dir->i_sb)->name_check,
	    old_name,old_len,old_msdos_name,1,
	    &cMinMajinfoOld,&iGoodLfnOld,&iNeedTailOld);
        error = ((res<0) && (iGoodLfnOld==0)) ;
	if (error) goto rename_done;

	res = msdos_format_name_lfn(MSDOS_SB(new_dir->i_sb)->name_check,
	    new_name,new_len,new_msdos_name,0,
	    &cMinMajinfoNew,&iGoodLfnNew,&iNeedTailNew);
        error = ((res<0) && (iGoodLfnNew==0)) ;
	if (error) goto rename_done;
        iNbLfnEntryNew = (iGoodLfnNew) ? GetNbLfnEntry(new_len) : 0;

	res = msdos_scan_lfn(old_dir,old_msdos_name,&old_bh,&old_de,&old_ino,
	    old_name,old_len,&iCountOld,&iEntryOld,&iNbLfnEntryOld) ;
        error = res < 0;
	if (error) goto rename_done;



	if (iGoodLfnNew && iNeedTailNew)
          {
          int nbTail=1;
            do
              {
	        tailname(new_msdos_name,nbTail++);
              } while (msdos_scan_lfn(new_dir,new_msdos_name,NULL,NULL,
                         &find_ino,NULL,0,NULL,NULL,NULL)>=0);
           }


	if ((old_dir == new_dir) && 
	   (iNbLfnEntryOld == iNbLfnEntryNew) &&
	   (iNbLfnEntryOld == 0))
		error = rename_same_dir(old_dir,old_msdos_name,new_dir,
		    new_msdos_name,old_bh,old_de,old_ino,
		    old_name,old_len,new_name,new_len,
		    cMinMajinfoOld,cMinMajinfoNew,
    		    iGoodLfnOld,iGoodLfnNew,
		    iNeedTailOld,iNeedTailNew,
		    iCountOld,iEntryOld,iNbLfnEntryOld);
	else error = rename_diff_dir(old_dir,old_msdos_name,new_dir,
		    new_msdos_name,old_bh,old_de,old_ino,
		    old_name,old_len,new_name,new_len,
		    cMinMajinfoOld,cMinMajinfoNew,
    		    iGoodLfnOld,iGoodLfnNew,
		    iNeedTailOld,iNeedTailNew,
		    iCountOld,iEntryOld,iNbLfnEntryOld);
	brelse(old_bh);
rename_done:
	iput(old_dir);
	iput(new_dir);
	unlock_creation();
	return error;
}
