/* Copyright (C) 1995 -- Joel Katz -- Stimpson@panix.com */
/* All rights reserved except as specified in included   */
/* file "main.c".                                        */

#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <pwd.h>

#define MAX_SECONDS 10
#define GRACE_PERIOD 3

struct passwd *pw;

char *ending(char *fnm)
{
 char *b=fnm+strlen(fnm)-1;
 while(*b!='/') 
 {
  b--;
  if(b<fnm) break;
 }
 b++;
 return b;
}

int pid;

void alm(int i)
{
 i++;
 signal(SIGINT,SIG_IGN); /* Don't want to kill ourselves */
 /* If we are running as root, we can't risk killing the pgrp as we */
 /* would kill inetd! We really should have our own pgrp -- FIXME   */
 if(getuid()&&geteuid()) kill(-getpgrp(), SIGINT);
  else kill(pid, SIGINT);
 sleep(GRACE_PERIOD);
 if(getuid()&&geteuid()) kill(-getpgrp(), SIGKILL);
  else kill(pid,SIGKILL);
 exit(0);
}

void call_program(char *fnm, char *param1, char *param2, char *param3)
{
 int i;
 char buf[8192],buf2[1024];
 getcwd(buf2,512);
 if(strlen(fnm)>500) return;
 strcat(buf2,"/");
 strcat(buf2,fnm);
 
 strcpy(buf,"\"");
 strcat(buf,buf2);
 strcat(buf,"\" \"");
 strcat(buf,param1);
 strcat(buf,"\" \"");
 strcat(buf,param2);
 if(param3!=NULL)
 {
  strcat(buf,"\" \"");
  strcat(buf,param3);
 }
 strcat(buf,"\"");
 fflush(stdout);
 fflush(stdin);
 if((pid=fork())==0)
 { /* Program inherits the socket */
  execl(pw->pw_shell,ending(pw->pw_shell),"-c",buf,NULL);
  printf("Finger: %s: no such user\n",param1);
  _exit(0); /* Should never happen */
 }
 signal(SIGALRM,alm);
 alarm(MAX_SECONDS);
 wait(NULL);
}
