/***
 *** Misc. stuff. & configuration
 ***/

#ifndef _MISC_H
#define _MISC_H

/*
 * If ALLOW_RESIZE is not defined, on-the-fly screen resizing will not work, but
 * it will at least compile and run on older kernels. It will also throw out
 * kernel version checking, and "stty"-type resizing. In short: anything to do
 * with resizing is out.
 */

#include <sys/types.h>
#include <linux/vt.h>        /* to check for VT_RESIZE */

#ifdef VT_RESIZE
#  define ALLOW_RESIZE
#endif

/*
 * Some general purpose stuff
 */

#ifndef TRUE
#define TRUE (1)
#endif
#ifndef FALSE
#define FALSE (0)
#endif
#ifndef UNDEFINED
#define UNDEFINED (-1)
#endif

#endif

