/***
 *** parse_opt.c: option parsing routine for SVGATextMode
 *** (c) 1995 Koen Gadeyne (kmg@barco.be)
 ***/


#include "misc.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "confdefs.h"
#include "configfile.h"
#include "messages.h"

int parse_opt(FILE* param_file, int chipset, char* str_chipset)
{
  const char *str_options[NUM_OPTIONS] = OPTION_STRINGS;
  const int str_allowedopts[NUM_CHIPSETS] = OPTIONS_ALLOWED;
  int optionmask, opt;
  char* arg_str;

  optionmask = 0;
  if ( (arg_str = findlabel(param_file, "Option", LABEL_OPTIONAL+LABEL_FROMSTART)) )
  {
    strtok(arg_str," ");  /* loose the 'Option' keyword */
    do
    { 
      if (!(arg_str=strtok(NULL," "))) PERROR(("Empty 'Option' line in config file '%s'.", ConfigFile));
      opt = findoption(arg_str, str_options, NUM_OPTIONS, "Option");
      if (opt >= NUM_OPTIONS) PERROR(("Illegal Option line in config file"));
      /* check if option allowed for selected chip set */
      if ( !(str_allowedopts[chipset] & (1<<opt)))
        PERROR(("Option '%s' not allowed for chipset '%s'.", str_options[opt], str_chipset));
      optionmask |= (1<<opt);  /* make optionvalues bitmask */
    } while ((arg_str = strtok(findlabel(param_file, "Option", LABEL_OPTIONAL+LABEL_FROMCURRENT)," ")));
  }
  PDEBUG(("Options selected (bit mask): 0x%x", optionmask));
  return(optionmask);
}
