/***
 *** tty resizing code for SVGATextMode.
 *** (c) 1995 Koen Gadeyne (kmg@barco.be)
 ***/

#ifndef _TTYRESIZE_H
#define TTYRESIZE_H

/* If we need __KERNEL__, include those headers first, because otherwise they'll be incompletely included. */
#define __KERNEL__
#include <linux/tty.h>	/* for MAX_NR_CONSOLES */
#undef __KERNEL__

#include <sys/types.h>
#include <linux/vt.h> 

#ifdef ALLOW_RESIZE

extern struct utsname my_utsname;
extern int kversion, kv_ver, kv_rel, kv_pl;

int opentty(char *devname);

int check_kernel_version(int req_ver, int req_rel, int req_pl, char* reason);

int do_VT_RESIZE(int cols, int rows, int resize1x1);

int do_VT_RESIZEX(int cols, int rows, int vlin, int clin, int vcol, int ccol, int allow1x1);

void resize_specified_vts(char terminaldevs[MAX_NR_CONSOLES][64], int numterminals, int cols, int rows);

void resize_active_vts(int cols, int rows);

#endif

int check_if_resize(int cols, int rows);

#endif


