#include <stdio.h>

struct stats{
  int n_read;
  int n_read_bounce;
  int readsize[129];
  int n_sgread;
  int sg_readsize[129];
  int sg_rdcompsize[129];
  int rd_discrep;
  int rd_discrep1;

  int n_write;
  int n_write_bounce;
  int writesize[129];
  int n_sgwrite;
  int sg_writesize[129];
  int sg_wrcompsize[129];
  int wr_discrep;
  int wr_discrep1;

  int buffer_stats[10];
} scsi_stats;

char * descrip[] = {
  "Attempts to generate cluster",
  "Attempts with no buffers already in memory",
  "Attempts create new cluster",
  "New clusters created",
  "Attempts to locate reassigned cluster",
  "Attempts to locate reassigned that fail",
  "Attempts to actually reuse cluster",
  "Attempts to reuse cluster on unshared page",
  "Attempts to reuse cluster that succeed",
  ""};

FILE * infile;

main(){
  int status, i;
  
  infile = fopen("/dev/sda2","r");

  status = ioctl(fileno(infile), 5, &scsi_stats);

  if(status){
    fprintf(stderr,"status from ioctl = %d\n", status);
    exit(1);
  };


  printf("Request size map:\n");
  printf(" #blk   sgread  sgwrite  read  write  sgcomprd  sgcompwr\n");
  for(i=0; i<129; i++){
    if(scsi_stats.readsize[i] || scsi_stats.writesize[i] ||
       scsi_stats.sg_readsize[i] || scsi_stats.sg_writesize[i] ||
       scsi_stats.sg_rdcompsize[i] || scsi_stats.sg_wrcompsize[i])
      printf("%3d  %6d  %6d  %6d  %6d  %6d  %6d\n", i, 
	     scsi_stats.sg_readsize[i], scsi_stats.sg_writesize[i],
	     scsi_stats.readsize[i], scsi_stats.writesize[i],
	     scsi_stats.sg_rdcompsize[i], scsi_stats.sg_wrcompsize[i]);
  }

  printf("Number of scatter-gather requests: %d  %d\n", scsi_stats.n_sgread, scsi_stats.n_sgwrite);
  printf("Number of regular requests: %d  %d\n", scsi_stats.n_read, scsi_stats.n_write);
  printf("Number of sectors directed through bounce buffers %d  %d\n", scsi_stats.n_read_bounce, scsi_stats.n_write_bounce);

  printf("Number of discrepancies %d %d\n", scsi_stats.rd_discrep, scsi_stats.wr_discrep);
  printf("Number of discrepancies (2) %d %d\n", scsi_stats.rd_discrep1, scsi_stats.wr_discrep1);
  printf("\n");
  for(i=0; i<10; i++)
    printf("%s: %d\n", descrip[i], scsi_stats.buffer_stats[i]);
  status = ioctl(fileno(infile), 4, &scsi_stats);
}

