/*	-*-C-*- (Just help Emacs)
**	Name	:	cyril
**	Date	:	Sat Jan 15 12:05:26 1994
**	Subjetc	:	The include file for dpt driver
**	File	:	dpt.h
**	Modif	:	Thu Aug 18 22:13:44 1994
**	Version	:	$Id: dpt.h,v 1.3 1994/09/22 19:51:31 cyril Exp $
*/

/*
** $Log: dpt.h,v $
 * Revision 1.3  1994/09/22  19:51:31  cyril
 * Good para now
 *
 * Revision 1.2  1994/08/18  22:57:39  cyril
 * Some New Define.
 *
 * Revision 1.1  1994/07/05  23:08:49  cyril
 * Every think in DMA mode
 * Cluster mode support
 * Cleanup and more
 *
*/

#include <linux/types.h> 
#include <linux/scsicam.h>

/*
** Some define 
*/

/* If you have more than One board */
/* #define DPT_MULTI  */

/* If You Have Some probleme at boot time */
/* #define DPT_NEED_RESET         */

/* If The default value are not set */
/* #define DPT_NEED_CONFIG */

/* Some Probleme of memory (not two much memory) and a board with cache */
/* #define DPT_MAX_MAILBOXE  */

/* Time Out Value Very large Value */
#define TIMEOUT 500

/* Max Command at boot Time Only except if the DPT_MAX_MAILBOXE */
#define DPT_MAILBOXES 32

/*Max SCATTER but only at boot time change with the value return by the board*/
#define DPT_SCATTER 16

/* Number of command by device */
#define DPT_CMDLUN 1

/*
** Register Def
*/

#define CMD             7
#define STATUS          7
#define RAS             8
#define REG_DATA        0
#define REG_DATA2       1
#define REG_SEE         6

#define REG_LOW         2
#define REG_LM          3
#define REG_MID         4
#define REG_MSB         5

/*
** Command
*/

#define DPT_SEND 0xFF
#define DPT_SET_CONFIG 0xFE
#define DPT_READ_CONFIG 0xFD
#define DPT_RESET 0xF9

/*
** The Info DMA Struct
*/

struct dpt_info {
  ulong  data_len ;
  ulong  sign ;

  unchar version:4,
                :4;

  unchar  ocsena:1,
         tarsup:1,
         :2,
         dmasup:1,
         drqvld:1,
         ata:1,
         haaval:1;
  
  ushort cp_pad_len ;
  ulong  host_adr ;
  ulong  cp_len ;
  ulong  sp_len ;
  ushort queue_len ;
  ushort nil ;
  ushort scatt_size;

  unchar  irq:4,
          irq_tr:1,
          second:1,
          drqx:2;

  unchar  sync;
  ushort filler[250];
};

/*
** The Dpt Config DMA
*/

struct dpt_config {
  ushort len;
  unchar edis:1,
         ocena:1,
         mdpena:1,
         tarena:1,
         nul:4;
  unchar zero;
}  ;

/*
** The Dpt SG
*/

struct sg {
  unsigned long adress;
  unsigned long len;
};


/*
** The DPT Command Block
*/

struct dpt_ccb_cp {

  unchar sreset:1,
         init:1,
         reqsen:1,
         sg:1,
         nul:1,
         intr:1,
         dout:1,
         din:1;

  unchar rsl;
  unchar unused[4];

  unchar phsunit:1,
         notused:7;

  unchar devadr;

  unchar lun:3,
         zero1:1,
         zero2:1,
         luntar:1,
         dispri:1,
         one:1;

  unchar mess1;
  unchar mess2;
  unchar mess3;
  unchar cdb[12];
  ulong  data_trans_len;
  ulong  vir_cp;
  ulong  data_adr;
  ulong  sp_adr;
  ulong  res_sens_adr;
};


/*
** The DPT SP Return strcut
*/

struct dpt_ccb_sp {

  unchar cont_stat:7,
         eoc:1;
  unchar scsi_stat;
  unchar nul1,nul2;
  ulong  inv_res_len;
  ulong  vir_cp;
  char  mess[12];
};

/*
** Declare All function
*/

int dpt_detect(Scsi_Host_Template *);
int dpt_command(Scsi_Cmnd *);
int dpt_queuecommand(Scsi_Cmnd *, void (*done)(Scsi_Cmnd *));
int dpt_abort(Scsi_Cmnd *);
const char *dpt_info(void);
int dpt_reset(Scsi_Cmnd *);
void dpt_intr(int);

/*
** Info for middle SCSI ware
*/


#define DPT {     NULL,\
		  "EATA  DPT Driver Version $Revision: 1.3 $",\
		  dpt_detect,	\
		  NULL,\
		  dpt_info, dpt_command,		\
		  dpt_queuecommand,			\
		  dpt_abort,				\
		  dpt_reset,				\
	          NULL,		                        \
		  scsicam_bios_param,                      \
		  DPT_MAILBOXES, 7, 60, DPT_CMDLUN \
		  , 0, 0, ENABLE_CLUSTERING }
