/*
      Copyright (C) 1993,1994 Jon Tombs.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 The entire guts of this program was written by dosemu, modified to
 record reads and writes to the ports in the 0x180-0x188 address space,
 while running the CMS program TAPE.EXE V2.0.5 supplied with the drive.

 Modified to use an array of addresses and generally cleaned up (made
 much shorter) 4 June 94, dosemu isn't that good at writing short code it
 would seem :-). Made independant of 0x180, but I doubt it will work
 at any other address.
 
 Modified for distribution with ftape source. 21 June 94, SJL.

 /home/cvs/zftape/fc-10.c,v
 root
 *
 1.1.1.1
 1995/11/15 16:55:46
 Exp
 *
 *      This file contains code for the CMS FC-10 card.
 */

static char RCSid[] = "fc-10.c,v 1.1.1.1 1995/11/15 16:55:46 root Exp";

#include "ftape.h"
#include <asm/io.h>

#include "fdc-io.h"
#include "fc-10.h"

#ifdef PROBE_FC10

/*  This code will only work if the FC-10 (or FC-20) is set to
 *  BASE = 0x180, IRQ = 2 and DMA = 3 because I suspect these
 *  settings to be hard coded in the selection sequence.
 *  Until someone finds out where and how we'll have to forbid
 *  other settings.
 */
#if (FDC_BASE != 0x180) || (FDC_IRQ != 9) || (FDC_DMA != 3)
# error - The FC-10 must be set to use i/o 180, irq 2 or 9 and dma 3 !
#endif

unsigned short inbs_magic[] = {
  0x3, 0x3, 0x0, 0x4, 0x7, 0x2, 0x5, 0x3, 0x1, 0x4,
  0x3, 0x5, 0x2, 0x0, 0x3, 0x7, 0x4, 0x2,
  0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7
};

int fc10_enable( void)
{
   int i;
   byte x;

   /*  Clear state machine ???
    */
   for (i = 0; i < NR_ITEMS( inbs_magic); i++) {
     inb( FDC_BASE + inbs_magic[ i]);
   }
   outb( 0x0, FDC_BASE);

   x = inb( FDC_BASE);
   if (x == 0x13 || x == 0x93) {
     for (i = 1; i < 8; i++) {
       if (inb( FDC_BASE + i) != x) {
         return 0;
       }
     }
   } else {
     return 0;
   }

   outb( 0x8, FDC_BASE);

   for (i = 0; i < 8; i++) {
     if (inb( FDC_BASE + i) != 0x0) {
       return 0;
     }
   }
   outb( 0x10, FDC_BASE);

   for (i = 0; i < 8; i++) {
     if (inb( FDC_BASE + i) != 0xff) {
       return 0;
     }
   }

   /*  Okay, we found a FC-10 card ! ???
    */
   outb( 0x0, fdc.ccr);

   /*  Clear state machine again ???
    */
   for (i = 0; i < NR_ITEMS( inbs_magic); i++) {
     inb( FDC_BASE + inbs_magic[ i]);
   }
   outb( 0xd1, FDC_BASE);

   /*  Enable FC-10 ???
    */
   outb( 0, fdc.ccr);
   outb( 0, FDC_BASE + 0x6);
   outb( 8, fdc.dor);
   outb( 8, fdc.dor);   
   outb( 1, FDC_BASE + 0x6);

   /*  Initialize fdc, select drive B:
    */
   outb( 0x08, fdc.dor);        /* assert reset, dma & irq enabled */
   outb( 0x0c, fdc.dor);        /* release reset */
   outb( 0x2d, fdc.dor);        /* select drive 1 */

   return (x == 0x93) ? 2 : 1;
}

#endif /* CMS_FC10_CONTROLLER*/

/*{{{}}}*/
