------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                      S Y S T E M . V A L _ E N U M                       --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.7 $                              --
--                                                                          --
--        Copyright (C) 1992,1993,1994 Free Software Foundation, Inc.       --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- It is now maintained by Ada Core Technologies Inc (http://www.gnat.com). --
--                                                                          --
------------------------------------------------------------------------------

package System.Val_Enum is
pragma Pure (Val_Enum);

   function Value_Enumeration
     (A        : Address;
      Last_Pos : Natural;
      Str      : String)
      return     Natural;
   --  Used in computing Enum'Value (Str) where Enum is some enumeration type
   --  other thanBoolean or Character. A is the address of the Lit_Name_Table,
   --  which is the table of access to strings, generated by Gigi for each
   --  enumeration type. The table is an array whose index values are 'Pos
   --  values and whose values are access to strings which are are the 'Image
   --  values. Last_Pos is the last index in the table for the enumeration
   --  type. This function will search the table looking for a match against
   --  Str, and if one is found the position number in the table is returned.
   --  If not, Constraint_Error is raised. Str may have leading and trailing
   --  spaces and may be in upper or lower case.

end System.Val_Enum;
